/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.listener;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import org.exoplatform.antimalware.service.MalwareDetectionService;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerBase;
import org.exoplatform.services.listener.ListenerService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Asynchronous
@Component
@Profile(value={"analytics"})
public class AntiMalwareAnalyticsListener
extends Listener<String, Object> {
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private MalwareDetectionService malwareDetectionService;
    private static final String SCAN_COMPLETED = "anti-malware-scan-completed";
    private static final String INFECTED_FILE_REMOVED = "anti-malware-infectedFile-removed";
    private static final String INFECTED_FILE_CLEANED = "infected-file-cleaned";
    private static final String INFECTED_FILE_NAME = "infectedItemName";
    private static final String INFECTED_FILE_LAST_MODIFIER = "infectedItemLastModifier";
    private static final String INFECTED_FILE_PATH = "infectedItemPath";
    public static final String INFECTED_FILE_ID = "infectedItemId";
    private final String[] eventTypes = new String[]{"anti-malware-scan-completed", "anti-malware-infectedFile-removed", "infected-file-cleaned"};

    @PostConstruct
    public void init() {
        for (String eventType : this.eventTypes) {
            this.listenerService.addListener(eventType, (ListenerBase)this);
        }
    }

    public void onEvent(Event<String, Object> event) throws Exception {
        if (event.getEventName().equals(SCAN_COMPLETED)) {
            String connectorType = (String)event.getSource();
            int infectedFilesCount = (Integer)event.getData();
            AntiMalwareAnalyticsListener.addAntimalwareScanStatistics(connectorType, infectedFilesCount);
        } else if (event.getEventName().equals(INFECTED_FILE_REMOVED) || event.getEventName().equals(INFECTED_FILE_CLEANED)) {
            String connectorType = this.malwareDetectionService.getDefaultMalwareDetectionConnector().getType();
            Map infectedItem = (Map)event.getData();
            AntiMalwareAnalyticsListener.addAntimalwareInfectedFileRemoveStatistics(connectorType, infectedItem);
        }
    }

    private static void addAntimalwareScanStatistics(String connectorType, int infectedFilesCount) {
        StatisticData scanStatistics = new StatisticData();
        scanStatistics.setModule("AntiMalware");
        scanStatistics.setOperation("antimalwareCheck");
        scanStatistics.addParameter("infectedFilesCount", (Object)infectedFilesCount);
        scanStatistics.addParameter("connectorType", (Object)connectorType);
        AnalyticsUtils.addStatisticData((StatisticData)scanStatistics);
    }

    private static void addAntimalwareInfectedFileRemoveStatistics(String connectorType, Map<String, String> infectedItem) {
        StatisticData fileRemovalStatistics = new StatisticData();
        fileRemovalStatistics.setModule("AntiMalware");
        fileRemovalStatistics.setOperation("InfectedFileRemoval");
        fileRemovalStatistics.addParameter("fileId", (Object)infectedItem.get(INFECTED_FILE_ID));
        fileRemovalStatistics.addParameter("fileName", (Object)infectedItem.get(INFECTED_FILE_NAME));
        fileRemovalStatistics.addParameter("filePath", (Object)infectedItem.get(INFECTED_FILE_PATH));
        fileRemovalStatistics.addParameter("fileAuthor", (Object)infectedItem.get(INFECTED_FILE_LAST_MODIFIER));
        fileRemovalStatistics.addParameter("connectorType", (Object)connectorType);
        AnalyticsUtils.addStatisticData((StatisticData)fileRemovalStatistics);
    }
}

