/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.rest;

import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.exoplatform.antimalware.rest.MalwareDetectionRestService;
import org.exoplatform.antimalware.service.MalwareDetectionService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MalwareDetectionRestServiceTest {
    @Mock
    private MalwareDetectionService malwareDetectionService;
    private MalwareDetectionRestService malwareDetectionRestService;

    @Before
    public void setUp() throws Exception {
        System.setProperty("exo.malwareDetection.passphrase", "test_pass_phrase");
        this.malwareDetectionRestService = new MalwareDetectionRestService(this.malwareDetectionService);
    }

    @Test
    public void processInfectedItems() throws Exception {
        List<String> infectedItemPaths = List.of("path1", "path2");
        Assert.assertThrows(WebApplicationException.class, () -> this.malwareDetectionRestService.processInfectedItems(infectedItemPaths, null));
        Response response1 = this.malwareDetectionRestService.processInfectedItems(infectedItemPaths, "test_pass_phrase");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        ((MalwareDetectionService)Mockito.verify((Object)this.malwareDetectionService, (VerificationMode)Mockito.times((int)2))).processInfectedItem(ArgumentMatchers.anyString());
    }
}

