/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.notification.plugin;

import org.exoplatform.antimalware.connector.MalwareDetectionItemConnector;
import org.exoplatform.antimalware.notification.plugin.MalwareDetectionPlugin;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MalwareDetectionPluginTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<ExoContainerContext> EXO_CONTAINER_CONTEXT = Mockito.mockStatic(ExoContainerContext.class);
    @Mock
    private InitParams initParams;
    private MalwareDetectionPlugin malwareDetectionPlugin;

    @AfterClass
    public static void afterRunBare() throws Exception {
        EXO_CONTAINER_CONTEXT.close();
        COMMONS_UTILS.close();
    }

    @Before
    public void setUp() throws Exception {
        this.malwareDetectionPlugin = new MalwareDetectionPlugin(this.initParams);
        EXO_CONTAINER_CONTEXT.when(() -> ExoContainerContext.getService(IDGeneratorService.class)).thenReturn(null);
    }

    @Test
    public void makeNotification() {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(MalwareDetectionItemConnector.INFECTED_ITEM_NAME_ARGUMENT, (Object)"file.docx");
        ctx.append(MalwareDetectionItemConnector.INFECTED_ITEM_LAST_MODIFIER_ARGUMENT, (Object)"user");
        NotificationInfo notificationInfo = this.malwareDetectionPlugin.makeNotification(ctx);
        Assert.assertEquals((Object)"file.docx", (Object)notificationInfo.getValueOwnerParameter(MalwareDetectionItemConnector.INFECTED_ITEM_NAME_ARGUMENT.getKey()));
        Assert.assertEquals((Object)"user", (Object)notificationInfo.getTo());
    }
}

