/*
 * Copyright (C) 2022 eXo Platform SAS
 *
 *  This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <gnu.org/licenses>.
 */
package org.exoplatform.antimalware.job;

import org.exoplatform.antimalware.service.MalwareDetectionService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class MalwareDetectionJob implements Job {
  private static final Log LOG = ExoLogger.getLogger(MalwareDetectionJob.class);

  @Override
  public void execute(JobExecutionContext context) throws JobExecutionException {

    MalwareDetectionService malwareDetectionService = CommonsUtils.getService(MalwareDetectionService.class);
    LOG.info("Start process malware detection");
    malwareDetectionService.checkAndProcessNewInfectedItems();
    LOG.info("End process malware detection");
  }

}
