/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.listener;

import io.meeds.analytics.model.StatisticData;
import io.meeds.analytics.utils.AnalyticsUtils;
import java.util.HashMap;
import org.exoplatform.antimalware.connector.MalwareDetectionConnector;
import org.exoplatform.antimalware.listener.AntiMalwareAnalyticsListener;
import org.exoplatform.antimalware.service.MalwareDetectionService;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.test.util.ReflectionTestUtils;

@RunWith(value=MockitoJUnitRunner.class)
public class AntiMalwareAnalyticsListenerTest {
    @Mock
    private ListenerService listenerService;
    @Mock
    private MalwareDetectionService malwareDetectionService;
    @InjectMocks
    private AntiMalwareAnalyticsListener listener;

    @Before
    public void setUp() {
        this.listener.init();
        ReflectionTestUtils.setField((Object)this.listener, (String)"malwareDetectionService", (Object)this.malwareDetectionService);
        MalwareDetectionConnector malwareDetectionConnector = (MalwareDetectionConnector)Mockito.mock(MalwareDetectionConnector.class);
        Mockito.when((Object)malwareDetectionConnector.getType()).thenReturn((Object)"type");
        Mockito.when((Object)this.malwareDetectionService.getDefaultMalwareDetectionConnector()).thenReturn((Object)malwareDetectionConnector);
    }

    @Test
    public void testOnEvent() throws Exception {
        String connectorType = "ClamAV";
        int infectedCount = 5;
        HashMap<String, String> infectedFile = new HashMap<String, String>();
        infectedFile.put("infectedItemId", "1");
        infectedFile.put("infectedItemName", "filetesteicar.txt");
        infectedFile.put("infectedItemLastModifier", "user");
        infectedFile.put("infectedItemPath", "path");
        Event event = new Event("anti-malware-scan-completed", (Object)connectorType, (Object)infectedCount);
        Event event1 = new Event("anti-malware-infectedFile-removed", (Object)"type", infectedFile);
        try (MockedStatic mockedStatic = Mockito.mockStatic(AnalyticsUtils.class);){
            ArgumentCaptor captor = ArgumentCaptor.forClass(StatisticData.class);
            this.listener.onEvent(event);
            mockedStatic.verify(() -> AnalyticsUtils.addStatisticData((StatisticData)((StatisticData)captor.capture())), Mockito.times((int)1));
            StatisticData data = (StatisticData)captor.getValue();
            Assert.assertEquals((Object)"AntiMalware", (Object)data.getModule());
            Assert.assertEquals((Object)"antimalwareCheck", (Object)data.getOperation());
            Assert.assertEquals((Object)String.valueOf(infectedCount), data.getParameters().get("infectedFilesCount"));
            Assert.assertEquals((Object)connectorType, data.getParameters().get("connectorType"));
            ArgumentCaptor captor1 = ArgumentCaptor.forClass(StatisticData.class);
            this.listener.onEvent(event1);
            mockedStatic.verify(() -> AnalyticsUtils.addStatisticData((StatisticData)((StatisticData)captor1.capture())), Mockito.times((int)2));
            StatisticData data1 = (StatisticData)captor1.getValue();
            Assert.assertEquals((Object)"AntiMalware", (Object)data1.getModule());
            Assert.assertEquals((Object)"InfectedFileRemoval", (Object)data1.getOperation());
            Assert.assertEquals((Object)String.valueOf(infectedFile.get("infectedItemId")), data1.getParameters().get("fileId"));
            Assert.assertEquals((Object)String.valueOf(infectedFile.get("infectedItemName")), data1.getParameters().get("fileName"));
            Assert.assertEquals((Object)String.valueOf(infectedFile.get("infectedItemLastModifier")), data1.getParameters().get("fileAuthor"));
            Assert.assertEquals((Object)String.valueOf(infectedFile.get("infectedItemPath")), data1.getParameters().get("filePath"));
            Assert.assertEquals((Object)"type", data1.getParameters().get("connectorType"));
        }
    }
}

