/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.connector;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.antimalware.connector.MalwareDetectionFilesConnector;
import org.exoplatform.commons.file.model.FileInfo;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MalwareDetectionFilesConnectorTest {
    @Mock
    private FileService fileService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private ListenerService listenerService;
    private MalwareDetectionFilesConnector malwareDetectionFilesConnector;

    @Before
    public void setUp() {
        InitParams params = new InitParams();
        PropertiesParam constructorParams = new PropertiesParam();
        constructorParams.setName("constructor.params");
        constructorParams.setProperty("type", "files");
        constructorParams.setProperty("enabled", "true");
        params.addParameter((Parameter)constructorParams);
        this.malwareDetectionFilesConnector = new MalwareDetectionFilesConnector(params, this.fileService, this.identityManager, this.listenerService);
    }

    @Test
    public void getInfectedItems() throws Exception {
        ArrayList<FileItem> infectedFileItems = new ArrayList<FileItem>();
        FileInfo fileInfo = new FileInfo(Long.valueOf(1L), "file", "application/pdf", "anyNameSpaceApp", 1253L, new Date(), "1", "62bea6cf7f000101262f2b4a4c7638680", false);
        FileItem fileItem = new FileItem(fileInfo.getId(), fileInfo.getName(), fileInfo.getMimetype(), fileInfo.getNameSpace(), fileInfo.getSize(), fileInfo.getUpdatedDate(), fileInfo.getUpdater(), fileInfo.isDeleted(), null);
        infectedFileItems.add(fileItem);
        Mockito.when((Object)this.fileService.getFilesByChecksum(ArgumentMatchers.anyString())).thenReturn(infectedFileItems);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"user");
        Mockito.when((Object)this.identityManager.getIdentity(Mockito.anyLong())).thenReturn((Object)identity);
        List infectedItems = this.malwareDetectionFilesConnector.getInfectedItems("gatein/8/c/d/8/62bea6cf7f000101262f2b4a4c7638680");
        Assert.assertEquals((long)1L, (long)infectedItems.size());
        Assert.assertEquals((Object)"1", ((Map)infectedItems.get(0)).get("infectedItemId"));
        Assert.assertEquals((Object)"file", ((Map)infectedItems.get(0)).get("infectedItemName"));
        Assert.assertEquals((Object)"user", ((Map)infectedItems.get(0)).get("infectedItemLastModifier"));
    }

    @Test
    public void canProcessInfectedItem() {
        Assert.assertFalse((boolean)this.malwareDetectionFilesConnector.canProcessInfectedItem("gatein/data/jcr/values/collaboration_portal8/c/d/8/62bea6cf7f000101262f2b4a4c7638680"));
        Assert.assertTrue((boolean)this.malwareDetectionFilesConnector.canProcessInfectedItem("gatein/data/files/8/c/d/8/62bea6cf7f000101262f2b4a4c7638680"));
    }

    @Test
    public void cleanInfectedItem() {
        HashMap<String, String> infectedItem = new HashMap<String, String>();
        infectedItem.put("infectedItemId", "1");
        infectedItem.put("infectedItemName", "file");
        infectedItem.put("infectedItemLastModifier", "user");
        this.malwareDetectionFilesConnector.cleanInfectedItem(infectedItem);
        ((FileService)Mockito.verify((Object)this.fileService, (VerificationMode)Mockito.times((int)1))).deleteFile(Long.parseLong((String)infectedItem.get("infectedItemId")));
    }
}

