/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.antimalware.connector;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.exoplatform.antimalware.connector.ClamAVMalwareDetectionConnector;
import org.exoplatform.antimalware.connector.MalwareDetectionConnector;
import org.exoplatform.antimalware.service.MalwareDetectionService;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.test.util.ReflectionTestUtils;

@ExtendWith(value={MockitoExtension.class})
class ClamAVMalwareDetectionConnectorTest {
    @InjectMocks
    private ClamAVMalwareDetectionConnector connector;
    @Mock
    private MalwareDetectionService malwareDetectionService;
    private Path tempReport;

    ClamAVMalwareDetectionConnectorTest() {
    }

    @AfterEach
    void cleanup() throws IOException {
        if (this.tempReport != null && Files.exists(this.tempReport, new LinkOption[0])) {
            Files.delete(this.tempReport);
        }
    }

    @Test
    void testInitRegistersConnector() {
        this.connector.init();
        ((MalwareDetectionService)Mockito.verify((Object)this.malwareDetectionService, (VerificationMode)Mockito.times((int)1))).addMalwareDetectionConnector((MalwareDetectionConnector)this.connector);
    }

    @Test
    void testGetInfectedItemsPathsWithReport() throws IOException {
        this.tempReport = Files.createTempFile("clamav_test", ".txt", new FileAttribute[0]);
        String content = "/tmp/malware.exe: FOUND\nC:\\Users\\John\\infected.doc: FOUND\n/tmp/cleanfile.txt: OK\n";
        Files.writeString(this.tempReport, (CharSequence)content, new OpenOption[0]);
        ReflectionTestUtils.setField((Object)this.connector, (String)"reportPath", (Object)this.tempReport.toString());
        List infected = this.connector.getInfectedItemsPaths();
        Assertions.assertEquals((int)2, (int)infected.size());
        Assertions.assertTrue((boolean)infected.contains("/tmp/malware.exe"));
        Assertions.assertTrue((boolean)infected.contains("C:\\Users\\John\\infected.doc"));
        Assertions.assertEquals((long)0L, (long)Files.size(this.tempReport), (String)"ClamAV report file should be truncated (empty) after reading");
    }

    @Test
    void testGetInfectedItemsPathsWithNonExistingFile() {
        ReflectionTestUtils.setField((Object)this.connector, (String)"reportPath", (Object)"/does/not/exist.txt");
        List infected = this.connector.getInfectedItemsPaths();
        Assertions.assertTrue((boolean)infected.isEmpty());
    }
}

