# Anti-Malware Add-on for eXo Platform

The Anti-Malware Add-on provides real-time and scheduled scanning of files stored in the platform, including filesystem content, JCR repositories, and integration with third-party antivirus services such as Trend Micro and ClamAV.  
It helps ensure that uploaded or stored content is safe and free from malware.

---

# Server Properties

## Scheduled Malware Detection Job

| Property | Default | Description |
|----------|---------|-------------|
| `exo.antiMalware.MalwareDetectionJob.period` | `1800000` (30 minutes) | Time in milliseconds between executions of the malware detection job. |

---

## Trend Micro Connector

| Property | Default | Description |
|----------|---------|-------------|
| `exo.malwareDetection.connector.trendMicro.isDefault` | `false` | Marks Trend Micro connector as the default malware detection connector. |

---

## ClamAV Connector

| Property | Default | Description |
|----------|---------|-------------|
| `exo.malwareDetection.connector.clamav.report.path` | `${exo.data.dir}/clamav-report.txt` | File path where ClamAV writes scan reports. |
| `exo.malwareDetection.connector.clamav.isDefault` | `false` | Marks ClamAV connector as the default malware detection connector. |

---

