/*
 * Copyright (C) 2025 eXo Platform SAS
 *
 *  This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <gnu.org/licenses>.
 */
package org.exoplatform.antimalware.listener;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.ArgumentLiteral;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.ListenerService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.*;
import org.mockito.junit.MockitoJUnitRunner;

import java.util.HashMap;
import java.util.Map;

import static org.mockito.Mockito.*;

@RunWith(MockitoJUnitRunner.class)
public class AntiMalwareNotificationListenerTest {

  @Mock
  private ListenerService                 listenerService;

  @InjectMocks
  private AntiMalwareNotificationListener listener;

  @Before
  public void setUp() {
    listener.init();
  }

  @Test
  public void testOnEvent_appendsArguments() throws Exception {
    Map<String, String> infectedItem = new HashMap<>();
    infectedItem.put("infectedItemName", "file.txt");
    infectedItem.put("infectedItemLastModifier", "john");

    NotificationContext ctxSpy = spy(NotificationContextImpl.cloneInstance());
    try (MockedStatic<NotificationContextImpl> ctxStatic = mockStatic(NotificationContextImpl.class)) {
      ctxStatic.when(NotificationContextImpl::cloneInstance).thenReturn(ctxSpy);

      Event<String, Object> event = new Event<>("infected-file-cleaned", null, infectedItem);
      listener.onEvent(event);

      verify(ctxSpy).append(eq(new ArgumentLiteral<>(String.class, "infectedItemName")), eq("file.txt"));
      verify(ctxSpy).append(eq(new ArgumentLiteral<>(String.class, "infectedItemLastModifier")), eq("john"));
    }
  }

}
