package org.exoplatform.antimalware.rest;

import org.exoplatform.antimalware.service.MalwareDetectionService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;

import java.util.List;

import static org.junit.Assert.*;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

@RunWith(MockitoJUnitRunner.class)
public class MalwareDetectionRestServiceTest {

  @Mock
  private MalwareDetectionService     malwareDetectionService;

  private MalwareDetectionRestService malwareDetectionRestService;

  @Before
  public void setUp() throws Exception {
    System.setProperty("exo.malwareDetection.passphrase", "test_pass_phrase");
    this.malwareDetectionRestService = new MalwareDetectionRestService(malwareDetectionService);

  }

  @Test
  public void processInfectedItems() throws Exception {
    List<String> infectedItemPaths = List.of("path1", "path2");
    assertThrows(WebApplicationException.class,
                 () -> this.malwareDetectionRestService.processInfectedItems(infectedItemPaths, null));
    Response response1 = malwareDetectionRestService.processInfectedItems(infectedItemPaths, "test_pass_phrase");
    assertEquals(Response.Status.OK.getStatusCode(), response1.getStatus());
    verify(malwareDetectionService, times(2)).processInfectedItem(anyString());
  }
}
