package org.exoplatform.antimalware.service;

import static org.junit.Assert.assertEquals;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.Mockito.lenient;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

import java.util.List;

import org.exoplatform.services.listener.ListenerService;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

import org.exoplatform.antimalware.connector.MalwareDetectionConnector;
import org.exoplatform.antimalware.connector.MalwareDetectionItemConnector;

@RunWith(MockitoJUnitRunner.class)
public class MalwareDetectionServiceTest {

  private MalwareDetectionService malwareDetectionService;

  @Mock
  private ListenerService         listenerService;

  @Before
  public void setUp() throws Exception {
    this.malwareDetectionService = new MalwareDetectionService(listenerService);
  }

  @Test
  public void getDefaultMalwareDetectionConnector() {
    MalwareDetectionConnector malwareDetectionConnector1 = mock(MalwareDetectionConnector.class);
    MalwareDetectionConnector malwareDetectionConnector2 = mock(MalwareDetectionConnector.class);
    lenient().when(malwareDetectionConnector1.isDefault()).thenReturn(true);
    malwareDetectionService.addMalwareDetectionConnector(malwareDetectionConnector1);
    malwareDetectionService.addMalwareDetectionConnector(malwareDetectionConnector2);
    assertEquals(1, malwareDetectionService.getMalwareDetectionConnectors().size());
  }

  @Test
  public void checkAndProcessNewInfectedItems() {
    List<String> infectedItemsPaths = List.of("path1", "path2");
    MalwareDetectionConnector malwareDetectionConnector = mock(MalwareDetectionConnector.class);
    MalwareDetectionItemConnector malwareDetectionItemConnector = mock(MalwareDetectionItemConnector.class);
    when(malwareDetectionConnector.isDefault()).thenReturn(true);
    when(malwareDetectionConnector.getInfectedItemsPaths()).thenReturn(infectedItemsPaths);
    when(malwareDetectionItemConnector.getType()).thenReturn("files");
    when(malwareDetectionItemConnector.canProcessInfectedItem(anyString())).thenReturn(true);
    malwareDetectionService.addMalwareDetectionConnector(malwareDetectionConnector);
    malwareDetectionService.addMalwareDetectionItemConnector(malwareDetectionItemConnector);
    malwareDetectionService.checkAndProcessNewInfectedItems();
    verify(malwareDetectionItemConnector, times(1)).processInfectedItem("path1");
    verify(malwareDetectionItemConnector, times(1)).processInfectedItem("path2");
  }

  @Test
  public void processInfectedItem() {
    String infectedItemPath = "/gatein/data/files/d/e/4/c/e/2/d/7/dedeezd65edrerde673r777";
    MalwareDetectionItemConnector malwareDetectionItemConnector = mock(MalwareDetectionItemConnector.class);
    when(malwareDetectionItemConnector.getType()).thenReturn("files");
    malwareDetectionService.addMalwareDetectionItemConnector(malwareDetectionItemConnector);
    when(malwareDetectionItemConnector.canProcessInfectedItem(anyString())).thenReturn(true);
    malwareDetectionService.processInfectedItem(infectedItemPath);
    verify(malwareDetectionItemConnector, times(1)).processInfectedItem(infectedItemPath);
  }
}
