/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi.node.read;

import com.sun.japex.TestCase;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;

public abstract class AbstractNodeTest
extends JCRTestBase {
    protected Node root;
    protected String nodeName;
    protected String propertyName;
    protected Node node;

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        super.doFinish(tc, context);
        this.node.remove();
        context.getSession().save();
    }

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        super.doPrepare(tc, context);
        this.root = context.getSession().getRootNode().addNode(context.generateUniqueName("testRoot"));
        this.nodeName = context.generateUniqueName("testNode");
        this.node = this.root.addNode(this.nodeName);
        this.node.addMixin("mix:referenceable");
        this.propertyName = context.generateUniqueName("property");
        this.node.setProperty(this.propertyName, "content");
        context.getSession().save();
        this.initChildNodes(context);
        this.initChildProperties(context);
        this.root.save();
    }

    protected void initChildNodes(JCRTestContext context) throws RepositoryException {
        this.addChildNodes(context, 10);
    }

    protected void initChildProperties(JCRTestContext context) throws RepositoryException {
        this.addChildProperties(context, 10);
    }

    protected void addChildNodes(JCRTestContext context, int amount) throws RepositoryException {
        for (int i = 0; i < amount; ++i) {
            this.node.addNode(context.generateUniqueName("node"));
        }
    }

    protected void addChildProperties(JCRTestContext context, int amount) throws RepositoryException {
        for (int i = 0; i < amount; ++i) {
            this.node.setProperty(context.generateUniqueName("property"), this.node);
        }
    }
}

