/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi.version;

import com.sun.japex.TestCase;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.jcr.benchmark.jcrapi.AbstractGetItemTest;

public class NodeMergeTest
extends AbstractGetItemTest {
    private String workspaceName = "system";
    private Session sysSession;

    protected void createContent(Node parent, TestCase tc, JCRTestContext context) throws Exception {
        Node vnode = parent.addNode(context.generateUniqueName("versionableNode"));
        vnode.addMixin("mix:versionable");
        parent.save();
        vnode.checkin();
        vnode.checkout();
        this.sysSession = context.getSession().getRepository().login(context.getCredentials(), this.workspaceName);
        if (!this.sysSession.itemExists(vnode.getParent().getPath())) {
            Node ctxNode = this.sysSession.getRootNode();
            for (String nname : vnode.getParent().getPath().split("/")) {
                try {
                    if (nname.equals("")) {
                        nname = ".";
                    }
                    ctxNode = ctxNode.getNode(nname);
                }
                catch (PathNotFoundException e) {
                    ctxNode = ctxNode.addNode(nname);
                    this.sysSession.save();
                }
            }
        }
        this.sysSession.getWorkspace().clone(context.getSession().getWorkspace().getName(), vnode.getPath(), vnode.getPath(), false);
        Node sysVNode = this.sysSession.getNodeByUUID(vnode.getUUID());
        vnode.addNode("Subnode").setProperty("Property", "property of subnode");
        vnode.save();
        vnode.checkin();
        vnode.checkout();
        vnode.addNode("Another subnode").setProperty("Property", "property of another subnode");
        vnode.save();
        vnode.checkin();
        vnode.checkout();
        this.addNode(vnode);
        sysVNode.restore("3", true);
        sysVNode.checkout();
        sysVNode.getNode("Another subnode").remove();
        sysVNode.addNode("Sys Subnode").setProperty("Sys Property", "property of system subnode");
        sysVNode.save();
        sysVNode.checkin();
        sysVNode.checkout();
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        this.nextNode().merge(this.workspaceName, true);
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        super.doFinish(tc, context);
        try {
            this.sysSession.getRootNode().getNode(this.rootNodeName).remove();
            this.sysSession.save();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }
}

