/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.namespace;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.NamespaceException;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.services.jcr.impl.core.NamespaceRegistryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public abstract class AbstractNamespaceTest
extends JCRTestBase {
    private static final Log LOG = ExoLogger.getLogger(AbstractNamespaceTest.class);
    protected NamespaceRegistryImpl namespaceRegistry;
    protected List<String> namespaces = new ArrayList<String>();
    protected int iteration = 0;
    protected int runIterations;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        int warmUpIterations;
        super.doPrepare(tc, context);
        this.namespaceRegistry = (NamespaceRegistryImpl)context.getSession().getWorkspace().getNamespaceRegistry();
        this.runIterations = tc.getIntParam("japex.runIterations");
        if (tc.hasParam("japex.warmupIterations") && (warmUpIterations = tc.getIntParam("japex.warmupIterations")) > 0) {
            this.runIterations += warmUpIterations;
        }
        this.prepare(tc, context);
    }

    protected String nextNamespace() {
        return this.namespaces.get(this.iteration++);
    }

    public void doFinish(TestCase arg0, JCRTestContext arg1) throws Exception {
        super.doFinish(arg0, arg1);
        for (String ns : this.namespaces) {
            try {
                this.namespaceRegistry.getNamespaceURIByPrefix(ns);
                this.namespaceRegistry.unregisterNamespace(ns);
            }
            catch (NamespaceException e) {}
        }
        this.namespaces.clear();
    }

    public abstract void prepare(TestCase var1, JCRTestContext var2) throws Exception;
}

