/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.portal;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import org.exoplatform.jcr.benchmark.usecases.portal.AbstractWriteAction;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;

public class InitRepositoryAction
extends AbstractWriteAction {
    private Session session;
    private int depth;
    private int nodesPerLevel;

    public InitRepositoryAction(Session session, String rootName, String stringValue, byte[] binaryValue, int multiValueSize, int depth, int nodesPerLevel) {
        super((RepositoryImpl)session.getRepository(), session.getWorkspace().getName(), rootName, depth, stringValue, binaryValue, multiValueSize);
        this.session = session;
        this.depth = depth;
        this.nodesPerLevel = nodesPerLevel;
    }

    public void perform() throws RepositoryException {
        Node testRoot = this.session.getRootNode().getNode(this.getRootNodeName());
        this.recursivelyFill(testRoot, this.depth, this.session.getValueFactory());
    }

    private void recursivelyFill(Node root, int currentLevel, ValueFactory valueFactory) throws RepositoryException {
        if (currentLevel > 0) {
            for (int i = 0; i < this.nodesPerLevel; ++i) {
                Node target = this.createGenericNode(root, valueFactory);
                this.recursivelyFill(target, currentLevel - 1, valueFactory);
            }
        }
    }
}

