/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi.webdav;

import com.sun.japex.TestCase;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.ModuleException;
import org.exoplatform.jcr.benchmark.jcrapi.webdav.AbstractWebdavTest;
import org.exoplatform.jcr.benchmark.jcrapi.webdav.JCRWebdavConnectionEx;
import org.exoplatform.jcr.benchmark.jcrapi.webdav.WebdavTestContext;

public class WebdavIndexerTest
extends AbstractWebdavTest {
    private ArrayList<TestResource> testResources = new ArrayList();
    private final Random rand = new Random();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPrepare(TestCase tc, WebdavTestContext context) throws IOException {
        JCRWebdavConnectionEx connection = new JCRWebdavConnectionEx(context);
        this.rootNodeName = context.generateUniqueName("rootNode");
        this.testResources.add(new TestResource("../resources/index/test_index.doc", "application/msword"));
        this.testResources.add(new TestResource("../resources/index/test_index.htm", "text/html"));
        this.testResources.add(new TestResource("../resources/index/test_index.xml", "text/xml"));
        this.testResources.add(new TestResource("../resources/index/test_index.ppt", "application/vnd.ms-powerpoint"));
        this.testResources.add(new TestResource("../resources/index/test_index.txt", "text/plain"));
        this.testResources.add(new TestResource("../resources/index/test_index.xls", "application/vnd.ms-excel"));
        try {
            connection.addDir(this.rootNodeName);
        }
        catch (ModuleException e) {
            e.printStackTrace();
        }
        finally {
            connection.stop();
        }
    }

    protected void createContent(String parentNodeName, TestCase tc, WebdavTestContext context) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun(TestCase tc, WebdavTestContext context) {
        JCRWebdavConnectionEx connection = new JCRWebdavConnectionEx(context);
        try {
            int i = this.rand.nextInt(this.testResources.size());
            TestResource res = this.testResources.get(i);
            String nodeName = this.rootNodeName + "/" + context.generateUniqueName("node");
            HTTPResponse response = connection.addNode(nodeName, res.resourceBuffer, res.contentType);
            if (response.getStatusCode() != 201) {
                System.out.println("Server returned Status " + response.getStatusCode() + " : " + new String(response.getData()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            connection.stop();
        }
    }

    public void doFinish(TestCase tc, WebdavTestContext context) throws Exception {
    }

    private class TestResource {
        private String contentType;
        private byte[] resourceBuffer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TestResource(String resourcePath, String contentType) throws IOException {
            this.contentType = contentType;
            FileInputStream inStream = new FileInputStream(resourcePath);
            try {
                this.resourceBuffer = new byte[inStream.available()];
                int i = 0;
                int b = 0;
                while ((b = inStream.read()) != -1) {
                    this.resourceBuffer[i] = (byte)b;
                    ++i;
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            finally {
                inStream.close();
            }
        }
    }
}

