/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.jcrapi.webdav;

import com.sun.japex.TestCase;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.jcr.benchmark.jcrapi.webdav.AbstractWebdavTest;
import org.exoplatform.jcr.benchmark.jcrapi.webdav.JCRWebdavConnectionEx;
import org.exoplatform.jcr.benchmark.jcrapi.webdav.WebdavTestContext;

public class WebdavReadWriteTest
extends AbstractWebdavTest {
    private static List<String> nodesPath = new ArrayList<String>();
    private static volatile boolean writersStarted = false;
    private static volatile boolean writersRun = true;
    private static PrintWriter reportFile;
    private static boolean gatherReport;
    private static byte[] writeData;
    private static volatile int reportsCounter;
    protected int iterator = 0;
    private static List<NodesWriter> nodesWriters;
    private StringBuilder report = new StringBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPrepare(TestCase tc, WebdavTestContext context) throws Exception {
        if (!tc.hasParam("nodesPoolSize")) {
            throw new RuntimeException("<nodesPoolSize> parameter required");
        }
        int nodesPoolSizeToRead = tc.getIntParam("nodesPoolSize");
        if (!tc.hasParam("writeThreads")) {
            throw new RuntimeException("<writeThreads> parameter required");
        }
        int writeThreadsCount = tc.getIntParam("writeThreads");
        if (!tc.hasParam("delayWrite")) {
            throw new RuntimeException("<delayWrite> parameter required");
        }
        int delayWrite = tc.getIntParam("delayWrite");
        gatherReport = tc.hasParam("gatherReport") ? tc.getBooleanParam("gatherReport") : false;
        if (!writersStarted) {
            JCRWebdavConnectionEx conn = new JCRWebdavConnectionEx(context);
            try {
                long time = System.currentTimeMillis();
                writersStarted = true;
                String rootName = context.generateUniqueName("rootNode");
                conn.addDir(rootName);
                byte[] readData = this.readData(WebdavReadWriteTest.class.getResourceAsStream("/test-data/1k-web-page.html"));
                int foldersCount = nodesPoolSizeToRead / 100;
                foldersCount = foldersCount > 0 ? foldersCount : 1;
                for (int i = 0; i < foldersCount; ++i) {
                    String parentNodeName = rootName + "/" + context.generateUniqueName("node");
                    conn.addDir(parentNodeName);
                    int subFoldersCount = nodesPoolSizeToRead / foldersCount;
                    for (int j = 0; j < subFoldersCount; ++j) {
                        String subFolder = parentNodeName + "/" + context.generateUniqueName("subNode");
                        conn.addNode(subFolder, readData);
                        nodesPath.add(subFolder);
                    }
                }
                writeData = readData;
                CountDownLatch countDownLatch = new CountDownLatch(1);
                for (int j = 0; j < writeThreadsCount; ++j) {
                    String parentNodeName = rootName + "/" + context.generateUniqueName("node_writers");
                    conn.addDir(parentNodeName);
                    NodesWriter writer = new NodesWriter("ThreadWriter_" + j, parentNodeName, delayWrite, context, countDownLatch);
                    writer.start();
                    nodesWriters.add(writer);
                }
                countDownLatch.countDown();
                System.out.println(Thread.currentThread() + " : Prepare done in " + (System.currentTimeMillis() - time));
            }
            finally {
                conn.stop();
            }
        }
    }

    protected void addNode(String nodePath) {
        nodesPath.add(nodePath);
    }

    protected String nextNodePath() {
        if (this.iterator > nodesPath.size() - 1) {
            this.iterator = 0;
        }
        return nodesPath.get(this.iterator++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFinish(TestCase tc, WebdavTestContext context) throws Exception {
        List<NodesWriter> list = nodesWriters;
        synchronized (list) {
            if (gatherReport && reportFile == null) {
                File reportsDir = new File("report");
                reportsDir.mkdirs();
                reportFile = new PrintWriter(new File(reportsDir, "report.txt"));
            }
            writersRun = false;
            for (NodesWriter writer : nodesWriters) {
                writer.join();
                if (!gatherReport) continue;
                reportFile.append(writer.getReport());
            }
            nodesWriters.clear();
            if (gatherReport) {
                reportFile.append(this.report.toString());
                reportFile.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRun(TestCase tc, WebdavTestContext context) throws Exception {
        String nodePath = this.nextNodePath();
        long start = System.currentTimeMillis();
        JCRWebdavConnectionEx conn = new JCRWebdavConnectionEx(context);
        long packetSize = -1L;
        try {
            HTTPResponse response = conn.getNode(nodePath);
            if (response.getStatusCode() != 200) {
                System.out.println("Can not get (response code " + response.getStatusCode() + new String(response.getData()) + " ) node with path : " + nodePath);
            } else {
                byte[] data = response.getData();
                if (data != null) {
                    packetSize = data.length;
                }
            }
        }
        finally {
            conn.stop();
        }
        if (gatherReport) {
            this.report.append(System.currentTimeMillis());
            this.report.append(":");
            this.report.append(Thread.currentThread());
            this.report.append(":Read:");
            this.report.append(nodePath);
            this.report.append(":");
            this.report.append(packetSize);
            this.report.append(":");
            this.report.append(System.currentTimeMillis() - start);
            this.report.append('\r');
            this.report.append('\n');
        }
    }

    protected void createContent(String parentNodeName, TestCase tc, WebdavTestContext context) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readData(InputStream dataIn) throws IOException {
        ByteArrayOutputStream dataOut = new ByteArrayOutputStream();
        byte[] buff = new byte[2048];
        int res = -1;
        try {
            while ((res = dataIn.read(buff)) >= 0) {
                dataOut.write(buff, 0, res);
            }
        }
        finally {
            dataIn.close();
            dataOut.close();
        }
        return dataOut.toByteArray();
    }

    static {
        reportsCounter = 1;
        nodesWriters = new ArrayList<NodesWriter>();
    }

    private class NodesWriter
    extends Thread {
        private final String nodePath;
        private int count;
        private final int writeDelay;
        private final WebdavTestContext context;
        private StringBuilder report;
        private CountDownLatch countDownLatch;

        public NodesWriter(String threadName, String nodePath, int writeDelay, WebdavTestContext context, CountDownLatch countDownLatch) {
            super(threadName);
            this.report = new StringBuilder();
            this.nodePath = nodePath;
            this.context = context;
            this.count = 100;
            this.writeDelay = writeDelay;
            this.countDownLatch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.countDownLatch.await();
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
            String subNodePath = null;
            int folderCount = 0;
            while (writersRun) {
                JCRWebdavConnectionEx connection;
                String path;
                long dataSize;
                long start;
                block15: {
                    start = System.currentTimeMillis();
                    dataSize = 0L;
                    path = "";
                    connection = new JCRWebdavConnectionEx(this.context);
                    try {
                        if (this.count != 100) break block15;
                        String subFolder = "folder" + folderCount++;
                        subNodePath = this.nodePath + "/" + subFolder;
                        try {
                            connection.addDir(subNodePath);
                            this.count = 0;
                        }
                        catch (Exception e) {
                            System.out.println(this.getName() + " : Can not add node with path : " + subNodePath);
                            e.printStackTrace();
                            connection.stop();
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        connection.stop();
                        throw throwable;
                    }
                }
                path = subNodePath + "/" + "node" + this.count++;
                HTTPResponse response = null;
                try {
                    response = connection.addNode(path, writeData);
                    if (response.getStatusCode() != 201) {
                        System.out.println(this.getName() + " : Can not add (response code " + response.getStatusCode() + new String(response.getData()) + " ) node with path : " + this.nodePath);
                    } else {
                        dataSize += (long)writeData.length;
                    }
                }
                catch (Exception e) {
                    System.out.println(this.getName() + " : Can not add node with path : " + path);
                    e.printStackTrace();
                    connection.stop();
                    continue;
                }
                connection.stop();
                if (gatherReport) {
                    this.report.append(System.currentTimeMillis());
                    this.report.append(":");
                    this.report.append(this.getName());
                    this.report.append(":Add:");
                    this.report.append(path);
                    this.report.append(":");
                    this.report.append(dataSize);
                    this.report.append(":");
                    this.report.append(System.currentTimeMillis() - start);
                    this.report.append('\r');
                    this.report.append('\n');
                }
                if (this.writeDelay <= 0) continue;
                try {
                    Thread.sleep(this.writeDelay);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public String getReport() {
            return this.report.toString();
        }
    }
}

