/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases;

import com.sun.japex.TestCase;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;

public class GetNodesInCacheTest
extends JCRTestBase {
    private static volatile boolean prepared;
    private static volatile boolean finished;
    private static byte[] contentOfFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        if (finished) return;
        Class<GetNodesInCacheTest> clazz = GetNodesInCacheTest.class;
        synchronized (GetNodesInCacheTest.class) {
            if (finished) return;
            finished = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        if (prepared) return;
        Class<GetNodesInCacheTest> clazz = GetNodesInCacheTest.class;
        synchronized (GetNodesInCacheTest.class) {
            if (prepared) return;
            GetNodesInCacheTest.loadFile();
            int total = Integer.parseInt(tc.getParam("jcr.total.subnodes"));
            for (int i = 0; i < total; ++i) {
                GetNodesInCacheTest.addNode(context);
            }
            prepared = true;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        Node rootNode = context.getSession().getRootNode();
        NodeIterator it = rootNode.getNodes();
        while (it.hasNext()) {
            it.next();
        }
    }

    private static boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    GetNodesInCacheTest.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    private static void cleanDB() {
        Connection dbConnection = null;
        try {
            DataSource ds = (DataSource)new InitialContext().lookup("jdbcexo");
            dbConnection = ds.getConnection();
            dbConnection.setAutoCommit(false);
            ArrayList<String> oracleQueryList = new ArrayList<String>();
            oracleQueryList.add("DROP TABLE jcr_scontainer");
            oracleQueryList.add("DROP TABLE jcr_svalue");
            oracleQueryList.add("DROP TABLE jcr_sref");
            oracleQueryList.add("DROP TABLE jcr_sitem");
            for (String query : oracleQueryList) {
                try {
                    dbConnection.prepareStatement(query).execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dbConnection.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (dbConnection != null) {
                try {
                    dbConnection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void addNode(JCRTestContext context) throws Exception {
        Node rootNode = context.getSession().getRootNode().addNode(context.generateUniqueName("rootNode"), "nt:unstructured");
        Node nodeToAdd = rootNode.addNode(context.generateUniqueName("node"), "nt:file");
        Node contentNodeOfNodeToAdd = nodeToAdd.addNode("jcr:content", "nt:resource");
        contentNodeOfNodeToAdd.setProperty("jcr:data", (InputStream)new ByteArrayInputStream(contentOfFile));
        contentNodeOfNodeToAdd.setProperty("jcr:mimeType", "application/pdf");
        contentNodeOfNodeToAdd.setProperty("jcr:lastModified", Calendar.getInstance());
        context.getSession().save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFile() throws Exception {
        File file = new File("../resources/benchmark.pdf");
        contentOfFile = new byte[(int)file.length()];
        int numRead = 0;
        FileInputStream is = new FileInputStream(file);
        try {
            int offset;
            for (offset = 0; offset < contentOfFile.length && (numRead = ((InputStream)is).read(contentOfFile, offset, contentOfFile.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < contentOfFile.length) {
                throw new IOException("Could not completely read file ");
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }
}

