/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases;

import com.sun.japex.TestCase;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.jcr.Item;
import javax.jcr.Node;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;

public class TraverseInnerFoldersTest
extends JCRTestBase {
    private int amountOfInnerFolders = 0;
    private int depthOfStructure = 0;
    private List<String> names = new ArrayList<String>();
    private Random rand = new Random();
    private Node rootNode = null;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        this.amountOfInnerFolders = tc.getIntParam("jcr.amountOfInnerFolders");
        int depth = this.depthOfStructure = tc.getIntParam("jcr.depthOfStructure");
        int count = this.amountOfInnerFolders;
        this.rootNode = context.getSession().getRootNode().addNode(context.generateUniqueName("rootNode"), "nt:unstructured");
        this.createFoldersRecursively(context, this.rootNode, depth, count);
        context.getSession().save();
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        int index = this.rand.nextInt((int)Math.pow(this.amountOfInnerFolders, this.depthOfStructure));
        Item item = this.rootNode.getSession().getItem(this.names.get(index));
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        this.rootNode.remove();
        context.getSession().save();
    }

    private void createFoldersRecursively(JCRTestContext context, Node rootNode, int depth, int count) throws Exception {
        if (depth < 1) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            String name = context.generateUniqueName("folder-" + i);
            Node current = rootNode.addNode(name, "nt:folder");
            this.names.add(current.getPath());
            this.createFoldersRecursively(context, current, depth - 1, count);
        }
    }
}

