/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.portal;

import java.util.Random;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.core.ExtendedSession;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;

public abstract class AbstractAction {
    private RepositoryImpl repository;
    private String workspace;
    private String rootName;
    private Random random;
    private int depth;

    public AbstractAction(RepositoryImpl repository, String workspace, String rootName, int depth) {
        this.repository = repository;
        this.workspace = workspace;
        this.rootName = rootName;
        this.depth = depth;
        this.random = new Random();
    }

    public String getRootNodeName() {
        return this.rootName;
    }

    public Session getSession(boolean anonymous) throws RepositoryException {
        if (anonymous) {
            return (ExtendedSession)this.repository.login((Credentials)new CredentialsImpl(SystemIdentity.ANONIM, "".toCharArray()), this.workspace);
        }
        return (ExtendedSession)this.repository.login((Credentials)new CredentialsImpl(SystemIdentity.SYSTEM, "".toCharArray()), this.workspace);
    }

    public Node nextNode(Node testRoot) throws RepositoryException {
        return this.getNodeOnLevel(testRoot, this.depth);
    }

    public Node nextParent(Node testRoot) throws RepositoryException {
        return this.getNodeOnLevel(testRoot, this.depth - 1);
    }

    protected Node getNodeOnLevel(Node testRoot, int level) throws RepositoryException {
        Node target = testRoot;
        for (int i = 0; i < level; ++i) {
            NodeIterator iterator = target.getNodes();
            iterator.skip((long)this.random.nextInt((int)iterator.getSize()));
            target = iterator.nextNode();
            if (target != null) continue;
            throw new ItemNotFoundException("Unexpected repository structure, possibly some nodes were deleted.");
        }
        return target;
    }

    public String nextPropertyName() {
        return PropertyType.nameFromValue((int)(this.random.nextInt(9) + 1)) + (this.random.nextBoolean() ? "-m" : "-s");
    }

    public abstract void perform() throws RepositoryException;
}

