/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.portal;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.jcr.benchmark.usecases.portal.AbstractAction;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.util.IdGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadPageAction
extends AbstractAction {
    private int nodeCount;
    private int propertyCount;
    private int missingNodeCount;
    private int missingPropertyCount;
    private boolean anonymous;
    private List<String> queires;

    public ReadPageAction(RepositoryImpl repository, String workspace, String rootName, int depth, int nodeCount, int propertyCount, int missingNodeCount, int missingPropertyCount, boolean anonymous) {
        this(repository, workspace, rootName, depth, nodeCount, propertyCount, missingNodeCount, missingPropertyCount, anonymous, null);
    }

    public ReadPageAction(RepositoryImpl repository, String workspace, String rootName, int depth, int nodeCount, int propertyCount, int missingNodeCount, int missingPropertyCount, boolean anonymous, List<String> queries) {
        super(repository, workspace, rootName, depth);
        this.nodeCount = nodeCount;
        this.propertyCount = propertyCount;
        this.anonymous = anonymous;
        this.missingNodeCount = missingNodeCount;
        this.missingPropertyCount = missingPropertyCount;
        this.queires = new ArrayList<String>();
        if (queries != null) {
            this.queires.addAll(queries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() throws RepositoryException {
        Session session = null;
        try {
            int i;
            session = this.getSession(this.anonymous);
            Node testRoot = session.getRootNode().getNode(this.getRootNodeName());
            Node target = null;
            for (i = 0; i < this.nodeCount; ++i) {
                target = this.nextNode(testRoot);
                for (int j = 0; j < this.propertyCount; ++j) {
                    try {
                        target.getProperty(this.nextPropertyName());
                        continue;
                    }
                    catch (PathNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            target = this.nextNode(testRoot);
            for (i = 0; i < this.missingPropertyCount; ++i) {
                try {
                    target.getProperty(IdGenerator.generate());
                    continue;
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
            }
            for (i = 0; i < this.missingNodeCount; ++i) {
                try {
                    testRoot.getNode(IdGenerator.generate());
                    continue;
                }
                catch (PathNotFoundException e) {
                    // empty catch block
                }
            }
            for (String queryLine : this.queires) {
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(queryLine.trim(), "sql");
                QueryResult result = query.execute();
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

