/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.xml;

import com.sun.japex.TestCase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import javax.jcr.Node;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ExportOwnSubtreeSysViewTest
extends JCRTestBase {
    public static Log log = ExoLogger.getLogger((String)"jcr.benchmark");
    private Node rootNode = null;
    private String name = "";
    private File destFile = null;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        this.name = context.generateUniqueName("rootNode");
        this.rootNode = context.getSession().getRootNode().addNode(this.name);
        Node file = this.rootNode.addNode("child1").addNode("child2").addNode("file", "nt:file");
        Node content = file.addNode("jcr:content", "nt:resource");
        content.setProperty("jcr:data", (InputStream)new FileInputStream("../resources/benchmark.pdf"));
        content.setProperty("jcr:mimeType", "application/pdf");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        context.getSession().save();
        this.destFile = File.createTempFile(this.name, ".xml");
        this.destFile.deleteOnExit();
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        FileOutputStream out = new FileOutputStream(this.destFile);
        context.getSession().exportSystemView("/" + this.name, (OutputStream)out, false, false);
        ((OutputStream)out).close();
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
        this.rootNode.remove();
        context.getSession().save();
    }
}

