/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.xml;

import com.sun.japex.TestCase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.Node;
import org.exoplatform.jcr.benchmark.JCRTestBase;
import org.exoplatform.jcr.benchmark.JCRTestContext;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCStorageConnection;
import org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ImportOwnSubtreeSysViewCleanDBOracleTest
extends JCRTestBase {
    public static Log log = ExoLogger.getLogger((String)"jcr.benchmark");
    public static WorkspaceStorageConnection workspaceStorageConnection = null;
    public static boolean dataBaseDropped = false;
    private Node rootNode = null;
    private String name = "";
    private File destFile = null;

    public void doPrepare(TestCase tc, JCRTestContext context) throws Exception {
        this.name = context.generateUniqueName("rootNode");
        this.rootNode = context.getSession().getRootNode().addNode(this.name);
        Node file = this.rootNode.addNode("child1").addNode("child2").addNode("file", "nt:file");
        Node content = file.addNode("jcr:content", "nt:resource");
        content.setProperty("jcr:data", (InputStream)new FileInputStream("../resources/benchmark.gif"));
        content.setProperty("jcr:mimeType", "image/gif");
        content.setProperty("jcr:lastModified", Calendar.getInstance());
        context.getSession().save();
        this.destFile = File.createTempFile(this.name, ".xml");
        this.destFile.deleteOnExit();
        FileOutputStream out = new FileOutputStream(this.destFile);
        context.getSession().exportSystemView("/" + this.name, (OutputStream)out, false, false);
        ((OutputStream)out).close();
    }

    public void doRun(TestCase tc, JCRTestContext context) throws Exception {
        String name2 = context.generateUniqueName("name2");
        this.rootNode.addNode(name2);
        context.getSession().save();
        FileInputStream is = new FileInputStream(this.destFile);
        context.getSession().importXML("/" + this.name + "/" + name2, (InputStream)is, 0);
    }

    public void doFinish(TestCase tc, JCRTestContext context) throws Exception {
    }

    private synchronized void cleanDB(JCRTestContext context) {
        try {
            if (!dataBaseDropped) {
                log.info((Object)"sleep 10 sec");
                Thread.sleep(10000L);
                log.info((Object)"sleep 10 sec done");
                JDBCWorkspaceDataContainer workspaceDataContainer = (JDBCWorkspaceDataContainer)((SessionImpl)context.getSession()).getContainer().getComponentInstanceOfType(JDBCWorkspaceDataContainer.class);
                workspaceStorageConnection = workspaceStorageConnection == null ? workspaceDataContainer.openConnection() : workspaceDataContainer.reuseConnection(workspaceStorageConnection);
                JDBCStorageConnection storageConnection = (JDBCStorageConnection)workspaceStorageConnection;
                Connection dbConnection = storageConnection.getJdbcConnection();
                ArrayList<String> oracleQueryList = new ArrayList<String>();
                oracleQueryList.add("DROP TABLE jcr_config");
                oracleQueryList.add("DROP TABLE jcr_scontainer");
                oracleQueryList.add("DROP TABLE jcr_svalue");
                oracleQueryList.add("DROP TABLE jcr_sref");
                oracleQueryList.add("DROP TABLE jcr_sitem");
                oracleQueryList.add("DROP SEQUENCE JCR_SVALUE_SEQ");
                for (String query : oracleQueryList) {
                    try {
                        dbConnection.prepareStatement(query).execute();
                    }
                    catch (Exception e) {}
                }
                dbConnection.commit();
                dataBaseDropped = true;
                boolean successfullyDeleted = this.deleteDir(new File("../temp"));
                if (successfullyDeleted) {
                    log.info((Object)"Folder 'temp' successfully deleted");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private synchronized boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                log.warn((Object)("Can not delete: " + dir + ", " + children[i]));
                return false;
            }
        }
        return dir.delete();
    }
}

