/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexOfflineRepositoryException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class PopupReminderJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(PopupReminderJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer oldContainer = ExoContainerContext.getCurrentContainer();
        PortalContainer container = PortalContainer.getInstance();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
        try {
            SessionProvider provider = SessionProvider.createSystemProvider();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Calendar popup reminder service");
            }
            GregorianCalendar fromCalendar = Utils.getInstanceTempCalendar();
            ContinuationService continuation = (ContinuationService)container.getComponentInstanceOfType(ContinuationService.class);
            Node calendarHome = Utils.getPublicServiceHome();
            if (calendarHome == null) {
                return;
            }
            StringBuilder path = new StringBuilder(PopupReminderJob.getReminderPath(fromCalendar));
            path.append("//element(*,exo:reminder)");
            path.append("[@exo:remindDateTime <= xs:dateTime('" + ISO8601.format((Calendar)fromCalendar) + "') and @exo:isOver = 'false' and @exo:reminderType = 'popup' ]");
            QueryManager queryManager = Utils.getSession(provider).getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(path.toString(), "xpath");
            QueryResult results = query.execute();
            NodeIterator iter = results.getNodes();
            ArrayList<Reminder> popupReminders = new ArrayList<Reminder>();
            while (iter.hasNext()) {
                Node reminder = iter.nextNode();
                boolean isRepeat = reminder.getProperty("exo:isRepeat").getBoolean();
                long fromTime = reminder.getProperty("exo:fromDateTime").getDate().getTimeInMillis();
                long remindTime = reminder.getProperty("exo:remindDateTime").getDate().getTimeInMillis();
                long interval = reminder.getProperty("exo:timeInterval").getLong() * 60L * 1000L;
                Reminder rmdObj = new Reminder();
                rmdObj.setRepeate(isRepeat);
                rmdObj.setReminderOwner(reminder.getProperty("exo:creator").getString());
                rmdObj.setId(reminder.getProperty("exo:eventId").getString());
                if (isRepeat) {
                    long currentTime1 = Calendar.getInstance().getTimeInMillis();
                    long nextRemindTime = this.getNextRemindTime(remindTime, currentTime1, interval);
                    if (nextRemindTime > 0L) {
                        popupReminders.add(rmdObj);
                        if (nextRemindTime > fromTime) {
                            reminder.setProperty("exo:isOver", true);
                        } else {
                            reminder.setProperty("exo:isOver", false);
                            reminder.setProperty("exo:remindDateTime", nextRemindTime);
                        }
                    }
                } else {
                    long currentTime2 = Calendar.getInstance().getTimeInMillis();
                    if (this.isTimeToRemind(remindTime, currentTime2)) {
                        popupReminders.add(rmdObj);
                        reminder.setProperty("exo:isOver", true);
                    }
                }
                reminder.save();
            }
            if (!popupReminders.isEmpty()) {
                for (Reminder rmdObj : popupReminders) {
                    for (String user : rmdObj.getReminderOwner().split(",")) {
                        if (!CommonsUtils.isUserEnabled((String)user)) continue;
                        continuation.sendMessage(user, "/eXo/Application/Calendar/messages", (Object)rmdObj.getId());
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"File plan job done");
            }
        }
        catch (IndexOfflineRepositoryException e) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("An Error occurred while running Calendar PopupReminderJob: " + e.getMessage()), (Throwable)e);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
        }
    }

    private long getNextRemindTime(long remindTime, long currentTime, long interval) {
        long diff = currentTime - remindTime;
        long remaining = diff % interval;
        long delta = 15000L;
        if (remaining <= delta && currentTime >= remindTime) {
            return currentTime - remaining + interval;
        }
        return -1L;
    }

    private boolean isTimeToRemind(long remindTime, long currentTime) {
        long diff = currentTime - remindTime;
        long delta = 15000L;
        return diff <= delta && currentTime >= remindTime;
    }

    public static String getReminderPath(Calendar fromCalendar) throws Exception {
        String year = "Y" + fromCalendar.get(1);
        String month = "M" + (fromCalendar.get(2) + 1);
        String day = "D" + fromCalendar.get(5);
        StringBuilder path = new StringBuilder("/jcr:root");
        path.append(Utils.getPublicServiceHome().getPath());
        path.append("/").append(year).append("/").append(month).append("/").append(day);
        path.append("/").append("reminders");
        return path.toString();
    }
}

