/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.util;

import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.ValidationException;

public final class ParameterValidator {
    private static ParameterValidator instance = new ParameterValidator();

    private ParameterValidator() {
    }

    public void assertOneOrLess(String paramName, ParameterList parameters) throws ValidationException {
        if (parameters.getParameters(paramName).size() > 1) {
            throw new ValidationException("Parameter [" + paramName + "] must only be specified once");
        }
    }

    public void assertOne(String paramName, ParameterList parameters) throws ValidationException {
        if (parameters.getParameters(paramName).size() != 1) {
            throw new ValidationException("Parameter [" + paramName + "] must be specified once");
        }
    }

    public void assertNone(String paramName, ParameterList parameters) throws ValidationException {
        if (parameters.getParameters(paramName).size() > 0) {
            throw new ValidationException("Parameter [" + paramName + "] is not applicable");
        }
    }

    public void assertNullOrEqual(Parameter param, ParameterList parameters) throws ValidationException {
        Parameter p = parameters.getParameter(param.getName());
        if (p != null && !param.equals(p)) {
            throw new ValidationException("Parameter [" + p + "] is invalid");
        }
    }

    public static ParameterValidator getInstance() {
        return instance;
    }
}

