/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.utils.ISO8601;

public class UnifiedQuery
extends EventQuery {
    @Override
    public String getQueryStatement() throws Exception {
        String text;
        StringBuffer queryString = new StringBuffer("");
        if (this.getQueryType().equals("sql") && !Utils.isEmpty(text = this.getText())) {
            queryString = new StringBuffer("SELECT ");
            queryString.append(UnifiedQuery.repeat("%s", Arrays.asList(Utils.SELECT_FIELDS), ","));
            queryString.append(" FROM " + this.getNodeType() + " WHERE ");
            if (!Utils.isEmpty(this.getCalendarPath())) {
                queryString.append("jcr:path LIKE '").append(this.getCalendarPath()).append("/%' AND ");
            }
            if (!Utils.isEmpty(this.getEventType())) {
                queryString.append(Utils.EXO_EVENT_TYPE).append(" = '").append(this.getEventType()).append("' AND (");
            }
            List<String> inputs = UnifiedQuery.parse(text);
            int inputCount = 0;
            for (String keyword : inputs) {
                if (inputCount > 0) {
                    queryString.append(" OR ");
                }
                int filterCount = 0;
                for (String filter : Utils.SEARCH_FIELDS) {
                    if (filterCount > 0) {
                        queryString.append(" OR ");
                    }
                    queryString.append("CONTAINS(").append(filter).append(",'").append(keyword).append("')");
                    ++filterCount;
                }
                ++inputCount;
            }
            if (!Utils.isEmpty(this.getEventType())) {
                queryString.append(") ");
            }
            if (this.getFromDate() != null && CalendarEvent.TYPE_EVENT.equals(this.getEventType())) {
                queryString.append(" AND ");
                queryString.append(Utils.EXO_FROM_DATE_TIME);
                queryString.append(" >= TIMESTAMP '").append(ISO8601.format((Calendar)this.getFromDate())).append("'");
            }
            if (!Utils.isEmpty(this.getState()) && this.getState().indexOf(Utils.COLON) > 0) {
                for (String state : this.getState().split(Utils.COLON)) {
                    queryString.append(" AND ").append(Utils.EXO_EVENT_STATE).append(" <> '").append(state).append("'");
                }
            }
            if (this.getOrderBy() != null && this.getOrderBy().length > 0) {
                queryString.append(" ORDER BY ").append(this.getOrderBy()[0]);
                if (!Utils.isEmpty(this.getOrderType())) {
                    queryString.append(" ").append(this.getOrderType().toUpperCase());
                }
            }
        }
        return queryString.toString();
    }

    public static List<String> parse(String input) {
        LinkedList<String> terms = new LinkedList<String>();
        Matcher matcher = Pattern.compile("\"([^\"]+)\"").matcher(input);
        while (matcher.find()) {
            String founds = matcher.group(1);
            terms.add(founds);
        }
        String remain = matcher.replaceAll("").replaceAll("\"", "").trim();
        if (!remain.isEmpty()) {
            terms.addAll(Arrays.asList(remain.split("\\s+")));
        }
        return terms;
    }

    private static String repeat(String format, Collection<String> strArr, String delimiter) {
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (String str : strArr) {
            sb.append(delim).append(String.format(format, str));
            delim = delimiter;
        }
        return sb.toString();
    }
}

