/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.net.URLDecoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.collections.map.HashedMap;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;
import org.mortbay.log.Log;

public class CalendarSearchResult
extends SearchResult {
    private long fromDateTime;
    private String dataType;
    private String zoneName;
    private String taskStatus;

    public CalendarSearchResult(String url, String title, String excerpt, String detailValue, String imageUrl, long date, long relevancy) {
        super(url, title, excerpt, detailValue, imageUrl, date, relevancy);
    }

    public long getFromDateTime() {
        return this.fromDateTime;
    }

    public void setFromDateTime(long fromDateTime) {
        this.fromDateTime = fromDateTime;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getImageUrl() {
        return super.getImageUrl();
    }

    public void setTimeZoneName(String name) {
        this.zoneName = name;
    }

    public String getTimeZoneName() {
        return this.zoneName;
    }

    public static String buildLink(SearchContext sc, Collection<String> siteKeys, String calendarId, String eventId) {
        String url = "#";
        if (sc != null) {
            try {
                Router router = sc.getRouter();
                ExoContainerContext context = (ExoContainerContext)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ExoContainerContext.class);
                String handler = context.getPortalContainerName();
                SiteKey siteKey = null;
                String spaceGroupId = null;
                if (calendarId.indexOf("_space_calendar") > 0) {
                    spaceGroupId = String.format("/%s/%s", "spaces", calendarId.replaceFirst("_space_calendar", ""));
                    siteKey = SiteKey.group((String)spaceGroupId);
                } else {
                    UserPortalConfig prc = CalendarSearchResult.getUserPortalConfig();
                    siteKey = SiteKey.portal((String)prc.getPortalConfig().getName());
                }
                if (siteKey != null && !Utils.isEmpty(siteKey.getName())) {
                    String pageName = CalendarSearchResult.getSiteName(siteKey);
                    if (Utils.isEmpty(pageName)) {
                        siteKey = SiteKey.portal((String)(sc.getSiteName() != null ? sc.getSiteName() : "intranet"));
                        pageName = CalendarSearchResult.getSiteName(siteKey);
                    }
                    url = new StringBuffer(CalendarSearchResult.getUrl(router, handler, siteKey.getName(), spaceGroupId, pageName)).append(Utils.SLASH).append("details").append(Utils.SLASH).append(eventId).toString();
                }
            }
            catch (Exception e) {
                Log.info((String)("Could not build the link of event/task " + e.getMessage()));
            }
        }
        return url;
    }

    private static UserPortalConfig getUserPortalConfig() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserPortalConfigService userPortalConfigSer = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        UserPortalContext NULL_CONTEXT = new UserPortalContext(){

            public ResourceBundle getBundle(UserNavigation navigation) {
                return null;
            }

            public Locale getUserLocale() {
                return Locale.ENGLISH;
            }
        };
        String remoteId = ConversationState.getCurrent().getIdentity().getUserId();
        UserPortalConfig userPortalCfg = userPortalConfigSer.getUserPortalConfig(userPortalConfigSer.getDefaultPortal(), remoteId, NULL_CONTEXT);
        return userPortalCfg;
    }

    private static String getSiteName(SiteKey siteKey) {
        NavigationContext nav;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
        NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, nav = navService.loadNavigation(siteKey), Scope.ALL, null);
        if (parentNodeCtx.getSize() >= 1) {
            Collection children = parentNodeCtx.getNodes();
            if (siteKey.getType() == SiteType.GROUP) {
                children = ((NodeContext)parentNodeCtx.get(0)).getNodes();
            }
            Iterator it = children.iterator();
            NodeContext child = null;
            while (it.hasNext()) {
                child = (NodeContext)it.next();
                if (!"calendar".equals(child.getName()) && child.getName().indexOf("CalendarPortlet") < 0) continue;
                return child.getName();
            }
        }
        return Utils.EMPTY_STR;
    }

    public static String getUrl(Router router, String handler, String siteName, String spaceGroupId, String pageName) {
        try {
            HashedMap qualifiedName = new HashedMap();
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"handler"), (Object)handler);
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"path"), (Object)pageName);
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"lang"), (Object)"");
            if (Utils.isEmpty(spaceGroupId)) {
                qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitename"), (Object)siteName);
                qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitetype"), (Object)SiteType.PORTAL.getName());
            } else {
                String groupId = spaceGroupId.split("/")[2];
                qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitename"), (Object)spaceGroupId.replaceAll("/", ":"));
                qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitetype"), (Object)SiteType.GROUP.getName());
                qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"path"), (Object)(groupId + "/" + pageName));
            }
            return "/" + handler + URLDecoder.decode(router.render((Map)qualifiedName), "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getTaskStatus() {
        return this.taskStatus;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }
}

