/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.Row;
import org.apache.commons.collections.map.HashedMap;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarSearchResult;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.service.impl.EventDAOImpl;
import org.exoplatform.calendar.service.impl.EventRowListAccess;
import org.exoplatform.calendar.service.impl.UnifiedQuery;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;

public class CalendarSearchServiceConnector
extends SearchServiceConnector {
    private CalendarService calendarService_;
    private SpaceService spaceService_;
    private static final Log log = ExoLogger.getLogger(CalendarSearchServiceConnector.class);
    private ThreadLocal<Map<String, Calendar>> calendarMap = new ThreadLocal();

    public CalendarSearchServiceConnector(InitParams initParams) {
        super(initParams);
        this.calendarService_ = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarServiceImpl.class);
        this.spaceService_ = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        return this.searchData(context, null, query, sites, offset, limit, sort, order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<SearchResult> searchData(SearchContext context, String dataType, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        ArrayList<SearchResult> events = new ArrayList<SearchResult>();
        if (Utils.isEmpty(query)) {
            return events;
        }
        SessionProvider provider = SessionProvider.createSystemProvider();
        OrganizationService orgService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        HashSet<String> readOnlyCalendars = new HashSet<String>();
        try {
            List<GroupCalendarData> groupCalendar;
            this.getCalendarMap().clear();
            Identity currentUser = ConversationState.getCurrent().getIdentity();
            String userId = currentUser.getUserId();
            LinkedList<String> uCals = new LinkedList<String>();
            List<Calendar> privateCalendars = this.calendarService_.getUserCalendars(userId, true);
            for (Calendar cal : privateCalendars) {
                this.getCalendarMap().put(cal.getId(), cal);
                uCals.add(cal.getId());
            }
            LinkedList<String> sCals = new LinkedList<String>();
            GroupCalendarData sharedCalendar = this.calendarService_.getSharedCalendars(userId, true);
            if (sharedCalendar != null) {
                List<Calendar> shareCalendars = sharedCalendar.getCalendars();
                for (Calendar cal : shareCalendars) {
                    this.getCalendarMap().put(cal.getId(), cal);
                    sCals.add(cal.getId());
                    if (Utils.hasPermission(orgService, cal.getEditPermission(), userId)) continue;
                    readOnlyCalendars.add(cal.getId());
                }
            }
            LinkedList<String> gCals = new LinkedList<String>();
            Set groupIds = currentUser.getGroups();
            if (!groupIds.isEmpty() && (groupCalendar = this.calendarService_.getGroupCalendars(groupIds.toArray(new String[groupIds.size()]), true, userId)) != null) {
                ArrayList<Calendar> spaceCalendars = new ArrayList<Calendar>();
                for (GroupCalendarData gCal : groupCalendar) {
                    if (gCal.getCalendars() == null) continue;
                    spaceCalendars.addAll(gCal.getCalendars());
                }
                for (Calendar cal : spaceCalendars) {
                    this.getCalendarMap().put(cal.getId(), cal);
                    gCals.add(cal.getId());
                    if (Utils.hasPermission(orgService, cal.getEditPermission(), userId)) continue;
                    readOnlyCalendars.add(cal.getId());
                }
            }
            LinkedList<String> calIds = new LinkedList<String>();
            calIds.addAll(uCals);
            calIds.addAll(gCals);
            calIds.addAll(sCals);
            EventQuery uEventQuery = this.createQuery(dataType, query, sort, order, calIds.toArray(new String[calIds.size()]), readOnlyCalendars);
            EventRowListAccess listAccess = new EventRowListAccess((EventDAOImpl)this.calendarService_.getEventDAO(), uEventQuery);
            Object[] rows = listAccess.load(offset, limit);
            CalendarSetting calSetting = this.calendarService_.getCalendarSetting(userId);
            for (Object row : rows) {
                SearchResult rs = this.buildResult(context, sites, dataType, row, calSetting);
                if (rs == null) continue;
                events.add(rs);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not execute unified seach " + dataType), (Throwable)e);
            }
        }
        finally {
            provider.close();
        }
        return events;
    }

    private EventQuery createQuery(String dataType, String queryText, String sort, String order, String[] calendarIds, Set<String> excludePrivateEventInCalendars) throws Exception {
        UnifiedQuery eventQuery = new UnifiedQuery();
        eventQuery.setExcludePrivateEventInCalendars(excludePrivateEventInCalendars);
        java.util.Calendar today = java.util.Calendar.getInstance();
        eventQuery.setFromDate(today);
        eventQuery.setQueryType("sql");
        eventQuery.setEventType(dataType);
        eventQuery.setText(queryText);
        String sortBy = Utils.SORT_FIELD_MAP.get(sort);
        if (Utils.ORDERBY_DATE.equals(sortBy)) {
            sortBy = CalendarEvent.TYPE_EVENT.equals(dataType) ? "exo:fromDateTime" : "exo:toDateTime";
        }
        eventQuery.setOrderBy(new String[]{sortBy});
        eventQuery.setOrderType(order);
        if (CalendarEvent.TYPE_TASK.equals(dataType)) {
            eventQuery.setState(CalendarEvent.COMPLETED + ":" + CalendarEvent.CANCELLED);
        }
        eventQuery.setCalendarId(calendarIds);
        return eventQuery;
    }

    private SearchResult buildResult(SearchContext sc, Collection<String> siteKeys, String dataType, Object iter, CalendarSetting calSeting) {
        block10: {
            try {
                String calId = null;
                if (iter instanceof Row) {
                    Row row = (Row)iter;
                    calId = row.getValue("exo:calendarId").getString();
                } else {
                    Node eventNode = (Node)iter;
                    if (eventNode.hasProperty("exo:calendarId")) {
                        calId = eventNode.getProperty("exo:calendarId").getString();
                    }
                }
                if (this.getCalendarMap().keySet().contains(calId)) {
                    Calendar cal = this.getCalendarMap().get(calId);
                    StringBuffer detail = new StringBuffer();
                    String title = this.buildValue("exo:summary", iter);
                    detail.append(cal.getName());
                    String url = this.buildLink(sc, siteKeys, calId, this.buildValue("exo:id", iter));
                    String excerpt = this.buildValue("exo:description", iter);
                    String detailValue = "";
                    String imageUrl = this.buildImageUrl(iter);
                    detail.append(this.buildDetail(iter, calSeting.getTimeZone()));
                    if (detail.length() > 0) {
                        detailValue = detail.toString();
                    }
                    long relevancy = this.buildScore(iter);
                    long date = this.buildDate(iter);
                    TimeZone userTimezone = TimeZone.getTimeZone(calSeting.getTimeZone());
                    CalendarSearchResult result = new CalendarSearchResult(url, title, excerpt, detailValue, imageUrl, date, relevancy);
                    result.setDataType(dataType);
                    result.setTimeZoneName(calSeting.getTimeZone());
                    result.setTimeZoneOffset(userTimezone.getOffset(date));
                    if (CalendarEvent.TYPE_EVENT.equals(dataType)) {
                        result.setFromDateTime(this.buildDate(iter, "exo:fromDateTime").getTimeInMillis());
                    } else if (CalendarEvent.TYPE_TASK.equals(dataType)) {
                        result.setTaskStatus(this.buildValue("exo:eventState", iter));
                    }
                    return result;
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block10;
                log.debug((Object)("Error when building result object from result data " + e));
            }
        }
        return null;
    }

    private String buildExcerpt(Object iter) throws RepositoryException {
        StringBuffer origin;
        block8: {
            origin = new StringBuffer("");
            try {
                if (iter instanceof Row) {
                    Row row = (Row)iter;
                    int counter = 0;
                    for (String field : Utils.SEARCH_FIELDS) {
                        if (row.getValue(field) == null) continue;
                        if (counter > 0) {
                            origin.append(" ");
                        }
                        origin.append(row.getValue(field).getString());
                        ++counter;
                    }
                } else {
                    Node eventNode = (Node)iter;
                    int counter = 0;
                    for (String field : Utils.SEARCH_FIELDS) {
                        if (!eventNode.hasProperty(field)) continue;
                        if (counter > 0) {
                            origin.append(" ");
                        }
                        origin.append(eventNode.getProperty(field).getString());
                        ++counter;
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)("Error when building customer exerpt property from data " + e));
            }
        }
        return origin.toString();
    }

    private String buildImageUrl(Object iter) throws RepositoryException {
        String icon = null;
        if (iter instanceof Row) {
            Row row = (Row)iter;
            if (row.getValue("exo:eventType") != null) {
                icon = CalendarEvent.TYPE_TASK.equals(row.getValue("exo:eventType").getString()) ? Utils.TASK_ICON_URL : Utils.EVENT_ICON_URL;
            }
        } else {
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty("exo:eventType")) {
                icon = CalendarEvent.TYPE_TASK.equals(eventNode.getProperty("exo:eventType").getString()) ? Utils.TASK_ICON_URL : Utils.EVENT_ICON_URL;
            }
        }
        return icon;
    }

    private long buildDate(Object iter) {
        try {
            return this.buildDate(iter, "exo:dateCreated").getTimeInMillis();
        }
        catch (NullPointerException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Clould not build date value to long from data " + e));
            }
            return 0L;
        }
    }

    private java.util.Calendar buildDate(Object iter, String readProperty) {
        try {
            if (iter instanceof Row) {
                Row row = (Row)iter;
                return row.getValue(readProperty).getDate();
            }
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty(readProperty)) {
                return eventNode.getProperty(readProperty).getDate();
            }
            return null;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Could not build date value from " + readProperty + " : " + e));
            }
            return null;
        }
    }

    private long buildScore(Object iter) {
        block3: {
            try {
                if (iter instanceof Row) {
                    Row row = (Row)iter;
                    return row.getValue("jcr:score").getLong();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)("No score return by query " + e));
            }
        }
        return 0L;
    }

    private String buildValue(String property, Object iter) throws RepositoryException {
        if (iter instanceof Row) {
            Row row = (Row)iter;
            if (row.getValue(property) != null) {
                return row.getValue(property).getString();
            }
        } else {
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty(property)) {
                return eventNode.getProperty(property).getString();
            }
        }
        return "";
    }

    private String buildDetail(Object iter, String timeZone) throws RepositoryException {
        SimpleDateFormat df = new SimpleDateFormat(Utils.DATE_TIME_FORMAT);
        df.setTimeZone(TimeZone.getTimeZone(timeZone));
        StringBuffer detail = new StringBuffer();
        if (iter instanceof Row) {
            Row row = (Row)iter;
            if (row.getValue("exo:eventType") != null) {
                if (CalendarEvent.TYPE_EVENT.equals(row.getValue("exo:eventType").getString())) {
                    if (row.getValue("exo:fromDateTime") != null) {
                        detail.append(" ").append("-").append(" ").append(df.format(row.getValue("exo:fromDateTime").getDate().getTime()));
                    }
                    if (row.getValue("exo:location") != null) {
                        detail.append(" ").append("-").append(" ").append(row.getValue("exo:location").getString());
                    }
                } else if (row.getValue("exo:toDateTime") != null) {
                    detail.append(" ").append("-").append(" ").append("Due for: ").append(df.format(row.getValue("exo:toDateTime").getDate().getTime()));
                }
            }
        } else {
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty("exo:eventType")) {
                if (CalendarEvent.TYPE_EVENT.equals(eventNode.getProperty("exo:eventType").getString())) {
                    if (eventNode.hasProperty("exo:fromDateTime")) {
                        detail.append(" ").append("-").append(" ").append(df.format(eventNode.getProperty("exo:fromDateTime").getDate().getTime()));
                    }
                    if (eventNode.hasProperty("exo:location")) {
                        detail.append(" ").append("-").append(" ").append(eventNode.getProperty("exo:location").getString());
                    }
                } else if (eventNode.hasProperty("exo:toDateTime")) {
                    detail.append(" ").append("-").append(" ").append("Due for: ").append(df.format(eventNode.getProperty("exo:toDateTime").getDate().getTime()));
                }
            }
        }
        return detail.toString();
    }

    private String buildLink(SearchContext sc, Collection<String> siteKeys, String calendarId, String eventId) {
        String url;
        block7: {
            url = "#";
            if (sc != null) {
                try {
                    String pageName;
                    String siteName;
                    SiteKey siteKey = null;
                    String spaceGroupId = null;
                    String string = siteName = sc.getSiteName() != null ? sc.getSiteName() : "intranet";
                    if (calendarId.indexOf("_space_calendar") > 0) {
                        String[] groups;
                        Calendar cal = this.getCalendarMap().get(calendarId);
                        String ownerGroup = cal.getCalendarOwner();
                        for (String g : groups = cal.getGroups()) {
                            if (!g.equals(ownerGroup)) continue;
                            spaceGroupId = ownerGroup;
                            siteKey = SiteKey.group((String)spaceGroupId);
                        }
                    }
                    if (siteKey == null) {
                        siteKey = SiteKey.portal((String)siteName);
                    }
                    if (Utils.isEmpty(pageName = CalendarSearchServiceConnector.findCalendarPageNode(siteKey))) {
                        siteKey = SiteKey.portal((String)siteName);
                        pageName = CalendarSearchServiceConnector.findCalendarPageNode(siteKey);
                    }
                    Router router = sc.getRouter();
                    ExoContainerContext context = (ExoContainerContext)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ExoContainerContext.class);
                    String handler = context.getPortalContainerName();
                    url = new StringBuffer(this.getUrl(router, handler, siteKey.getName(), spaceGroupId, pageName)).append("/").append("details").append("/").append(eventId).toString();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)"build link error !");
                }
            }
        }
        return url;
    }

    private static String findCalendarPageNode(SiteKey siteKey) {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
            NavigationContext nav = navService.loadNavigation(siteKey);
            Scope scope = siteKey.getType().equals((Object)SiteType.GROUP) ? Scope.GRANDCHILDREN : Scope.CHILDREN;
            NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, nav, scope, null);
            if (parentNodeCtx.getSize() >= 1) {
                Collection children = parentNodeCtx.getNodes();
                if (siteKey.getType() == SiteType.GROUP) {
                    children = ((NodeContext)parentNodeCtx.get(0)).getNodes();
                }
                Iterator it = children.iterator();
                NodeContext child = null;
                while (it.hasNext()) {
                    child = (NodeContext)it.next();
                    if (!"calendar".equals(child.getName()) && child.getName().indexOf("CalendarPortlet") < 0) continue;
                    return child.getName();
                }
            }
        }
        catch (NullPointerException e) {
            return "";
        }
        return "";
    }

    public String getUrl(Router router, String handler, String siteName, String spaceGroupId, String pageName) {
        HashedMap qualifiedName = new HashedMap();
        qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"handler"), (Object)handler);
        qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"path"), (Object)pageName);
        qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"lang"), (Object)"");
        if (Utils.isEmpty(spaceGroupId)) {
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitename"), (Object)siteName);
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitetype"), (Object)SiteType.PORTAL.getName());
        } else {
            Space sp;
            String groupId = spaceGroupId.split("/")[2];
            if (this.spaceService_ != null && (sp = this.spaceService_.getSpaceByGroupId(spaceGroupId)) != null) {
                groupId = sp.getPrettyName();
            }
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitename"), (Object)spaceGroupId.replaceAll("/", ":"));
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitetype"), (Object)SiteType.GROUP.getName());
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"path"), (Object)(groupId + "/" + pageName));
        }
        try {
            return "/" + handler + URLDecoder.decode(router.render((Map)qualifiedName), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private Map<String, Calendar> getCalendarMap() {
        Map<String, Calendar> map = this.calendarMap.get();
        if (map == null) {
            map = new HashMap<String, Calendar>();
            this.calendarMap.set(map);
        }
        return map;
    }
}

