/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.PopupReminderJob;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.job.MultiTenancyJob;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.ResourceBundleService;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class ReminderJob
extends MultiTenancyJob {
    private static Log log_ = ExoLogger.getLogger(ReminderJob.class);

    public Class<? extends MultiTenancyJob.MultiTenancyTask> getTask() {
        return ReminderTask.class;
    }

    private String buildBodyMessage(CalendarEvent calEvent, ResourceBundle res) {
        GregorianCalendar fromTime = new GregorianCalendar();
        GregorianCalendar toTime = new GregorianCalendar();
        String type = "Type: ";
        String summaryLabel = "Summary: ";
        String description = "Description: ";
        String from = "From: ";
        String to = "To: ";
        String location = "Location: ";
        if (res != null) {
            type = res.getString("Reminder.event.type") + ": ";
            summaryLabel = res.getString("Reminder.event.summary") + ": ";
            description = res.getString("Reminder.event.description") + ": ";
            location = res.getString("Reminder.event.place") + ": ";
            from = res.getString("Reminder.event.from") + ": ";
            to = res.getString("Reminder.event.to") + ": ";
        }
        StringBuilder summary = new StringBuilder(type);
        summary.append(calEvent.getEventType()).append("<br>");
        summary.append(summaryLabel);
        summary.append(calEvent.getSummary()).append("<br>");
        summary.append(description);
        if (calEvent.getDescription() != null) {
            summary.append(calEvent.getDescription());
        }
        summary.append("<br>");
        if (calEvent.getLocation() != null) {
            summary.append(location);
            summary.append(calEvent.getLocation());
            summary.append("<br>");
        }
        fromTime.setTime(calEvent.getFromDateTime());
        this.appendDateToSummary(from, fromTime, summary);
        toTime.setTime(calEvent.getToDateTime());
        this.appendDateToSummary(to, toTime, summary);
        return summary.toString();
    }

    private void appendDateToSummary(String label, Calendar cal, StringBuilder summary) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm - dd/MM/yyyy");
        df.setCalendar(cal);
        summary.append(label).append(df.format(cal.getTime())).append("<br>");
    }

    public class ReminderTask
    extends MultiTenancyJob.MultiTenancyTask {
        public ReminderTask(JobExecutionContext context, String repoName) {
            super((MultiTenancyJob)ReminderJob.this, context, repoName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            super.run();
            SessionProvider provider = SessionProvider.createSystemProvider();
            OrganizationService orgService = (OrganizationService)this.container.getComponentInstanceOfType(OrganizationService.class);
            if (orgService instanceof ComponentRequestLifecycle) {
                ((ComponentRequestLifecycle)orgService).startRequest(ExoContainerContext.getCurrentContainer());
            }
            try {
                MailService mailService = (MailService)this.container.getComponentInstanceOfType(MailService.class);
                UserHandler userHandler = orgService.getUserHandler();
                CalendarService calendarService = (CalendarService)this.container.getComponentInstanceOfType(CalendarService.class);
                ResourceBundleService rbs = (ResourceBundleService)this.container.getComponentInstanceOfType(ResourceBundleService.class);
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)"Calendar email reminder service");
                }
                Calendar fromCalendar = GregorianCalendar.getInstance();
                JobDataMap jdatamap = this.context.getJobDetail().getJobDataMap();
                Node calendarHome = Utils.getPublicServiceHome(provider);
                if (calendarHome == null) {
                    return;
                }
                StringBuffer path = new StringBuffer(PopupReminderJob.getReminderPath(fromCalendar, provider));
                path.append("//element(*,exo:reminder)");
                path.append("[@exo:remindDateTime <= xs:dateTime('" + ISO8601.format((Calendar)fromCalendar) + "') and @exo:isOver = 'false' and @exo:reminderType = 'email' ]");
                QueryManager queryManager = Utils.getSession(provider).getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(path.toString(), "xpath");
                QueryResult results = query.execute();
                NodeIterator iter = results.getNodes();
                while (iter.hasNext()) {
                    String[] mails;
                    Node reminder = iter.nextNode();
                    String eventId = reminder.getProperty("exo:eventId").getString();
                    CalendarEvent calEvent = calendarService.getEventById(eventId);
                    boolean isRepeat = reminder.getProperty("exo:isRepeat").getBoolean();
                    long fromTime = reminder.getProperty("exo:fromDateTime").getDate().getTimeInMillis();
                    long remindTime = reminder.getProperty("exo:remindDateTime").getDate().getTimeInMillis();
                    long interval = reminder.getProperty("exo:timeInterval").getLong() * 60L * 1000L;
                    String to = reminder.getProperty("exo:email").getString();
                    String language = null;
                    org.exoplatform.services.organization.Query q = new org.exoplatform.services.organization.Query();
                    User user = null;
                    if (to == null || to.length() <= 0) continue;
                    for (String mail : mails = to.split(",")) {
                        UserProfile profile;
                        q.setEmail(mail);
                        ListAccess list = orgService.getUserHandler().findUsersByQuery(q);
                        if (list.getSize() == 0) continue;
                        user = ((User[])list.load(0, 1))[0];
                        if (user != null && (profile = orgService.getUserProfileHandler().findUserProfileByName(user.getUserName())) != null) {
                            language = profile.getAttribute("user.language");
                        }
                        if (language == null) {
                            language = "en";
                        }
                        Locale locale = LocaleContextInfo.getLocale((String)language);
                        ResourceBundle res = rbs.getResourceBundle("locale.service.calendar.CalendarService", locale);
                        String subject = "[reminder] eXo calendar notify mail !";
                        if (res != null) {
                            subject = res.getString("Reminder.mail.subject");
                        }
                        Message message = new Message();
                        message.setMimeType("text/html");
                        message.setTo(mail);
                        message.setSubject(subject);
                        if (calEvent != null) {
                            message.setBody(ReminderJob.this.buildBodyMessage(calEvent, res));
                        } else {
                            message.setBody("");
                        }
                        message.setFrom(jdatamap.getString("account"));
                        if (isRepeat) {
                            if (fromCalendar.getTimeInMillis() >= fromTime) {
                                reminder.setProperty("exo:isOver", true);
                            } else if (remindTime + interval > fromTime) {
                                reminder.setProperty("exo:isOver", true);
                            } else {
                                long nextReminderTime;
                                long currentTime = fromCalendar.getTimeInMillis();
                                for (nextReminderTime = remindTime + interval; nextReminderTime <= currentTime; nextReminderTime += interval) {
                                }
                                GregorianCalendar cal = new GregorianCalendar();
                                cal.setTimeInMillis(nextReminderTime);
                                reminder.setProperty("exo:remindDateTime", (Calendar)cal);
                                reminder.setProperty("exo:isOver", false);
                            }
                        } else {
                            reminder.setProperty("exo:isOver", true);
                        }
                        reminder.save();
                        mailService.sendMessage(message);
                    }
                }
            }
            catch (Exception e) {
                log_.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (orgService instanceof ComponentRequestLifecycle) {
                    ((ComponentRequestLifecycle)orgService).endRequest(ExoContainerContext.getCurrentContainer());
                }
                provider.close();
            }
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"File plan job done");
            }
        }
    }
}

