/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.DataStorage;
import org.exoplatform.calendar.service.JCRPageList;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class EventPageListQuery
extends JCRPageList {
    private static final Log log = ExoLogger.getExoLogger(EventPageListQuery.class);
    private String username_;
    private NodeIterator iter_ = null;
    private String value_;
    private long pageReturn = 0L;
    private Session session_ = null;

    public EventPageListQuery(String username, String value, long pageSize) throws Exception {
        super(pageSize);
        this.username_ = username;
        this.value_ = value;
        Session session = this.getJCRSession(username);
        if (session != null) {
            this.setAvailablePage(((QueryResultImpl)this.createXPathQuery(session, username, this.value_).execute()).getTotalSize());
        }
    }

    @Override
    protected void populateCurrentPage(long page, String username) throws Exception {
        long pageSize = this.getPageSize();
        Session session = this.getJCRSession(username);
        long totalPage = 0L;
        QueryImpl queryImpl = this.createXPathQuery(session, username, this.value_);
        if (page > 1L) {
            long position = (page - 1L) * pageSize;
            if (this.pageReturn == page) {
                queryImpl.setOffset(position - 1L);
            } else {
                queryImpl.setOffset(position);
            }
        }
        queryImpl.setLimit(pageSize);
        QueryResult result = queryImpl.execute();
        this.iter_ = result.getNodes();
        totalPage = ((QueryResultImpl)result).getTotalSize();
        this.setAvailablePage(totalPage);
        this.currentListPage_ = new ArrayList();
        int i = 0;
        while ((long)i < pageSize && this.iter_ != null && this.iter_.hasNext()) {
            Node currentNode = this.iter_.nextNode();
            if (currentNode.isNodeType("exo:calendarEvent")) {
                CalendarEvent calendarEvent = this.getEvent(currentNode);
                this.currentListPage_.add(calendarEvent);
            }
            ++i;
        }
        this.iter_ = null;
    }

    public static CalendarEvent getEventFromNode(CalendarEvent event, Node eventNode, Node reminderFolder) throws Exception {
        block32: {
            int i;
            Value[] values;
            Property p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:id");
            if (p != null) {
                event.setId(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:calendarId")) != null) {
                event.setCalendarId(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:summary")) != null) {
                event.setSummary(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:eventCategoryId")) != null) {
                event.setEventCategoryId(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:eventCategoryName")) != null) {
                event.setEventCategoryName(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:location")) != null) {
                event.setLocation(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:taskDelegator")) != null) {
                event.setTaskDelegator(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:repeat")) != null) {
                event.setRepeatType(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:description")) != null) {
                event.setDescription(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:fromDateTime")) != null) {
                event.setFromDateTime(p.getDate().getTime());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:toDateTime")) != null) {
                event.setToDateTime(p.getDate().getTime());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:eventType")) != null) {
                event.setEventType(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:priority")) != null) {
                event.setPriority(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:isPrivate")) != null) {
                event.setPrivate(p.getBoolean());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:eventState")) != null) {
                event.setEventState(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:sendOption")) != null) {
                event.setSendOption(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:message")) != null) {
                event.setMessage(p.getString());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:dateModified")) != null) {
                event.setLastModified(p.getDate().getTimeInMillis());
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:invitation")) != null) {
                values = p.getValues();
                if (values.length == 1) {
                    event.setInvitation(new String[]{values[0].getString()});
                } else {
                    String[] invites = new String[values.length];
                    for (i = 0; i < values.length; ++i) {
                        invites[i] = values[i].getString();
                    }
                    event.setInvitation(invites);
                }
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:participant")) != null) {
                values = p.getValues();
                if (values.length == 1) {
                    event.setParticipant(new String[]{values[0].getString()});
                } else {
                    String[] participant = new String[values.length];
                    for (i = 0; i < values.length; ++i) {
                        participant[i] = values[i].getString();
                    }
                    event.setParticipant(participant);
                }
            }
            if ((p = EventPageListQuery.getPropertyFromNode(eventNode, "exo:participantStatus")) != null) {
                values = p.getValues();
                if (values.length == 1) {
                    event.setParticipantStatus(new String[]{values[0].getString()});
                } else {
                    String[] participantStatus = new String[values.length];
                    for (i = 0; i < values.length; ++i) {
                        participantStatus[i] = values[i].getString();
                    }
                    event.setParticipantStatus(participantStatus);
                }
            }
            try {
                event.setReminders(EventPageListQuery.getReminders(eventNode, reminderFolder));
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block32;
                log.debug((Object)"fail to set the reminders to the event", (Throwable)e);
            }
        }
        event.setAttachment(EventPageListQuery.getAttachments(eventNode));
        return event;
    }

    private static Property getPropertyFromNode(Node node, String property) throws RepositoryException {
        if (node == null || property == null) {
            return null;
        }
        try {
            return node.getProperty(property);
        }
        catch (PathNotFoundException ex) {
            return null;
        }
    }

    private CalendarEvent getEvent(Node eventNode) throws Exception {
        CalendarEvent event = new CalendarEvent();
        String emptyStr = String.valueOf("");
        if (eventNode.getPath().contains(this.getPublicServiceHome())) {
            event.setCalType(emptyStr + 2);
        } else if (eventNode.getPath().contains(this.getPrivateServiceHome())) {
            event.setCalType(emptyStr + 0);
        } else {
            event.setCalType(emptyStr + 1);
        }
        return EventPageListQuery.getEventFromNode(event, eventNode, null);
    }

    private static List<Attachment> getAttachments(Node eventNode) throws Exception {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (eventNode.hasNode("attachment")) {
            Node attachHome = eventNode.getNode("attachment");
            NodeIterator iter = attachHome.getNodes();
            while (iter.hasNext()) {
                Node contentNode;
                Node attchmentNode = iter.nextNode();
                if (!attchmentNode.isNodeType("exo:eventAttachment")) continue;
                Attachment attachment = new Attachment();
                attachment.setId(attchmentNode.getPath());
                if (attchmentNode.hasProperty("exo:fileName")) {
                    attachment.setName(attchmentNode.getProperty("exo:fileName").getString());
                }
                if ((contentNode = attchmentNode.getNode("jcr:content")) != null) {
                    if (contentNode.hasProperty("jcr:lastModified")) {
                        attachment.setLastModified(contentNode.getProperty("jcr:lastModified").getDate().getTimeInMillis());
                    }
                    if (contentNode.hasProperty("jcr:mimeType")) {
                        attachment.setMimeType(contentNode.getProperty("jcr:mimeType").getString());
                    }
                    if (contentNode.hasProperty("jcr:data")) {
                        InputStream inputStream = contentNode.getProperty("jcr:data").getStream();
                        attachment.setSize(inputStream.available());
                        attachment.setInputStream(inputStream);
                    }
                }
                attachment.setWorkspace(attchmentNode.getSession().getWorkspace().getName());
                attachments.add(attachment);
            }
        }
        return attachments;
    }

    public static List<Reminder> getReminders(Node eventNode, Node reminderFolder) throws Exception {
        ArrayList<Reminder> reminders = new ArrayList<Reminder>();
        Date fromDate = eventNode.getProperty("exo:fromDateTime").getDate().getTime();
        if (reminderFolder == null) {
            return reminders;
        }
        if (reminderFolder.hasNode(eventNode.getName())) {
            NodeIterator iter = reminderFolder.getNode(eventNode.getName()).getNodes();
            while (iter.hasNext()) {
                Node reminderNode = iter.nextNode();
                if (!reminderNode.isNodeType("exo:reminder")) continue;
                Reminder reminder = new Reminder();
                reminder.setId(reminderNode.getName());
                StringBuilder namePattern = new StringBuilder(128);
                namePattern.append("exo:creator").append('|').append("exo:eventId").append('|').append("exo:reminderType").append('|').append("exo:alarmBefore").append('|').append("exo:email").append('|').append("exo:isRepeat").append('|').append("exo:timeInterval").append('|').append("exo:description");
                PropertyIterator it = reminderNode.getProperties(namePattern.toString());
                while (it.hasNext()) {
                    Property p = it.nextProperty();
                    String name = p.getName();
                    if (name.equals("exo:creator")) {
                        reminder.setReminderOwner(p.getString());
                        continue;
                    }
                    if (name.equals("exo:eventId")) {
                        reminder.setEventId(p.getString());
                        continue;
                    }
                    if (name.equals("exo:reminderType")) {
                        reminder.setReminderType(p.getString());
                        continue;
                    }
                    if (name.equals("exo:alarmBefore")) {
                        reminder.setAlarmBefore(p.getLong());
                        continue;
                    }
                    if (name.equals("exo:email")) {
                        reminder.setEmailAddress(p.getString());
                        continue;
                    }
                    if (name.equals("exo:isRepeat")) {
                        reminder.setRepeate(p.getBoolean());
                        continue;
                    }
                    if (name.equals("exo:timeInterval")) {
                        reminder.setRepeatInterval(p.getLong());
                        continue;
                    }
                    if (!name.equals("exo:description")) continue;
                    reminder.setDescription(p.getString());
                }
                reminder.setFromDateTime(fromDate);
                reminders.add(reminder);
            }
        }
        return reminders;
    }

    @Override
    public List<CalendarEvent> getAll() throws Exception {
        Session session = this.getJCRSession(this.username_);
        QueryImpl queryImpl = this.createXPathQuery(session, this.username_, this.value_);
        QueryResult result = queryImpl.execute();
        this.iter_ = result.getNodes();
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        while (this.iter_.hasNext()) {
            Node eventNode = this.iter_.nextNode();
            events.add(this.getEvent(eventNode));
        }
        return events;
    }

    private String getPublicServiceHome() throws Exception {
        DataStorage dataStorage = (DataStorage)ExoContainerContext.getService(DataStorage.class);
        Node publicApp = dataStorage.getPublicCalendarServiceHome();
        return publicApp == null ? null : publicApp.getPath();
    }

    private String getPrivateServiceHome() throws Exception {
        DataStorage dataStorage = (DataStorage)ExoContainerContext.getService(DataStorage.class);
        Node privateApp = dataStorage.getUserCalendarServiceHome(this.username_);
        return privateApp == null ? null : privateApp.getPath();
    }

    public void setSession(Session s) {
        this.session_ = s;
    }

    private Session getJCRSession(String username) throws Exception {
        try {
            RepositoryService repositoryService = (RepositoryService)PortalContainer.getComponent(RepositoryService.class);
            SessionProvider sessionProvider = Utils.createSystemProvider();
            String defaultWS = repositoryService.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            return sessionProvider.getSession(defaultWS, repositoryService.getCurrentRepository());
        }
        catch (NullPointerException e) {
            return this.session_;
        }
    }

    private QueryImpl createXPathQuery(Session session, String username, String xpath) throws Exception {
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        return (QueryImpl)queryManager.createQuery(xpath, "xpath");
    }
}

