/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarSearchServiceConnector;
import org.exoplatform.calendar.service.impl.EventSearchConnector;
import org.exoplatform.calendar.service.impl.UnifiedQuery;
import org.exoplatform.calendar.service.test.BaseCalendarServiceTestCase;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.User;
import org.exoplatform.web.controller.metadata.ControllerDescriptor;
import org.exoplatform.web.controller.metadata.DescriptorBuilder;
import org.exoplatform.web.controller.router.Router;

public class EventTestCase
extends BaseCalendarServiceTestCase {
    private CalendarSearchServiceConnector eventSearchConnector_;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.eventSearchConnector_ = (CalendarSearchServiceConnector)this.getService(EventSearchConnector.class);
    }

    public void testRemoveUserEvent() throws Exception {
        CalendarEvent event = this.createUserEvent("TestRemoveUserEvent");
        String eventId = event.getId();
        String calendarId = event.getCalendarId();
        EventTestCase.assertNotNull((Object)this.calendarService_.getEventById(eventId));
        this.calendarService_.removeUserEvent(this.username, calendarId, eventId);
        EventTestCase.assertNull((Object)this.calendarService_.getEventById(eventId));
    }

    public void testPublicEvent() throws Exception {
        Calendar cal = this.createGroupCalendar(new String[]{"users"}, "CalendarName", "CalendarDescription");
        java.util.Calendar fromCal = java.util.Calendar.getInstance();
        java.util.Calendar toCal = java.util.Calendar.getInstance();
        toCal.add(10, 1);
        CalendarEvent calEvent = this.createGroupEvent(cal.getId(), null, "Have a meeting", true, fromCal, toCal);
        EventTestCase.assertNotNull((Object)this.calendarService_.getGroupEvent(calEvent.getId()));
        ArrayList<String> calendarIds = new ArrayList<String>();
        calendarIds.add(cal.getId());
        EventTestCase.assertEquals((int)1, (int)this.calendarService_.getGroupEventByCalendar(calendarIds).size());
        EventTestCase.assertNotNull((Object)this.calendarService_.removePublicEvent(cal.getId(), calEvent.getId()));
    }

    public void testPrivateEvent() throws Exception {
        Calendar cal = this.createPrivateCalendar(this.username, "CalendarName", "CalendarDescription");
        EventCategory eventCategory = this.createUserEventCategory(this.username, "EventCategoryName2");
        CalendarEvent calEvent = this.createUserEvent(cal.getId(), eventCategory, "Have a meeting");
        EventQuery query = new EventQuery();
        query.setCategoryId(new String[]{eventCategory.getId()});
        EventTestCase.assertEquals((int)this.calendarService_.getUserEvents(this.username, query).size(), (int)1);
        EventQuery eventQuery = new EventQuery();
        eventQuery.setText("Have a meeting");
        EventTestCase.assertEquals((int)1, (int)this.calendarService_.searchEvent(this.username, eventQuery, new String[0]).getAll().size());
        EventTestCase.assertEquals((int)1, (int)this.calendarService_.getEvents(this.username, eventQuery, new String[0]).size());
        ArrayList<CalendarEvent> list = new ArrayList<CalendarEvent>();
        list.add(calEvent);
        Calendar movedCal = new Calendar();
        movedCal.setName("MovedCalendarName");
        movedCal.setDescription("CalendarDescription");
        movedCal.setPublic(false);
        this.calendarService_.saveUserCalendar(this.username, movedCal, true);
        this.calendarService_.moveEvent(cal.getId(), movedCal.getId(), calEvent.getCalType(), calEvent.getCalType(), list, this.username);
        eventQuery = new EventQuery();
        eventQuery.setCalendarId(new String[]{movedCal.getId()});
        EventTestCase.assertEquals((int)1, (int)this.calendarService_.getEvents(this.username, eventQuery, new String[0]).size());
    }

    public void testLastUpdatedTime() throws Exception {
        CalendarEvent event = this.createUserEvent("Have a meeting");
        Date createdDate = this.calendarService_.getEventById(event.getId()).getLastUpdatedTime();
        EventTestCase.assertNotNull((Object)createdDate);
        Thread.sleep(1000L);
        event.setSummary("Have a new meeting");
        this.calendarService_.saveUserEvent(this.username, event.getCalendarId(), event, false);
        Date modifiedDate = this.calendarService_.getEventById(event.getId()).getLastUpdatedTime();
        EventTestCase.assertNotNull((Object)modifiedDate);
        EventTestCase.assertTrue((String)(modifiedDate + " should be after " + createdDate), (modifiedDate.after(createdDate) || modifiedDate.equals(createdDate) ? 1 : 0) != 0);
    }

    public void testGetPublicEvents() throws Exception {
        Calendar publicCalendar = this.createGroupCalendar(this.userGroups, "publicCalendar", "publicDescription");
        EventCategory eventCategory = this.createUserEventCategory(this.username, "GetPublicEventsCategory");
        java.util.Calendar fromCal = java.util.Calendar.getInstance();
        fromCal.add(10, 1);
        java.util.Calendar toCal = java.util.Calendar.getInstance();
        toCal.add(10, 2);
        CalendarEvent publicEvent = this.createGroupEvent(publicCalendar.getId(), eventCategory, "Have a meeting", false, fromCal, toCal);
        EventQuery eventQuery = new EventQuery();
        eventQuery.setCalendarId(new String[]{publicCalendar.getId()});
        List events = this.calendarService_.getPublicEvents(eventQuery);
        EventTestCase.assertEquals((int)1, (int)events.size());
        CalendarEvent resultEvent = (CalendarEvent)events.get(0);
        EventTestCase.assertEquals((String)publicEvent.getId(), (String)resultEvent.getId());
        EventTestCase.assertEquals((String)publicEvent.getSummary(), (String)resultEvent.getSummary());
        this.login("john");
        UnifiedQuery query = new UnifiedQuery();
        query.setText("  \" a meeting\" ");
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        ArrayList params = new ArrayList();
        Collection rs = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        EventTestCase.assertEquals((int)1, (int)rs.size());
        this.checkFields((SearchResult)rs.iterator().next());
        this.login(this.username);
        rs = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        EventTestCase.assertEquals((int)1, (int)rs.size());
        this.checkFields((SearchResult)rs.iterator().next());
        publicCalendar = this.calendarService_.getGroupCalendar(publicCalendar.getId());
        publicCalendar.setGroups(new String[]{"/platform/guests"});
        this.calendarService_.savePublicCalendar(publicCalendar, false);
        rs = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        EventTestCase.assertEquals((int)0, (int)rs.size());
        this.login("demo");
        rs = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        EventTestCase.assertEquals((int)1, (int)rs.size());
        Group g = this.organizationService_.getGroupHandler().createGroupInstance();
        g.setGroupName("spacetest");
        g.setLabel("Calendar Space");
        g.setDescription("simulate space creted");
        this.organizationService_.getGroupHandler().addChild(null, g, true);
        g = this.organizationService_.getGroupHandler().findGroupById(g.getId());
        Collection gr = this.organizationService_.getGroupHandler().findGroupsOfUser("raul");
        EventTestCase.assertEquals((int)1, (int)gr.size());
        User u = this.organizationService_.getUserHandler().findUserByName("raul");
        MembershipType m = (MembershipType)this.organizationService_.getMembershipTypeHandler().findMembershipTypes().toArray()[0];
        this.organizationService_.getMembershipHandler().linkMembership(u, g, m, false);
        gr = this.organizationService_.getGroupHandler().findGroupsOfUser("raul");
        EventTestCase.assertEquals((int)2, (int)gr.size());
        List spaceCals = this.calendarService_.getGroupCalendars(new String[]{"/spacetest"}, true, "raul");
        EventTestCase.assertEquals((int)1, (int)((GroupCalendarData)spaceCals.get(0)).getCalendars().size());
        Calendar spaceCal = (Calendar)((GroupCalendarData)spaceCals.get(0)).getCalendars().get(0);
        publicEvent.setCalendarId(spaceCal.getId());
        publicEvent.setSummary("space event created");
        this.calendarService_.savePublicEvent(spaceCal.getId(), publicEvent, true);
        query.setText("\"space event\"");
        this.login("raul");
        SearchContext sc = new SearchContext(this.loadConfiguration("conf/portal/controller.xml"), "classic");
        EventTestCase.assertNotNull((Object)sc);
        sc.lang("en");
        rs = this.eventSearchConnector_.search(sc, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        EventTestCase.assertEquals((int)1, (int)rs.size());
        SearchResult item = (SearchResult)rs.iterator().next();
        this.checkFields(item);
        EventTestCase.assertEquals((String)("/portal/classic/calendar/details/" + publicEvent.getId()), (String)item.getUrl());
    }

    public void testGetEvent() throws Exception {
        Calendar calendar = this.createPrivateCalendar(this.username, "myCalendar", "Description");
        EventCategory eventCategory = this.createUserEventCategory(this.username, "eventCategoryName3");
        java.util.Calendar fromCal = java.util.Calendar.getInstance();
        java.util.Calendar toCal = java.util.Calendar.getInstance();
        toCal.add(10, 1);
        String attachmentName = "Acttach file";
        String attachmentMinetype = "MimeType";
        Attachment attachment = new Attachment();
        attachment.setName(attachmentName);
        attachment.setInputStream(new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }
        });
        attachment.setMimeType(attachmentMinetype);
        String reminderType = Reminder.TYPE_BOTH;
        long reminderAlarmBefore = new Date().getTime();
        String reminderEmailAddress = "abc@gmail.com";
        Reminder reminder = new Reminder(reminderType);
        reminder.setAlarmBefore(reminderAlarmBefore);
        reminder.setEmailAddress(reminderEmailAddress);
        reminder.setRepeate(false);
        String eventSummay = "Have a meeting";
        CalendarEvent calendarEvent = new CalendarEvent();
        calendarEvent.setEventCategoryId(eventCategory.getId());
        calendarEvent.setEventCategoryName(eventCategory.getName());
        calendarEvent.setSummary(eventSummay);
        calendarEvent.setFromDateTime(fromCal.getTime());
        calendarEvent.setToDateTime(toCal.getTime());
        calendarEvent.setAttachment(Arrays.asList(attachment));
        calendarEvent.setReminders(Arrays.asList(reminder));
        this.calendarService_.saveUserEvent(this.username, calendar.getId(), calendarEvent, true);
        CalendarEvent findEvent = this.calendarService_.getEvent(this.username, calendarEvent.getId());
        EventTestCase.assertNotNull((Object)findEvent);
        EventTestCase.assertEquals((String)eventSummay, (String)findEvent.getSummary());
        List attachments = findEvent.getAttachment();
        EventTestCase.assertNotNull((Object)attachments);
        EventTestCase.assertEquals((int)1, (int)attachments.size());
        Attachment eventAttachment = (Attachment)attachments.get(0);
        EventTestCase.assertEquals((String)attachmentName, (String)eventAttachment.getName());
        EventTestCase.assertEquals((String)attachmentMinetype, (String)eventAttachment.getMimeType());
        List reminders = findEvent.getReminders();
        EventTestCase.assertNotNull((Object)reminders);
        EventTestCase.assertEquals((int)1, (int)reminders.size());
        Reminder eventReminder = (Reminder)reminders.get(0);
        EventTestCase.assertEquals((String)reminderType, (String)eventReminder.getReminderType());
        EventTestCase.assertEquals((long)reminderAlarmBefore, (long)eventReminder.getAlarmBefore());
        EventTestCase.assertEquals((String)reminderEmailAddress, (String)eventReminder.getEmailAddress());
        EventTestCase.assertEquals((boolean)false, (boolean)eventReminder.isRepeat());
        findEvent.setReminders(null);
        this.calendarService_.saveUserEvent(this.username, calendar.getId(), findEvent, false);
        CalendarEvent findEvent1 = this.calendarService_.getEvent(this.username, calendarEvent.getId());
        EventTestCase.assertNotNull((Object)findEvent1);
        List reminders1 = findEvent1.getReminders();
        EventTestCase.assertEquals((int)0, (int)reminders1.size());
    }

    public void testGetEventById() throws Exception {
        CalendarEvent calendarEvent = this.createUserEvent("Have a meeting");
        CalendarEvent findEvent1 = this.calendarService_.getEventById(calendarEvent.getId());
        EventTestCase.assertNotNull((Object)findEvent1);
    }

    public void testMoveEvent() throws Exception {
        Calendar calendar = this.createPrivateCalendar(this.username, "myCalendar", "Description");
        Calendar publicCalendar = this.createGroupCalendar(this.userGroups, "publicCalendar", "publicDescription");
        EventCategory eventCategory = this.createUserEventCategory(this.username, "MoveEventCategory");
        java.util.Calendar fromCal = java.util.Calendar.getInstance();
        java.util.Calendar toCal = java.util.Calendar.getInstance();
        toCal.add(10, 1);
        CalendarEvent event = this.createGroupEvent(publicCalendar.getId(), eventCategory, "Have a meeting", true, fromCal, toCal);
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        events.add(event);
        this.calendarService_.moveEvent(publicCalendar.getId(), calendar.getId(), String.valueOf(2), String.valueOf(0), events, this.username);
        CalendarEvent userEvent = this.calendarService_.getEvent(this.username, event.getId());
        EventTestCase.assertNotNull((Object)userEvent);
        ArrayList<CalendarEvent> events1 = new ArrayList<CalendarEvent>();
        events1.add(userEvent);
        this.calendarService_.moveEvent(calendar.getId(), publicCalendar.getId(), String.valueOf(0), String.valueOf(2), events1, this.username);
        CalendarEvent publicEvent = this.calendarService_.getGroupEvent(publicCalendar.getId(), userEvent.getId());
        EventTestCase.assertNotNull((Object)publicEvent);
    }

    public void testDeleteAttachment() throws Exception {
        CalendarEvent ev = this.createUserEvent("event with attachment");
        ArrayList<Attachment> att = new ArrayList<Attachment>();
        for (int i = 0; i < 12; ++i) {
            Attachment file = new Attachment();
            InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("png_attachment.ics");
            file.setName("attachement-" + i + ".ics");
            file.setInputStream(input);
            file.setMimeType("text/calendar");
            att.add(file);
        }
        ev.setAttachment(att);
        this.calendarService_.saveUserEvent(this.username, ev.getCalendarId(), ev, false);
        String attId = ((Attachment)this.calendarService_.getEventById(ev.getId()).getAttachment().get(0)).getId();
        this.calendarService_.removeAttachmentById(attId);
        Attachment a = this.calendarService_.getAttachmentById(attId);
        EventTestCase.assertNull((Object)a);
        EventTestCase.assertEquals((int)11, (int)this.calendarService_.getEventById(ev.getId()).getAttachment().size());
        attId = ((Attachment)this.calendarService_.getEventById(ev.getId()).getAttachment().get(0)).getId();
        this.calendarService_.removeAttachmentById(attId);
        a = this.calendarService_.getAttachmentById(attId);
        EventTestCase.assertNull((Object)a);
        EventTestCase.assertEquals((int)10, (int)this.calendarService_.getEventById(ev.getId()).getAttachment().size());
    }

    public void testAttachment() throws Exception {
        CalendarEvent ev = this.createUserEvent("event with attachment");
        ArrayList<Attachment> att = new ArrayList<Attachment>();
        for (int i = 0; i < 12; ++i) {
            Attachment file = new Attachment();
            InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream("png_attachment.ics");
            file.setName("attachement-" + i + ".ics");
            file.setInputStream(input);
            file.setMimeType("text/calendar");
            att.add(file);
        }
        ev.setAttachment(att);
        this.calendarService_.saveUserEvent(this.username, ev.getCalendarId(), ev, false);
        String attId = ((Attachment)this.calendarService_.getEventById(ev.getId()).getAttachment().get(0)).getId();
        Attachment a = this.calendarService_.getAttachmentById(attId);
        EventTestCase.assertNotNull((Object)a);
    }

    private void checkFields(SearchResult item) {
        EventTestCase.assertNotNull((Object)item.getTitle());
        EventTestCase.assertNotNull((Object)item.getExcerpt());
        EventTestCase.assertNotNull((Object)item.getDetail());
        EventTestCase.assertNull((Object)item.getImageUrl());
        EventTestCase.assertNotNull((Object)item.getUrl());
        EventTestCase.assertEquals((boolean)true, (item.getDate() > 0L ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Router loadConfiguration(String path) throws IOException {
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
            ControllerDescriptor routerDesc = new DescriptorBuilder().build(in);
            Router router = new Router(routerDesc);
            return router;
        }
        return null;
    }
}

