/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.statistics;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.cs.statistics.JCRAPIAspectConfig;
import org.exoplatform.services.jcr.statistics.JCRStatisticsManager;
import org.exoplatform.services.jcr.statistics.Statistics;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

@Aspect
public abstract class JCRAPIAspect {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.statistics.JCRAPIAspectC");
    private static final Statistics UNKNOWN = new Statistics(null, "?");
    private static volatile boolean INITIALIZED;
    private static Class<?>[] TARGET_INTERFACES;
    private static volatile Map<String, Statistics> MAPPING;
    private static final Map<String, Map<String, Statistics>> ALL_STATISTICS;

    static {
        MAPPING = Collections.unmodifiableMap(new HashMap());
        ALL_STATISTICS = new HashMap<String, Map<String, Statistics>>();
    }

    private static String getStatisticsName(Method m) {
        StringBuilder sb = new StringBuilder();
        sb.append(m.getName());
        sb.append('(');
        Class<?>[] types = m.getParameterTypes();
        if (types != null) {
            boolean first = true;
            Class<?>[] classArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> type = classArray[n2];
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(type.getSimpleName());
                ++n2;
            }
        }
        sb.append(')');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Statistics getStatistics(Class<?> target, String signature) {
        JCRAPIAspect.initIfNeeded();
        Statistics statistics = MAPPING.get(signature);
        if (statistics == null) {
            Map<String, Statistics> allStatistics;
            Class<JCRAPIAspect> clazz = JCRAPIAspect.class;
            // MONITORENTER : org.exoplatform.cs.statistics.JCRAPIAspect.class
            Class<?> interfaceClass = JCRAPIAspect.findInterface(target);
            if (interfaceClass != null && (allStatistics = ALL_STATISTICS.get(interfaceClass.getSimpleName())) != null) {
                int index1 = signature.indexOf(40);
                int index = signature.substring(0, index1).lastIndexOf(46);
                String name = signature.substring(index + 1);
                statistics = allStatistics.get(name);
            }
            if (statistics == null) {
                statistics = UNKNOWN;
            }
            HashMap<String, Statistics> tempMapping = new HashMap<String, Statistics>(MAPPING);
            tempMapping.put(signature, statistics);
            MAPPING = Collections.unmodifiableMap(tempMapping);
            // MONITOREXIT : clazz
        }
        if (!UNKNOWN.equals(statistics)) return statistics;
        return null;
    }

    private static Class<?> findInterface(Class<?> target) {
        if (target == null) {
            return null;
        }
        Class<?>[] interfaces = target.getInterfaces();
        if (interfaces != null) {
            Class<?>[] classArray = TARGET_INTERFACES;
            int n = TARGET_INTERFACES.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> c = classArray[n2];
                Class<?>[] classArray2 = interfaces;
                int n3 = interfaces.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> i = classArray2[n4];
                    if (c.getName().equals(i.getName())) {
                        return c;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return JCRAPIAspect.findInterface(target.getSuperclass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initIfNeeded() {
        if (INITIALIZED) return;
        Class<JCRAPIAspect> clazz = JCRAPIAspect.class;
        synchronized (JCRAPIAspect.class) {
            if (INITIALIZED) return;
            ExoContainer container = ExoContainerContext.getTopContainer();
            JCRAPIAspectConfig config = null;
            if (container != null) {
                config = (JCRAPIAspectConfig)container.getComponentInstanceOfType(JCRAPIAspectConfig.class);
            }
            if (config == null) {
                TARGET_INTERFACES = new Class[0];
                LOG.warn((Object)"No interface to monitor could be found");
            } else {
                Class<?>[] classArray = TARGET_INTERFACES = config.getTargetInterfaces();
                int n = TARGET_INTERFACES.length;
                int n2 = 0;
                while (n2 < n) {
                    Method[] methods;
                    Class<?> c = classArray[n2];
                    Statistics global = new Statistics(null, "global");
                    TreeMap<String, Statistics> statistics = new TreeMap<String, Statistics>();
                    Method[] methodArray = methods = c.getMethods();
                    int n3 = methods.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Method m = methodArray[n4];
                        String name = JCRAPIAspect.getStatisticsName(m);
                        statistics.put(name, new Statistics(global, name));
                        ++n4;
                    }
                    JCRStatisticsManager.registerStatistics((String)c.getSimpleName(), (Statistics)global, statistics);
                    ALL_STATISTICS.put(c.getSimpleName(), statistics);
                    ++n2;
                }
            }
            INITIALIZED = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Pointcut
    abstract /* synthetic */ void JCRAPIPointcut();

    @Before(value="JCRAPIPointcut()")
    public void begin(JoinPoint thisJoinPoint) {
        Statistics statistics = JCRAPIAspect.getStatistics(thisJoinPoint.getTarget().getClass(), thisJoinPoint.getSignature().toString());
        if (statistics != null) {
            statistics.begin();
        }
    }

    @After(value="JCRAPIPointcut()")
    public void end(JoinPoint thisJoinPoint) {
        Statistics statistics = JCRAPIAspect.getStatistics(thisJoinPoint.getTarget().getClass(), thisJoinPoint.getSignature().toString());
        if (statistics != null) {
            statistics.end();
        }
    }
}

