/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UISelectUserForm;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UISelectUserForm.gtmpl", events={@EventConfig(listeners={ReplaceActionListener.class}), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CloseActionListener.class}, phase=Event.Phase.DECODE)})
public class UISelectUserForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_KEYWORD = "keyWord".intern();
    public static final String FIELD_FILTER = "filter".intern();
    public static final String FIELD_GROUP = "group".intern();
    public static String USER_NAME = "userName";
    public static String LAST_NAME = "lastName";
    public static String FIRST_NAME = "firstName";
    public static String EMAIL = "email";
    protected Map<String, User> userData_ = new HashMap();
    private boolean isShowSearch_ = false;
    protected String tabId_ = null;
    protected String groupId_ = null;
    protected Collection<String> pars_;
    public UIPageIterator uiIterator_;

    public List<User> getData() throws Exception {
        for (Object obj : this.uiIterator_.getCurrentPageData()) {
            User user = (User)obj;
            if (this.getUIFormCheckBoxInput(user.getUserName()) != null) continue;
            this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(user.getUserName(), user.getUserName(), (Object)false));
        }
        for (String s : this.pars_) {
            if (this.getUIFormCheckBoxInput(s) == null) continue;
            this.getUIFormCheckBoxInput(s).setChecked(true);
        }
        return new ArrayList<User>(this.uiIterator_.getCurrentPageData());
    }

    public UISelectUserForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_KEYWORD, FIELD_KEYWORD, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_FILTER, FIELD_FILTER, this.getFilters()));
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(FIELD_GROUP, FIELD_GROUP, this.getGroups());
        this.addUIFormInput((UIFormInput)uiSelectBox);
        uiSelectBox.setOnChange("Change");
        this.isShowSearch_ = true;
        this.uiIterator_ = new UIPageIterator();
        this.uiIterator_.setId("UISelectUserPage");
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiIterator_;
    }

    public long getAvailablePage() {
        return this.uiIterator_.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.uiIterator_.getCurrentPage();
    }

    public void init(Collection<String> pars) throws Exception {
        OrganizationService service = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(User.class, service.getUserHandler().getUserPageList(0).getAll()), 10);
        this.uiIterator_.setPageList((PageList)pageList);
        this.pars_ = pars;
    }

    private List<SelectItemOption<String>> getGroups() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        OrganizationService orgService = CalendarUtils.getOrganizationService();
        options.add(new SelectItemOption("all", (Object)"all"));
        for (Object g : orgService.getGroupHandler().getAllGroups()) {
            Group cg = (Group)g;
            options.add((SelectItemOption<String>)new SelectItemOption(cg.getGroupName(), (Object)cg.getId()));
        }
        return options;
    }

    private List<SelectItemOption<String>> getFilters() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(USER_NAME, (Object)USER_NAME));
        options.add(new SelectItemOption(LAST_NAME, (Object)LAST_NAME));
        options.add(new SelectItemOption(FIRST_NAME, (Object)FIRST_NAME));
        options.add(new SelectItemOption(EMAIL, (Object)EMAIL));
        return options;
    }

    public String[] getActions() {
        return new String[]{"Add", "Replace", "Close"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    public void setShowSearch(boolean isShowSearch) {
        this.isShowSearch_ = isShowSearch;
    }

    public boolean isShowSearch() {
        return this.isShowSearch_;
    }

    public String getSelectedGroup() {
        if ("all".equals(this.getUIFormSelectBox(FIELD_GROUP).getValue())) {
            return null;
        }
        return (String)this.getUIFormSelectBox(FIELD_GROUP).getValue();
    }

    public void setSelectedGroup(String selectedGroup) {
        this.getUIFormSelectBox(FIELD_GROUP).setValue(selectedGroup);
        this.groupId_ = selectedGroup;
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.uiIterator_.setCurrentPage(page);
    }

    public void setKeyword(String value) {
        this.getUIStringInput(FIELD_KEYWORD).setValue((Object)value);
    }
}

