/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.webui.UIFormColorPicker;
import org.exoplatform.calendar.webui.popup.UIImportForm;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UISelector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UIUploadInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIImportForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ImportActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIImportForm
extends UIForm
implements UIPopupComponent,
UISelector {
    private static final Log log = ExoLogger.getLogger(UIImportForm.class);
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String SELECT_COLOR = "selectColor";
    public static final String TIMEZONE = "timeZone";
    public static final String PERMISSION_SUB = "_permission";
    public Map<String, Map<String, String>> perms_ = new HashMap();
    public static final String TYPE = "type";
    public static final String FIELD_UPLOAD = "upload";
    public static final String FIELD_TO_CALENDAR = "impotTo";
    public static final String ONCHANGE = "OnChange";
    public static final int UPDATE_EXIST = 1;
    public static final int ADD_NEW = 0;
    protected int flag_ = -1;

    public UIImportForm() throws Exception {
        this.setMultiPart(true);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        for (String type : calendarService.getExportImportType()) {
            options.add(new SelectItemOption(type, (Object)type));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(TYPE, TYPE, options));
        this.addUIFormInput((UIFormInput)new UIUploadInput(FIELD_UPLOAD, FIELD_UPLOAD, 1, CalendarUtils.getLimitUploadSize()));
        UIFormSelectBoxWithGroups privateCal = new UIFormSelectBoxWithGroups(FIELD_TO_CALENDAR, FIELD_TO_CALENDAR, CalendarUtils.getCalendarOption());
        this.addUIFormInput((UIFormInput)privateCal);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DISPLAY_NAME, DISPLAY_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(SpecialCharacterValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, null));
        CalendarSetting setting = CalendarUtils.getCurrentUserCalendarSetting();
        UIFormStringInput timeZones = new UIFormStringInput(TIMEZONE, TIMEZONE, CalendarUtils.generateTimeZoneLabel((String)setting.getTimeZone()));
        timeZones.setReadOnly(true);
        timeZones.setLabel(setting.getTimeZone());
        this.addUIFormInput((UIFormInput)timeZones);
        UIFormColorPicker uiFormColorPicker = new UIFormColorPicker(SELECT_COLOR, SELECT_COLOR);
        uiFormColorPicker.setNumberItemsPerLine(6);
        this.addUIFormInput((UIFormInput)uiFormColorPicker);
    }

    public void init(String calId, String calType) {
        if (!CalendarUtils.isEmpty((String)calId)) {
            UIFormSelectBoxWithGroups selectBox = this.getUIFormSelectBoxGroup(FIELD_TO_CALENDAR);
            if (selectBox.getOptions() != null && !selectBox.getOptions().isEmpty()) {
                this.switchMode(1);
                selectBox.setValue(calType + CalendarUtils.COLON + calId);
            } else {
                this.switchMode(0);
            }
        } else {
            this.switchMode(0);
        }
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            return id;
        }
    }

    private List getSelectedGroups(String groupId) throws Exception {
        ArrayList<Group> groups = new ArrayList<Group>();
        Group g = ((OrganizationService)this.getApplicationComponent(OrganizationService.class)).getGroupHandler().findGroupById(groupId);
        groups.add(g);
        return groups;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public List<SelectItemOption<String>> getPrivateCalendars() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        try {
            for (Calendar c : CalendarUtils.getCalendarService().getUserCalendars(CalendarUtils.getCurrentUser(), true)) {
                options.add((SelectItemOption<String>)new SelectItemOption(c.getName(), (Object)c.getId()));
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get private calendars.", (Throwable)e);
        }
        return options;
    }

    public boolean isNew() {
        return this.flag_ == 0;
    }

    protected String getDescription() {
        return (String)this.getUIFormTextAreaInput(DESCRIPTION).getValue();
    }

    protected String getSelectedColor() {
        return (String)((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).getValue();
    }

    protected String getTimeZone() {
        return this.getUIStringInput(TIMEZONE).getLabel();
    }

    public void switchMode(int flag) {
        this.flag_ = flag;
        if (flag == 1) {
            this.getUIFormSelectBoxGroup(FIELD_TO_CALENDAR).setRendered(true);
            this.getUIStringInput(DISPLAY_NAME).setRendered(false);
            this.getUIFormTextAreaInput(DESCRIPTION).setRendered(false);
            ((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).setRendered(false);
            this.getUIStringInput(TIMEZONE).setRendered(false);
        } else if (flag == 0) {
            this.getUIFormSelectBoxGroup(FIELD_TO_CALENDAR).setRendered(false);
            this.getUIStringInput(DISPLAY_NAME).setRendered(true);
            this.getUIFormTextAreaInput(DESCRIPTION).setRendered(true);
            ((UIFormColorPicker)this.getChild(UIFormColorPicker.class)).setRendered(true);
            this.getUIStringInput(TIMEZONE).setRendered(true);
        } else {
            log.warn((Object)("Wrong flag(" + flag + ") only UPDATE_EXIST(1) or ADD_NEW(0) accept "));
        }
    }

    public UIFormSelectBoxWithGroups getUIFormSelectBoxGroup(String id) {
        return (UIFormSelectBoxWithGroups)this.findComponentById(id);
    }

    protected String getCalendarId() {
        UIFormSelectBoxWithGroups calendars = this.getUIFormSelectBoxGroup(FIELD_TO_CALENDAR);
        String value = (String)calendars.getValue();
        if (!CalendarUtils.isEmpty((String)value) && value.split(CalendarUtils.COLON).length > 0) {
            return value.split(CalendarUtils.COLON)[1];
        }
        return value;
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIFormStringInput fieldInput = this.getUIStringInput(selectField);
        StringBuilder sb = new StringBuilder();
        Map<String, String> temp = new HashMap<String, String>();
        String key = value.substring(0, value.lastIndexOf(CalendarUtils.COLON_SLASH) - 1);
        String tempS = value.substring(value.lastIndexOf(CalendarUtils.COLON_SLASH) + 2);
        if (this.perms_.get(selectField) == null) {
            temp.put(key, tempS);
        } else {
            temp = (Map)this.perms_.get(selectField);
            if (temp.get(key) != null && !tempS.equals(temp.get(key))) {
                tempS = (String)temp.get(key) + CalendarUtils.COMMA + tempS;
            }
            temp.put(key, tempS);
        }
        this.perms_.put(selectField, temp);
        HashMap<String, String> tempMap = new HashMap<String, String>();
        for (String s : temp.values()) {
            for (String t : s.split(CalendarUtils.COMMA)) {
                tempMap.put(t, t);
            }
        }
        for (String s : tempMap.values()) {
            if (sb != null && sb.length() > 0) {
                sb.append(CalendarUtils.COMMA);
            }
            sb.append(s);
        }
        fieldInput.setValue((Object)sb.toString());
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

