/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.webui.UIFormColorPicker;
import org.exoplatform.calendar.webui.popup.UICalendarDetailTab;
import org.exoplatform.calendar.webui.popup.UICalendarForm;
import org.exoplatform.calendar.webui.popup.UIGroupCalendarTab;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UISelector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.SpecialCharacterValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ResetActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormTabPane.SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowPublicURLActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ActiveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeactiveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeletePermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OpenSelectGroupFormActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddGroupActionListener.class}, phase=Event.Phase.DECODE)})
public class UICalendarForm
extends UIFormTabPane
implements UIPopupComponent,
UISelector {
    private static final Log LOG = ExoLogger.getExoLogger(UICalendarForm.class);
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String CATEGORY = "category";
    public static final String SHARED_GROUPS = "sharedGroups";
    public static final String SELECT_COLOR = "selectColor";
    public static final String SELECT_GROUPS = "selectGroups";
    public static final String EDIT_PERMISSION = "editPermission";
    public static final String ACTIONS = "permissionActions";
    public static final String ADD_GROUP_INPUT = "AddGroupInput";
    public static final String ADD_GROUP_INPUT_LABEL = "Select Group";
    public static final String OPEN_SELECT_GROUP_FORM = "OpenSelectGroupForm";
    public static final String ADD_GROUP = "AddGroup";
    public static final String INPUT_CALENDAR = "calendarDetail";
    public static final String INPUT_SHARE = "public";
    public static final String TIMEZONE = "timeZone";
    public static final String LOCALE = "locale";
    public static final String PERMISSION_SUB = "_permission";
    public static final String PUBLIC_URL = "public-url";
    public static final String PRIVATE_URL = "private-url";
    public static final String PUBLIC_URL_MSG = "public-url-msg-active";
    public static final String PUBLIC_URL_MSG_D = "public-url-msg-deactive";
    public static final String ACTION_SELECT_PERMISSION = "SelectPermission";
    public static final String ACTION_DELETE_PERMISSION = "DeletePermission";
    public static final String ACT_ADD_CATEGORY = "AddCategory";
    public static final String ACT_OPEN = "Open";
    public static final String ACT_SUBSCRIBE = "Subscribe";
    public static final String ACT_ACTIVE = "Active";
    public static final String ACT_DEACTIVE = "Deactive";
    public static final int TYPE_BUTTON = 5;
    public Map<String, String> permission_ = new HashMap();
    public Map<String, Map<String, String>> perms_ = new HashMap();
    public Calendar calendar_ = null;
    public String calType_ = CalendarUtils.PRIVATE_TYPE;
    private boolean isAddNew_ = true;
    public String groupCalId_ = null;
    private static Set<String> userGroups;

    public UICalendarForm() throws Exception {
        super("UICalendarForm");
        userGroups = this.getCurrentUserGroups();
        UICalendarDetailTab calendarDetail = new UICalendarDetailTab(INPUT_CALENDAR);
        calendarDetail.addUIFormInput((UIFormInput)new UIFormStringInput(DISPLAY_NAME, DISPLAY_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(SpecialCharacterValidator.class, new Object[0]));
        calendarDetail.addUIFormInput((UIFormInput)new UIFormTextAreaInput(DESCRIPTION, DESCRIPTION, null));
        CalendarSetting setting = CalendarUtils.getCurrentUserCalendarSetting();
        UIFormStringInput timeZone = new UIFormStringInput(TIMEZONE, TIMEZONE, CalendarUtils.generateTimeZoneLabel((String)setting.getTimeZone()));
        timeZone.setLabel(setting.getTimeZone());
        timeZone.setDisabled(true);
        calendarDetail.addUIFormInput((UIFormInput)timeZone);
        UIFormColorPicker colorPicker = new UIFormColorPicker(SELECT_COLOR, SELECT_COLOR);
        colorPicker.setNumberItemsPerLine(6);
        calendarDetail.addUIFormInput((UIFormInput)colorPicker);
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData addCategory = new UIFormInputWithActions.ActionData();
        addCategory.setActionListener(ACT_ADD_CATEGORY);
        addCategory.setActionType(0);
        addCategory.setActionName(ACT_ADD_CATEGORY);
        actions.add(addCategory);
        calendarDetail.setActionField(CATEGORY, actions);
        this.setSelectedTab(calendarDetail.getId());
        this.addChild((UIComponent)calendarDetail);
        this.initGroupTab();
    }

    private Set<String> getCurrentUserGroups() throws Exception {
        Object[] groups = this.getPublicGroups();
        HashSet<String> userGroups = new HashSet<String>();
        for (Object aGroup : groups) {
            userGroups.add(((Group)aGroup).getId());
        }
        return userGroups;
    }

    public static boolean isGroupBelongingToUserGroups(String groupId) {
        return userGroups.contains(groupId);
    }

    private void initGroupTab() throws Exception {
        UIGroupCalendarTab groupTab = new UIGroupCalendarTab(INPUT_SHARE);
        groupTab.addUIFormInput((UIFormInput)new UIFormInputInfo(SELECT_GROUPS, SELECT_GROUPS, null));
        groupTab.addUIFormInput((UIFormInput)new UIFormStringInput(EDIT_PERMISSION, null, null));
        String selectGroupLbl = CalendarUtils.getResourceBundle((String)"UICalendarForm.label.AddGroupInput", (String)ADD_GROUP_INPUT_LABEL);
        groupTab.addUIFormInput((UIFormInput)new UIFormStringInput(ADD_GROUP_INPUT, null, selectGroupLbl));
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData openGroupPopupAction = new UIFormInputWithActions.ActionData();
        openGroupPopupAction.setActionListener(OPEN_SELECT_GROUP_FORM);
        openGroupPopupAction.setActionName(OPEN_SELECT_GROUP_FORM);
        openGroupPopupAction.setActionType(0);
        openGroupPopupAction.setCssIconClass("uiIconGroup uiIconLightGray");
        actions.add(openGroupPopupAction);
        groupTab.setActionField(OPEN_SELECT_GROUP_FORM, actions);
        actions = new ArrayList();
        UIFormInputWithActions.ActionData addGroupAction = new UIFormInputWithActions.ActionData();
        addGroupAction.setActionListener(ADD_GROUP);
        addGroupAction.setActionName(ADD_GROUP);
        addGroupAction.setActionType(5);
        addGroupAction.setCssIconClass("btn");
        actions.add(addGroupAction);
        groupTab.setActionField(ADD_GROUP, actions);
        this.addChild((UIComponent)groupTab);
    }

    public String getCalType() {
        return this.calType_;
    }

    public String[] getActions() {
        return new String[]{"Save", "Reset", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void resetField() throws Exception {
        this.permission_.clear();
        this.perms_.clear();
        UIGroupCalendarTab groupTab = (UIGroupCalendarTab)this.getChildById(INPUT_SHARE);
        groupTab.resetTab();
        if (this.isAddNew_) {
            this.calendar_ = null;
            this.calType_ = CalendarUtils.PRIVATE_TYPE;
            this.setDisplayName(null);
            this.setDescription(null);
            this.setTimeZone(null);
            this.setSelectedColor(null);
        } else {
            this.init(this.calendar_, null);
        }
    }

    public boolean isAddNew() {
        return this.isAddNew_;
    }

    public void init(Calendar calendar, CalendarSetting setting) throws Exception {
        this.isAddNew_ = false;
        this.calendar_ = calendar;
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        if (setting != null) {
            UIFormStringInput info = calendarDetail.getUIStringInput(TIMEZONE);
            info.setValue((Object)CalendarUtils.generateTimeZoneLabel((String)setting.getTimeZone()));
            info.setLabel(setting.getTimeZone());
        }
        this.setDisplayName(calendar.getName());
        this.setDescription(calendar.getDescription());
        UIGroupCalendarTab groupTab = (UIGroupCalendarTab)this.getChildById(INPUT_SHARE);
        if (CalendarUtils.PUBLIC_TYPE.equals(this.calType_)) {
            groupTab.setRendered(true);
            for (String groupId : calendar.getGroups()) {
                groupTab.addGroupPermissionEntry(groupId);
            }
            groupTab.setGroupsListInitial();
            calendarDetail.removeChildById(CATEGORY);
            calendarDetail.setActionField(CATEGORY, null);
            for (String groupId : calendar.getGroups()) {
                UIFormStringInput selectPermissionInput = (UIFormStringInput)groupTab.getChildById(groupId + PERMISSION_SUB);
                if (selectPermissionInput == null) continue;
                StringBuffer sb = new StringBuffer();
                ArrayList<String> checkList = new ArrayList<String>();
                if (calendar.getEditPermission() != null) {
                    for (String s : calendar.getEditPermission()) {
                        if (s.lastIndexOf(CalendarUtils.SLASH_COLON) <= -1) continue;
                        String id = s.split(CalendarUtils.SLASH_COLON)[0].trim();
                        String perm = s.split(CalendarUtils.SLASH_COLON)[1].trim();
                        if (!groupId.equals(id) || checkList.contains(s.split(CalendarUtils.SLASH_COLON)[1])) continue;
                        checkList.add(perm);
                        if (sb.length() > 0) {
                            sb.append(CalendarUtils.COMMA + " ");
                        }
                        sb.append(perm);
                    }
                }
                selectPermissionInput.setValue((Object)sb.toString());
            }
        } else if (CalendarUtils.PRIVATE_TYPE.equals(this.calType_)) {
            groupTab.setRendered(false);
        }
        this.setTimeZone(setting.getTimeZone());
        this.setSelectedColor(calendar.getCalendarColor());
        if (calendar.getPrivateUrl() == null || calendar.getPrivateUrl().isEmpty()) {
            this.calendar_.setPrivateUrl(CalendarUtils.buildSubscribeUrl((String)calendar.getId(), (String)this.calType_, (boolean)true));
        }
        UIFormInputInfo privateUrl = new UIFormInputInfo(PRIVATE_URL, PRIVATE_URL, null);
        UIFormInputWithActions.ActionData privateAction = new UIFormInputWithActions.ActionData();
        privateAction.setActionListener(ACT_OPEN);
        privateAction.setActionParameter(this.calendar_.getPrivateUrl());
        privateAction.setActionName(ACT_OPEN);
        privateAction.setActionType(0);
        privateAction.setCssIconClass("uiIconCalICal uiIconLightGray");
        calendarDetail.addUIFormInput((UIFormInput)privateUrl);
        calendarDetail.setActionField(PRIVATE_URL, Arrays.asList(privateAction));
    }

    protected String getDisplayName() {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        return (String)calendarDetail.getUIStringInput(DISPLAY_NAME).getValue();
    }

    protected void setDisplayName(String value) {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        calendarDetail.getUIStringInput(DISPLAY_NAME).setValue((Object)value);
    }

    protected String getDescription() {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        return (String)calendarDetail.getUIFormTextAreaInput(DESCRIPTION).getValue();
    }

    protected void setDescription(String value) {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        calendarDetail.getUIFormTextAreaInput(DESCRIPTION).setValue((Object)value);
    }

    protected String getSelectedGroup() {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        if (calendarDetail.getUIFormSelectBox(CATEGORY) != null) {
            return (String)calendarDetail.getUIFormSelectBox(CATEGORY).getValue();
        }
        return null;
    }

    protected String getSelectedColor() {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        return (String)((UIFormColorPicker)calendarDetail.getChild(UIFormColorPicker.class)).getValue();
    }

    protected void setSelectedColor(String value) {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        ((UIFormColorPicker)calendarDetail.getChild(UIFormColorPicker.class)).setValue(value);
    }

    protected String getLocale() {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        return calendarDetail.getUIStringInput(LOCALE).getLabel();
    }

    public void setLocale(String value) {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        calendarDetail.getUIStringInput(LOCALE).setValue((Object)CalendarUtils.getLocationDisplayString((String)value));
        calendarDetail.getUIStringInput(LOCALE).setLabel(value);
    }

    protected String getTimeZone() {
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        return calendarDetail.getUIStringInput(TIMEZONE).getLabel();
    }

    public void setTimeZone(String value) {
        if (value == null) {
            return;
        }
        UIFormInputWithActions calendarDetail = (UIFormInputWithActions)this.getChildById(INPUT_CALENDAR);
        UIFormStringInput timeZone = calendarDetail.getUIStringInput(TIMEZONE);
        timeZone.setValue((Object)CalendarUtils.generateTimeZoneLabel((String)value));
        timeZone.setLabel(value);
    }

    public void updateSelect(String selectField, String value) throws Exception {
        UIGroupCalendarTab shareTab = (UIGroupCalendarTab)this.getChildById(INPUT_SHARE);
        if (selectField.equals(ADD_GROUP_INPUT)) {
            this.updateSelectGroup(selectField, value);
            return;
        }
        UIFormStringInput fieldInput = shareTab.getUIStringInput(selectField);
        StringBuilder sb = new StringBuilder();
        Map<String, String> temp = new HashMap<String, String>();
        String key = value.substring(0, selectField.lastIndexOf(PERMISSION_SUB));
        String tempS = value.substring(value.lastIndexOf(CalendarUtils.COLON_SLASH) + 2);
        if (this.perms_.get(selectField) == null) {
            temp.put(key, tempS);
        } else {
            temp = (Map)this.perms_.get(selectField);
            if (temp.get(key) != null && !tempS.equals(temp.get(key))) {
                tempS = (String)temp.get(key) + CalendarUtils.COMMA + tempS;
            }
            temp.put(key, tempS);
        }
        this.perms_.put(selectField, temp);
        HashMap<String, String> tempMap = new HashMap<String, String>();
        for (String s : temp.values()) {
            for (String t : s.split(CalendarUtils.COMMA)) {
                tempMap.put(t, t);
            }
        }
        for (String s : tempMap.values()) {
            if (sb != null && sb.length() > 0) {
                sb.append(CalendarUtils.COMMA + " ");
            }
            sb.append(s);
        }
        fieldInput.setValue((Object)sb.toString());
        this.setSelectedTab(shareTab.getId());
    }

    private void updateSelectGroup(String selectField, String groupId) {
        UIFormStringInput addGroupInput = (UIFormStringInput)((UIGroupCalendarTab)this.getChild(UIGroupCalendarTab.class)).getChildById(ADD_GROUP_INPUT);
        String selectGroupLbl = CalendarUtils.getResourceBundle((String)"UICalendarForm.label.AddGroupInput", (String)ADD_GROUP_INPUT_LABEL);
        if (addGroupInput.getValue() == null) {
            addGroupInput.setValue((Object)"");
        }
        if (((String)addGroupInput.getValue()).contains(groupId)) {
            return;
        }
        if (((String)addGroupInput.getValue()).equals(selectGroupLbl)) {
            addGroupInput.setValue((Object)groupId);
            return;
        }
        addGroupInput.setValue((Object)((String)addGroupInput.getValue() + CalendarUtils.COMMA + " " + groupId));
    }

    protected boolean isPublic() throws Exception {
        UIGroupCalendarTab groupTab = (UIGroupCalendarTab)this.getChildById(INPUT_SHARE);
        return groupTab.getDisplayedGroups().length > 0;
    }

    private Object[] getPublicGroups() throws Exception {
        OrganizationService organization = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        String currentUser = CalendarUtils.getCurrentUser();
        return organization.getGroupHandler().findGroupsOfUser(currentUser).toArray();
    }

    private List getSelectedGroups(String groupId) throws Exception {
        UIGroupCalendarTab groupTab = (UIGroupCalendarTab)this.getChildById(INPUT_SHARE);
        ArrayList<Group> groups = new ArrayList<Group>();
        Group g = ((OrganizationService)this.getApplicationComponent(OrganizationService.class)).getGroupHandler().findGroupById(groupId);
        UICheckBoxInput input = groupTab.getUICheckBoxInput(groupId);
        if (input != null && input.isChecked()) {
            groups.add(g);
        }
        return groups;
    }

    protected List<SelectItemOption<String>> getTimeZones() {
        return CalendarUtils.getTimeZoneSelectBoxOptions((String[])TimeZone.getAvailableIDs());
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            LOG.info((Object)("can not find label for " + this.getId() + ".label." + id));
            return id;
        }
    }

    protected List<SelectItemOption<String>> getLocales() {
        return CalendarUtils.getLocaleSelectBoxOptions((Locale[])java.util.Calendar.getAvailableLocales());
    }

    public static List<String> getPermissions(List<String> listPermission, String groupPermissions, OrganizationService orgService, String groupIdSelected, String groupKey, Event<?> event, StringBuffer notFoundUser) throws Exception {
        if (CalendarUtils.isEmpty((String)groupPermissions)) {
            return new ArrayList<String>(0);
        }
        for (String s : groupPermissions.split(CalendarUtils.COMMA)) {
            if (CalendarUtils.isEmpty((String)(s = s.trim()))) continue;
            if (s.equals(CalendarUtils.ANY)) {
                listPermission.add(groupKey + s);
                continue;
            }
            if (s.startsWith(CalendarUtils.ANY_OF)) {
                String membership = s.substring(CalendarUtils.ANY_OF.length());
                if (orgService.getMembershipTypeHandler().findMembershipType(membership) != null) {
                    listPermission.add(groupKey + s);
                    continue;
                }
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UICalendarForm.msg.name-not-on-group", new Object[]{s, groupKey}, 1));
                continue;
            }
            Collection memberships = orgService.getMembershipHandler().findMembershipsByUserAndGroup(s, groupIdSelected);
            if (memberships != null && !memberships.isEmpty()) {
                listPermission.add(groupKey + s);
                continue;
            }
            notFoundUser.append(s + ", ");
        }
        return listPermission;
    }

    static /* synthetic */ List access$000(UICalendarForm x0, String x1) throws Exception {
        return x0.getSelectedGroups(x1);
    }

    static /* synthetic */ Object[] access$100(UICalendarForm x0) throws Exception {
        return x0.getPublicGroups();
    }

    static /* synthetic */ boolean access$200(UICalendarForm x0) {
        return x0.isAddNew_;
    }

    static /* synthetic */ Log access$300() {
        return LOG;
    }
}

