/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.webui.popup.UICalendarSettingDisplayTab;
import org.exoplatform.calendar.webui.popup.UICalendarSettingFeedTab;
import org.exoplatform.calendar.webui.popup.UICalendarSettingForm;
import org.exoplatform.calendar.webui.popup.UICalendarSettingTab;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={ShowAllTimeZoneActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormTabPane.SelectTabActionListener.class}, phase=Event.Phase.DECODE)})
public class UICalendarSettingForm
extends UIFormTabPane
implements UIPopupComponent {
    private static final String SETTING_CALENDAR_TAB = "setting";
    private static final String DEFAULT_CALENDAR_TAB = "defaultCalendarTab";
    private static final String FEED_TAB = "feedTab";
    private Map<String, String> names_ = new HashMap();
    public String[] sharedCalendarColors_ = null;
    private CalendarSetting calendarSetting_ = null;

    public UICalendarSettingForm() throws Exception {
        super("UICalendarSettingForm");
        UICalendarSettingTab setting = new UICalendarSettingTab(SETTING_CALENDAR_TAB);
        this.addUIFormInput((UIFormInputSet)setting);
        this.setSelectedTab(setting.getId());
        UICalendarSettingDisplayTab defaultCalendarsTab = new UICalendarSettingDisplayTab(DEFAULT_CALENDAR_TAB);
        this.addUIFormInput((UIFormInputSet)defaultCalendarsTab);
        UICalendarSettingFeedTab uiFeedTab = new UICalendarSettingFeedTab(FEED_TAB);
        this.addUIFormInput((UIFormInputSet)uiFeedTab);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void init(CalendarSetting calendarSetting, CalendarService cservice) throws Exception {
        this.names_.clear();
        if (calendarSetting != null) {
            this.calendarSetting_ = calendarSetting;
            this.sharedCalendarColors_ = calendarSetting.getSharedCalendarsColors();
            UICalendarSettingTab settingTab = (UICalendarSettingTab)this.getChildById(SETTING_CALENDAR_TAB);
            settingTab.setViewType(calendarSetting.getViewType());
            settingTab.setWeekStartOn(calendarSetting.getWeekStartOn());
            settingTab.setDateFormat(calendarSetting.getDateFormat());
            settingTab.setTimeFormat(calendarSetting.getTimeFormat());
            settingTab.getUIFormSelectBox("beginTime").setOptions(CalendarUtils.getTimesSelectBoxOptions((String)calendarSetting.getTimeFormat(), (int)30));
            settingTab.getUIFormSelectBox("endTime").setOptions(CalendarUtils.getTimesSelectBoxOptions((String)calendarSetting.getTimeFormat(), (int)30));
            settingTab.setTimeZone(calendarSetting.getTimeZone());
            settingTab.setShowWorkingTimes(calendarSetting.isShowWorkingTime());
            if (calendarSetting.isShowWorkingTime()) {
                settingTab.setWorkingBegin(calendarSetting.getWorkingTimeBegin(), CalendarUtils.DATEFORMAT + " " + calendarSetting.getTimeFormat());
                settingTab.setWorkingEnd(calendarSetting.getWorkingTimeEnd(), CalendarUtils.DATEFORMAT + " " + calendarSetting.getTimeFormat());
            }
            settingTab.setSendOption(calendarSetting.getSendOption());
            if (calendarSetting.getBaseURL() == null) {
                calendarSetting.setBaseURL(CalendarUtils.getServerBaseUrl() + "calendar/iCalRss");
            }
        }
        this.initDisplayedCalendarTab(calendarSetting, cservice);
    }

    private void initDisplayedCalendarTab(CalendarSetting calendarSetting, CalendarService cservice) throws Exception {
        List otherCals;
        UICheckBoxInput checkBox;
        List publicCals;
        List sharedCals;
        List privateCals;
        String username = CalendarUtils.getCurrentUser();
        UICalendarSettingDisplayTab defaultCalendarsTab = (UICalendarSettingDisplayTab)this.getChildById(DEFAULT_CALENDAR_TAB);
        LinkedList filteredCalendars = new LinkedList();
        if (calendarSetting != null) {
            filteredCalendars.addAll(calendarSetting.getFilterCalendars());
        }
        if ((privateCals = defaultCalendarsTab.getAllPrivateCalendars()) != null && !privateCals.isEmpty()) {
            for (Calendar calendar : privateCals) {
                this.names_.put(calendar.getId(), calendar.getName());
                UICheckBoxInput checkBox2 = (UICheckBoxInput)defaultCalendarsTab.getChildById(calendar.getId());
                if (checkBox2 == null) {
                    checkBox2 = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(true));
                    defaultCalendarsTab.addUIFormInput((UIFormInput)checkBox2);
                }
                checkBox2.setChecked(true);
            }
        }
        if ((sharedCals = defaultCalendarsTab.getSharedCalendars()) != null && !sharedCals.isEmpty()) {
            for (Calendar calendar : sharedCals) {
                this.names_.put(calendar.getId(), calendar.getName());
                UICheckBoxInput checkBox3 = (UICheckBoxInput)defaultCalendarsTab.getChildById(calendar.getId());
                if (checkBox3 == null) {
                    checkBox3 = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(true));
                    defaultCalendarsTab.addUIFormInput((UIFormInput)checkBox3);
                }
                checkBox3.setChecked(true);
            }
        }
        if ((publicCals = defaultCalendarsTab.getAllPublicCalendars()) != null && !publicCals.isEmpty()) {
            for (Calendar calendar : publicCals) {
                String groupName = ((GroupCalendarData)cservice.getGroupCalendars(calendar.getGroups(), false, username).get(0)).getName();
                this.names_.put(calendar.getId(), CalendarUtils.getGroupCalendarName((String)groupName.substring(groupName.lastIndexOf("/") + 1), (String)calendar.getName()));
                checkBox = (UICheckBoxInput)defaultCalendarsTab.getChildById(calendar.getId());
                if (checkBox == null) {
                    checkBox = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(true));
                    defaultCalendarsTab.addUIFormInput((UIFormInput)checkBox);
                }
                checkBox.setChecked(true);
            }
        }
        if ((otherCals = defaultCalendarsTab.getAllOtherCalendars()) != null && !otherCals.isEmpty()) {
            for (Calendar calendar : otherCals) {
                this.names_.put(calendar.getId(), calendar.getName());
                checkBox = (UICheckBoxInput)defaultCalendarsTab.getChildById(calendar.getId());
                if (checkBox == null) {
                    checkBox = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(true));
                    defaultCalendarsTab.addUIFormInput((UIFormInput)checkBox);
                }
                checkBox.setChecked(true);
            }
        }
        for (String calId : filteredCalendars) {
            UICheckBoxInput input = (UICheckBoxInput)defaultCalendarsTab.getChildById(calId);
            if (input == null) continue;
            input.setChecked(false);
        }
    }

    public String getLabel(ResourceBundle res, String id) {
        if (this.names_.get(id) != null) {
            return (String)this.names_.get(id);
        }
        String label = this.getId() + ".label." + id;
        return res.getString(label);
    }

    public String getLabel(String id) {
        String label;
        try {
            label = super.getLabel(id);
        }
        catch (Exception e) {
            label = id;
        }
        return label;
    }

    protected List<String> getUnCheckedList(List<Calendar> calendars) {
        ArrayList<String> list = new ArrayList<String>();
        for (Calendar cal : calendars) {
            UICheckBoxInput input = (UICheckBoxInput)((UIFormInputWithActions)this.getChildById(DEFAULT_CALENDAR_TAB)).getChildById(cal.getId());
            if (input == null || input.isChecked()) continue;
            list.add(input.getId());
        }
        return list;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    static /* synthetic */ CalendarSetting access$000(UICalendarSettingForm x0) {
        return x0.calendarSetting_;
    }
}

