/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.webui.CalendarView;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarViewContainer;
import org.exoplatform.calendar.webui.UIFormDateTimePicker;
import org.exoplatform.calendar.webui.UIListContainer;
import org.exoplatform.calendar.webui.UIListView;
import org.exoplatform.calendar.webui.UIMiniCalendar;
import org.exoplatform.calendar.webui.popup.UIAttachFileForm;
import org.exoplatform.calendar.webui.popup.UIConfirmForm;
import org.exoplatform.calendar.webui.popup.UIEventAttenderTab;
import org.exoplatform.calendar.webui.popup.UIEventDetailTab;
import org.exoplatform.calendar.webui.popup.UIEventForm;
import org.exoplatform.calendar.webui.popup.UIEventReminderTab;
import org.exoplatform.calendar.webui.popup.UIEventShareTab;
import org.exoplatform.calendar.webui.popup.UIPopupAction;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UIPopupContainer;
import org.exoplatform.calendar.webui.popup.UIRepeatEventForm;
import org.exoplatform.calendar.webui.popup.UISelector;
import org.exoplatform.calendar.webui.popup.UITaskForm;
import org.exoplatform.commons.utils.DateUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.Attachment;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.mail.impl.MailServiceImpl;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserStatus;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.core.model.SelectOption;
import org.exoplatform.webui.core.model.SelectOptionGroup;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;
import org.exoplatform.webui.form.UIFormTabPane;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.ext.UIFormComboBox;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIFormTabPane.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={AddCategoryActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveEmailActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={MoveNextActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={MovePreviousActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeleteUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DownloadAttachmentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddParticipantActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={OnChangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormTabPane.SelectTabActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ConfirmCloseActionListener.class}), @EventConfig(listeners={AbortCloseActionListener.class}), @EventConfig(listeners={ConfirmUpdateOnlyInstance.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ConfirmUpdateFollowSeries.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ConfirmUpdateAllSeries.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ConfirmUpdateCancel.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={EditRepeatActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(id="UIPopupWindowAddUserEventForm", type=UIPopupWindow.class, template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={UIPopupWindow.CloseActionListener.class}, name="ClosePopup"), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE), @EventConfig(listeners={UITaskForm.CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE)})})
public class UIEventForm
extends UIFormTabPane
implements UIPopupComponent,
UISelector {
    private static final Log LOG = ExoLogger.getExoLogger(UIEventForm.class);
    public static final String TAB_EVENTDETAIL = "eventDetail".intern();
    public static final String TAB_EVENTREMINDER = "eventReminder".intern();
    public static final String TAB_EVENTSHARE = "eventShare".intern();
    public static final String TAB_EVENTATTENDER = "eventAttender".intern();
    public static final String FIELD_MEETING = "participant".intern();
    public static final String FIELD_ISSENDMAIL = "isSendMail".intern();
    public static final String ITEM_PUBLIC = "public".intern();
    public static final String ITEM_PRIVATE = "private".intern();
    public static final String ITEM_AVAILABLE = "available".intern();
    public static final String ITEM_BUSY = "busy".intern();
    public static final String ITEM_OUTSIDE = "outside".intern();
    public static final String ITEM_REPEAT = "true".intern();
    public static final String ITEM_UNREPEAT = "false".intern();
    public static final String ITEM_ALWAYS = "always".intern();
    public static final String ITEM_NERVER = "never".intern();
    public static final String ITEM_ASK = "ask".intern();
    public static final String ACT_REMOVE = "RemoveAttachment".intern();
    public static final String ACT_DOWNLOAD = "DownloadAttachment".intern();
    public static final String ACT_ADDEMAIL = "AddEmailAddress".intern();
    public static final String ACT_ADDCATEGORY = "AddCategory".intern();
    public static final String ACT_EDITREPEAT = "EditRepeat".intern();
    public static final String STATUS_EMPTY = "".intern();
    public static final String STATUS_MAYBE = "maybe".intern();
    public static final String STATUS_YES = "yes".intern();
    public static final String STATUS_NO = "no".intern();
    public static final String RP_END_BYDATE = "endByDate";
    public static final String RP_END_AFTER = "endAfter";
    public static final String RP_END_NEVER = "neverEnd";
    private static final String EXO_EMAIL_SMTP_FROM = System.getProperty("exo.email.smtp.from");
    public boolean isAddNew_ = true;
    private boolean isChangedSignificantly = false;
    private CalendarEvent calendarEvent_ = null;
    protected String calType_ = "0";
    protected String invitationMsg_ = "";
    protected String participantList_ = "";
    private String errorMsg_ = null;
    private String errorValues = null;
    protected Map<String, String> participants_ = new LinkedHashMap();
    protected Map<String, String> participantStatus_ = new LinkedHashMap();
    protected LinkedList<ParticipantStatus> participantStatusList_ = new LinkedList();
    private String oldCalendarId_ = null;
    private String newCalendarId_ = null;
    private String saveEventSendMailUpdate = "";
    private CalendarEvent repeatEvent;
    private String repeatSummary;
    private static final String SAVE_SERIES_ONLY = "only_this_event";
    private static final String SAVE_SERIES_FOLLOWING = "following_event";
    private static final String SAVE_SERIES_ALL = "all_event";
    private String saveSeries = null;
    private static final String SEND_MAIL_YES = "yes";
    private static final String SEND_MAIL_NO = "no";
    private String sendMail = null;
    public static final int LIMIT_FILE_UPLOAD = 10;

    public UIEventForm() throws Exception {
        super("UIEventForm");
        this.setId("UIEventForm");
        this.saveEventSendMailUpdate = this.getLabel("SaveEvent-SendMailUpdate");
        UIEventDetailTab eventDetailTab = new UIEventDetailTab(TAB_EVENTDETAIL);
        this.addChild((UIComponent)eventDetailTab);
        UIEventReminderTab eventReminderTab = new UIEventReminderTab(TAB_EVENTREMINDER);
        this.addChild((UIComponent)eventReminderTab);
        UIEventShareTab eventShareTab = new UIEventShareTab(TAB_EVENTSHARE);
        eventShareTab.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(UIEventShareTab.FIELD_SHARE, UIEventShareTab.FIELD_SHARE, this.getShareValue()));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(UIEventShareTab.FIELD_STATUS, UIEventShareTab.FIELD_STATUS, this.getStatusValue()));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(UIEventShareTab.FIELD_SEND, UIEventShareTab.FIELD_SEND, CalendarUtils.getSendValue(null)));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormInputInfo(UIEventShareTab.FIELD_INFO, UIEventShareTab.FIELD_INFO, null));
        eventShareTab.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_MEETING, FIELD_MEETING, null));
        ArrayList<UIFormInputWithActions.ActionData> actions = new ArrayList<UIFormInputWithActions.ActionData>();
        UIFormInputWithActions.ActionData addUser = new UIFormInputWithActions.ActionData();
        addUser.setActionListener("AddParticipant");
        addUser.setActionName("AddUser");
        addUser.setActionParameter(TAB_EVENTSHARE);
        addUser.setActionType(0);
        addUser.setCssIconClass("uiIconPlus uiIconLightGray");
        actions.add(addUser);
        eventShareTab.setActionField(UIEventShareTab.FIELD_INFO, actions);
        this.addChild((UIComponent)eventShareTab);
        UIEventAttenderTab eventAttenderTab = new UIEventAttenderTab(TAB_EVENTATTENDER);
        this.addChild((UIComponent)eventAttenderTab);
        this.setSelectedTab(eventDetailTab.getId());
    }

    public String getLabel(String id) {
        try {
            return super.getLabel(id);
        }
        catch (Exception e) {
            LOG.warn((Object)("Can not find " + this.getId() + ".label." + id));
            return id;
        }
    }

    public void initForm(CalendarSetting calSetting, CalendarEvent eventCalendar, String formTime) throws Exception {
        this.reset();
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        ((UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM)).setDateFormatStyle(calSetting.getDateFormat());
        ((UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO)).setDateFormatStyle(calSetting.getDateFormat());
        UIEventAttenderTab attenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        List fromTimes = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat(), (long)calSetting.getTimeInterval());
        List toTimes = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat(), (long)calSetting.getTimeInterval());
        eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_FROM_TIME).setOptions(fromTimes);
        eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_TO_TIME).setOptions(toTimes);
        List fromOptions = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat());
        List toOptions = CalendarUtils.getTimesSelectBoxOptions((String)calSetting.getTimeFormat(), (String)calSetting.getTimeFormat());
        attenderTab.getUIFormComboBox(UIEventAttenderTab.FIELD_FROM_TIME).setOptions(fromOptions);
        attenderTab.getUIFormComboBox(UIEventAttenderTab.FIELD_TO_TIME).setOptions(toOptions);
        if (eventCalendar != null) {
            this.isAddNew_ = false;
            this.calendarEvent_ = eventCalendar;
            this.repeatEvent = new CalendarEvent(this.calendarEvent_);
            this.setEventSumary(eventCalendar.getSummary());
            this.setEventDescription(eventCalendar.getDescription());
            this.setEventAllDate(CalendarUtils.isAllDayEvent((CalendarEvent)eventCalendar));
            this.setEventFromDate(eventCalendar.getFromDateTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setEventCheckTime(eventCalendar.getFromDateTime());
            this.setEventToDate(eventCalendar.getToDateTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setSelectedCalendarId(eventCalendar.getCalendarId());
            String eventCategoryId = eventCalendar.getEventCategoryId();
            if (!CalendarUtils.isEmpty((String)eventCategoryId)) {
                UIFormSelectBox selectBox = eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY);
                boolean hasEventCategory = false;
                for (SelectItemOption o : selectBox.getOptions()) {
                    if (!((String)o.getValue()).equals(eventCategoryId)) continue;
                    hasEventCategory = true;
                    break;
                }
                if (!hasEventCategory) {
                    selectBox.getOptions().add(new SelectItemOption(eventCalendar.getEventCategoryName(), (Object)eventCategoryId));
                }
                this.setSelectedCategory(eventCategoryId);
            }
            this.setEventPlace(eventCalendar.getLocation());
            this.setEventIsRepeat(eventCalendar.getRepeatType() != null && !CalendarEvent.RP_NOREPEAT.equals(eventCalendar.getRepeatType()));
            this.setRepeatSummary(this.buildRepeatSummary(this.calendarEvent_));
            if ((CalendarEvent.RP_NOREPEAT.equals(this.calendarEvent_.getRepeatType()) || this.calendarEvent_.getRepeatType() == null) && !CalendarUtils.isEmpty((String)this.calendarEvent_.getRecurrenceId()) && this.calendarEvent_.getIsExceptionOccurrence().booleanValue()) {
                ((UIEventDetailTab)this.getChild(UIEventDetailTab.class)).getUICheckBoxInput(UIEventDetailTab.FIELD_ISREPEAT).setDisabled(true);
            }
            this.setSelectedEventPriority(eventCalendar.getPriority());
            if (eventCalendar.getReminders() != null) {
                this.setEventReminders(eventCalendar.getReminders());
            }
            this.setAttachments(eventCalendar.getAttachment());
            if (eventCalendar.isPrivate()) {
                this.setSelectedShareType(ITEM_PRIVATE);
            } else {
                this.setSelectedShareType(ITEM_PUBLIC);
            }
            this.setSendOption(eventCalendar.getSendOption());
            this.setMessage(eventCalendar.getMessage());
            this.setParticipantStatusValues(eventCalendar.getParticipantStatus());
            ((UIEventShareTab)this.getChild(UIEventShareTab.class)).setParticipantStatusList((List)this.participantStatusList_);
            this.setSelectedEventState(eventCalendar.getEventState());
            this.setMeetingInvitation(eventCalendar.getInvitation());
            StringBuffer pars = new StringBuffer();
            if (eventCalendar.getParticipant() != null) {
                for (String par : eventCalendar.getParticipant()) {
                    if (!CalendarUtils.isEmpty((String)pars.toString())) {
                        pars.append(CalendarUtils.BREAK_LINE);
                    }
                    pars.append(par);
                }
            }
            this.setParticipant(pars.toString());
            if (eventCategoryId != null) {
                UIFormSelectBox uiSelectBox = eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY);
                if (!this.isAddNew_ && !String.valueOf(0).equalsIgnoreCase(this.calType_)) {
                    SelectItemOption item = new SelectItemOption(eventCalendar.getEventCategoryName(), (Object)eventCalendar.getEventCategoryId());
                    uiSelectBox.getOptions().add(item);
                    uiSelectBox.setValue(eventCalendar.getEventCategoryId());
                    uiSelectBox.setDisabled(false);
                    eventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).setDisabled(false);
                    eventDetailTab.setActionField(UIEventDetailTab.FIELD_CATEGORY, null);
                }
            }
            attenderTab.calendar_.setTime(eventCalendar.getFromDateTime());
        } else {
            java.util.Calendar cal = UIEventForm.getCalendar((UIForm)this, (String)formTime, (CalendarSetting)calSetting);
            this.setEventFromDate(cal.getTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            cal.add(12, (int)calSetting.getTimeInterval() * 2);
            this.setEventCheckTime(cal.getTime());
            this.setEventToDate(cal.getTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            StringBuffer pars = new StringBuffer(CalendarUtils.getCurrentUser());
            this.setMeetingInvitation(new String[]{CalendarUtils.getOrganizationService().getUserHandler().findUserByName(pars.toString()).getEmail()});
            this.setParticipant(pars.toString());
            this.setSendOption(calSetting.getSendOption());
            ((UIEventShareTab)this.getChild(UIEventShareTab.class)).setParticipantStatusList((List)this.participantStatusList_);
            attenderTab.updateParticipants(pars.toString());
            this.setRepeatSummary(this.buildRepeatSummary(null));
        }
    }

    public boolean isReminderByEmail(List<Reminder> reminders) {
        Iterator<Reminder> iterator = reminders.iterator();
        if (iterator.hasNext()) {
            Reminder rm = iterator.next();
            return Reminder.TYPE_EMAIL.equals(rm.getReminderType());
        }
        return false;
    }

    public static java.util.Calendar getCalendar(UIForm uiForm, String formTime, CalendarSetting calSetting) {
        java.util.Calendar cal = CalendarUtils.getInstanceOfCurrentCalendar();
        try {
            cal.setTimeInMillis(Long.parseLong(formTime));
        }
        catch (NumberFormatException e) {
            UIMiniCalendar miniCalendar = (UIMiniCalendar)((UICalendarPortlet)uiForm.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UIMiniCalendar.class);
            cal.setTime(miniCalendar.getCurrentCalendar().getTime());
        }
        Long beginMinute = (long)cal.get(12) / calSetting.getTimeInterval() * calSetting.getTimeInterval();
        cal.set(12, beginMinute.intValue());
        return cal;
    }

    private void setEventCheckTime(Date time) {
        UIEventAttenderTab uiAttenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        uiAttenderTab.calendar_.setTime(time);
    }

    private boolean setCalendarOptionOfSpaceAsSelected(String spaceId, List<? extends SelectItem> items, UIFormSelectBoxWithGroups selectBoxWithGroups) {
        if (spaceId == null || items == null) {
            return false;
        }
        for (SelectItem selectItem : items) {
            if (selectItem instanceof SelectOption) {
                SelectOption so = (SelectOption)selectItem;
                if (!so.getValue().endsWith(spaceId)) continue;
                selectBoxWithGroups.setValue(so.getValue());
                return true;
            }
            if (!(selectItem instanceof SelectOptionGroup) || !this.setCalendarOptionOfSpaceAsSelected(spaceId, ((SelectOptionGroup)selectItem).getOptions(), selectBoxWithGroups)) continue;
            return true;
        }
        return false;
    }

    public void update(String calType, List<SelectItem> options) throws Exception {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormSelectBoxWithGroups selectBoxWithGroups = uiEventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR);
        if (options != null) {
            selectBoxWithGroups.setOptions(options);
        } else {
            selectBoxWithGroups.setOptions(this.getCalendars());
        }
        UICalendarPortlet uiCalendarPortlet = (UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class);
        if (uiCalendarPortlet != null && !uiCalendarPortlet.getSpaceGroupId().equals("")) {
            this.setCalendarOptionOfSpaceAsSelected(uiCalendarPortlet.getSpaceGroupId(), selectBoxWithGroups.getOptions(), selectBoxWithGroups);
        }
        this.calType_ = calType;
    }

    private List<SelectItem> getCalendars() throws Exception {
        return CalendarUtils.getCalendarOption();
    }

    protected void refreshCategory() throws Exception {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).setOptions(CalendarUtils.getCategory());
    }

    private List<SelectItemOption<String>> getShareValue() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(ITEM_PRIVATE, (Object)ITEM_PRIVATE));
        options.add(new SelectItemOption(ITEM_PUBLIC, (Object)ITEM_PUBLIC));
        return options;
    }

    private List<SelectItemOption<String>> getStatusValue() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(ITEM_BUSY, (Object)ITEM_BUSY));
        options.add(new SelectItemOption(ITEM_AVAILABLE, (Object)ITEM_AVAILABLE));
        options.add(new SelectItemOption(ITEM_OUTSIDE, (Object)ITEM_OUTSIDE));
        return options;
    }

    public String[] getActions() {
        return new String[]{"Save", "Cancel"};
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void updateSelect(String selectField, String value) throws Exception {
    }

    private boolean isReminderValid() throws Exception {
        if (this.getEmailReminder()) {
            if (CalendarUtils.isEmpty((String)this.getEmailAddress())) {
                this.errorMsg_ = "UIEventForm.msg.event-email-required";
                this.errorValues = "";
                return false;
            }
            if (!CalendarUtils.isValidEmailAddresses((String)this.getEmailAddress())) {
                this.errorMsg_ = "UIEventForm.msg.event-email-invalid";
                this.errorValues = CalendarUtils.invalidEmailAddresses((String)this.getEmailAddress());
                return false;
            }
        }
        this.errorMsg_ = null;
        return true;
    }

    protected boolean isEventDetailValid(CalendarSetting calendarSetting) throws Exception {
        String dateFormat = calendarSetting.getDateFormat();
        String timeFormat = calendarSetting.getTimeFormat();
        Date from = null;
        Date to = null;
        if (CalendarUtils.isEmpty((String)this.getCalendarId())) {
            this.errorMsg_ = this.getId() + ".msg.event-calendar-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventCategory())) {
            this.errorMsg_ = this.getId() + ".msg.event-category-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventFormDateValue())) {
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-required";
            return false;
        }
        if (CalendarUtils.isEmpty((String)this.getEventToDateValue())) {
            this.errorMsg_ = this.getId() + ".msg.event-todate-required";
            return false;
        }
        try {
            from = this.getEventFromDate(dateFormat, timeFormat);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Faile to get event from date", (Throwable)e);
            }
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-notvalid";
            return false;
        }
        if (from == null) {
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-notvalid";
            return false;
        }
        try {
            to = this.getEventToDate(dateFormat, timeFormat);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Fail to get event to date", (Throwable)e);
            }
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-notvalid";
            return false;
        }
        if (to == null) {
            this.errorMsg_ = this.getId() + ".msg.event-fromdate-notvalid";
            return false;
        }
        if (from.after(to) || from.equals(to)) {
            this.errorMsg_ = "UIEventForm.msg.event-date-time-logic";
            return false;
        }
        this.errorMsg_ = null;
        return true;
    }

    private boolean isParticipantValid() throws Exception {
        if (this.isSendMail() && this.getMeetingInvitation() == null) {
            this.errorMsg_ = "UIEventForm.msg.error-particimant-email-required";
            return false;
        }
        this.errorMsg_ = null;
        return true;
    }

    protected String getEventSumary() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_EVENT).getValue();
    }

    protected void setEventSumary(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_EVENT).setValue((Object)value);
    }

    protected String getEventDescription() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormTextAreaInput(UIEventDetailTab.FIELD_DESCRIPTION).getValue();
    }

    protected void setEventDescription(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormTextAreaInput(UIEventDetailTab.FIELD_DESCRIPTION).setValue((Object)value);
    }

    protected String getCalendarId() {
        String value;
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        this.newCalendarId_ = value = (String)eventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).getValue();
        if (!CalendarUtils.isEmpty((String)value) && value.split(CalendarUtils.COLON).length > 0) {
            this.calType_ = value.split(CalendarUtils.COLON)[0];
            return value.split(CalendarUtils.COLON)[1];
        }
        return value;
    }

    public void setSelectedCalendarId(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        String selectedCal = new StringBuffer(this.calType_).append(CalendarUtils.COLON).append(value).toString();
        eventDetailTab.getUIFormSelectBoxGroup(UIEventDetailTab.FIELD_CALENDAR).setValue(selectedCal);
        this.oldCalendarId_ = selectedCal;
    }

    protected String getEventCategory() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).getValue();
    }

    public void setSelectedCategory(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY).setValue(value);
    }

    protected Date getEventFromDate(String dateFormat, String timeFormat) throws Exception {
        try {
            UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
            UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
            UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_FROM_TIME);
            return UITaskForm.getBeginDate((boolean)this.getEventAllDate(), (String)dateFormat, (String)((String)fromField.getValue()), (String)timeFormat, (String)((String)timeField.getValue()));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected Date getEventFromDate() throws Exception {
        try {
            UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
            UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
            UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_FROM_TIME);
            CalendarSetting calendarSetting = CalendarUtils.getCurrentUserCalendarSetting();
            return UITaskForm.getBeginDate((boolean)this.getEventAllDate(), (String)calendarSetting.getDateFormat(), (String)((String)fromField.getValue()), (String)calendarSetting.getTimeFormat(), (String)((String)timeField.getValue()));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getEventFormDateValue() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
        return (String)fromField.getValue();
    }

    protected void setEventFromDate(Date date, String dateFormat, String timeFormat) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIEventAttenderTab eventAttenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        UIFormDateTimePicker fromField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM);
        UIFormComboBox timeField = (UIFormComboBox)eventDetailTab.getChildById(UIEventDetailTab.FIELD_FROM_TIME);
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        fromField.setValue((Object)df.format(date));
        df = new SimpleDateFormat(timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        timeField.setValue((Object)df.format(date));
        eventAttenderTab.setEventFromDate(date, timeFormat);
    }

    protected Date getEventToDate(String dateFormat, String timeFormat) throws Exception {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_TO_TIME);
        return UITaskForm.getToDate((boolean)this.getEventAllDate(), (String)dateFormat, (String)((String)toField.getValue()), (String)timeFormat, (String)((String)timeField.getValue()));
    }

    protected Date getEventToDate() throws Exception {
        CalendarSetting calendarSetting = CalendarUtils.getCurrentUserCalendarSetting();
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        UIFormComboBox timeField = eventDetailTab.getUIFormComboBox(UIEventDetailTab.FIELD_TO_TIME);
        return UITaskForm.getToDate((boolean)this.getEventAllDate(), (String)calendarSetting.getDateFormat(), (String)((String)toField.getValue()), (String)calendarSetting.getTimeFormat(), (String)((String)timeField.getValue()));
    }

    protected void setEventToDate(Date date, String dateFormat, String timeFormat) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIEventAttenderTab eventAttenderTab = (UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        UIFormComboBox timeField = (UIFormComboBox)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO_TIME);
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        toField.setValue((Object)df.format(date));
        df = new SimpleDateFormat(timeFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        timeField.setValue((Object)df.format(date));
        eventAttenderTab.setEventToDate(date, timeFormat);
    }

    protected String getEventToDateValue() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker toField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_TO);
        return (String)toField.getValue();
    }

    protected boolean getEventAllDate() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return eventDetailTab.getUICheckBoxInput(UIEventDetailTab.FIELD_CHECKALL).isChecked();
    }

    protected void setEventAllDate(boolean isCheckAll) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUICheckBoxInput(UIEventDetailTab.FIELD_CHECKALL).setChecked(isCheckAll);
    }

    protected String getEventRepeat() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_REPEAT).getValue();
    }

    protected void setEventRepeat(String type) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_REPEAT).setValue(type);
    }

    protected boolean getEventIsRepeat() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return eventDetailTab.getUICheckBoxInput(UIEventDetailTab.FIELD_ISREPEAT).isChecked();
    }

    protected void setEventIsRepeat(boolean isRepeat) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUICheckBoxInput(UIEventDetailTab.FIELD_ISREPEAT).setChecked(isRepeat);
    }

    protected String getEventRepeatUntilValue() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        UIFormDateTimePicker untilField = (UIFormDateTimePicker)eventDetailTab.getChildById(UIEventDetailTab.FIELD_REPEAT_UNTIL);
        return (String)untilField.getValue();
    }

    protected String getEventPlace() {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_PLACE).getValue();
    }

    protected void setEventPlace(String value) {
        UIEventDetailTab eventDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIStringInput(UIEventDetailTab.FIELD_PLACE).setValue((Object)value);
    }

    protected boolean getEmailReminder() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return eventReminderTab.getUICheckBoxInput(UIEventReminderTab.REMIND_BY_EMAIL).isChecked();
    }

    public void setEmailReminder(boolean isChecked) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUICheckBoxInput(UIEventReminderTab.REMIND_BY_EMAIL).setChecked(isChecked);
    }

    protected String getEmailRemindBefore() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REMIND_BEFORE).getValue();
    }

    protected boolean isEmailRepeat() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return Boolean.parseBoolean(((Boolean)eventReminderTab.getUICheckBoxInput(UIEventReminderTab.EMAIL_IS_REPEAT).getValue()).toString());
    }

    public void setEmailRepeat(Boolean value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUICheckBoxInput(UIEventReminderTab.EMAIL_IS_REPEAT).setChecked(value.booleanValue());
    }

    protected String getEmailRepeatInterVal() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REPEAT_INTERVAL).getValue();
    }

    protected void setEmailRepeatInterVal(long value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REPEAT_INTERVAL).setValue(String.valueOf(value));
    }

    protected Boolean isPopupRepeat() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return Boolean.parseBoolean(((Boolean)eventReminderTab.getUICheckBoxInput(UIEventReminderTab.POPUP_IS_REPEAT).getValue()).toString());
    }

    protected void setPopupRepeat(Boolean value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUICheckBoxInput(UIEventReminderTab.POPUP_IS_REPEAT).setChecked(value.booleanValue());
    }

    protected String getPopupRepeatInterVal() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).getValue();
    }

    public void setEmailRemindBefore(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.EMAIL_REMIND_BEFORE).setValue(value);
    }

    protected String getEmailAddress() throws Exception {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIStringInput(UIEventReminderTab.FIELD_EMAIL_ADDRESS).getValue();
    }

    public void setEmailAddress(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIStringInput(UIEventReminderTab.FIELD_EMAIL_ADDRESS).setValue((Object)value);
    }

    protected boolean getPopupReminder() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return eventReminderTab.getUICheckBoxInput(UIEventReminderTab.REMIND_BY_POPUP).isChecked();
    }

    protected void setPopupReminder(boolean isChecked) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUICheckBoxInput(UIEventReminderTab.REMIND_BY_POPUP).setChecked(isChecked);
    }

    protected String getPopupReminderTime() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        return (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REMIND_BEFORE).getValue();
    }

    protected void setPopupRemindBefore(String value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REMIND_BEFORE).setValue(value);
    }

    protected long getPopupReminderSnooze() {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        try {
            String time = (String)eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).getValue();
            return Long.parseLong(time);
        }
        catch (NumberFormatException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Can't get time from POPUP_REPEAT_INTERVAL", (Throwable)e);
            }
            return 0L;
        }
    }

    protected List<org.exoplatform.calendar.service.Attachment> getAttachments(String eventId, boolean isAddNew) {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        return uiEventDetailTab.getAttachments();
    }

    protected long getTotalAttachment() {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        long attSize = 0L;
        for (org.exoplatform.calendar.service.Attachment att : uiEventDetailTab.getAttachments()) {
            attSize += att.getSize();
        }
        return attSize;
    }

    protected void setAttachments(List<org.exoplatform.calendar.service.Attachment> attachment) throws Exception {
        UIEventDetailTab uiEventDetailTab = (UIEventDetailTab)this.getChild(UIEventDetailTab.class);
        uiEventDetailTab.setAttachments(attachment);
        uiEventDetailTab.refreshUploadFileList();
    }

    protected void setPopupRepeatInterval(long value) {
        UIEventReminderTab eventReminderTab = (UIEventReminderTab)this.getChildById(TAB_EVENTREMINDER);
        eventReminderTab.getUIFormSelectBox(UIEventReminderTab.POPUP_REPEAT_INTERVAL).setValue(String.valueOf(value));
    }

    protected void setEventReminders(List<Reminder> reminders) {
        for (Reminder rm : reminders) {
            if (Reminder.TYPE_EMAIL.equals(rm.getReminderType())) {
                this.setEmailReminder(true);
                this.setEmailAddress(rm.getEmailAddress());
                this.setEmailRepeat(Boolean.valueOf(rm.isRepeat()));
                this.setEmailRemindBefore(String.valueOf(rm.getAlarmBefore()));
                this.setEmailRepeatInterVal(rm.getRepeatInterval());
                continue;
            }
            if (!Reminder.TYPE_POPUP.equals(rm.getReminderType())) continue;
            this.setPopupReminder(true);
            this.setPopupRepeat(Boolean.valueOf(rm.isRepeat()));
            this.setPopupRemindBefore(String.valueOf(rm.getAlarmBefore()));
            this.setPopupRepeatInterval(rm.getRepeatInterval());
        }
    }

    protected List<Reminder> getEventReminders(Date fromDateTime, List<Reminder> currentReminders) throws Exception {
        ArrayList<Reminder> reminders = new ArrayList<Reminder>();
        if (this.getEmailReminder()) {
            Reminder email = new Reminder();
            if (currentReminders != null) {
                for (Reminder rm : currentReminders) {
                    if (!rm.getReminderType().equals(Reminder.TYPE_EMAIL)) continue;
                    email = rm;
                    break;
                }
            }
            email.setReminderType(Reminder.TYPE_EMAIL);
            email.setReminderOwner(CalendarUtils.getCurrentUser());
            email.setAlarmBefore(Long.parseLong(this.getEmailRemindBefore()));
            StringBuffer sbAddress = new StringBuffer();
            for (String s : this.getEmailAddress().replaceAll(CalendarUtils.SEMICOLON, CalendarUtils.COMMA).split(CalendarUtils.COMMA)) {
                if (sbAddress.indexOf(s = s.trim()) >= 0) continue;
                if (sbAddress.length() > 0) {
                    sbAddress.append(CalendarUtils.COMMA);
                }
                sbAddress.append(s);
            }
            email.setEmailAddress(sbAddress.toString());
            email.setRepeate(this.isEmailRepeat());
            email.setRepeatInterval(Long.parseLong(this.getEmailRepeatInterVal()));
            email.setFromDateTime(fromDateTime);
            if (!CalendarUtils.isEmpty((String)email.getEmailAddress())) {
                reminders.add(email);
            }
        }
        if (this.getPopupReminder()) {
            Reminder popup = new Reminder();
            if (currentReminders != null) {
                for (Reminder rm : currentReminders) {
                    if (!rm.getReminderType().equals(Reminder.TYPE_POPUP)) continue;
                    popup = rm;
                    break;
                }
            }
            StringBuffer sb = new StringBuffer();
            boolean isExist = false;
            if (!isExist) {
                if (sb.length() > 0) {
                    sb.append(CalendarUtils.COMMA);
                }
                sb.append(CalendarUtils.getCurrentUser());
            }
            popup.setReminderOwner(sb.toString());
            popup.setReminderType(Reminder.TYPE_POPUP);
            popup.setAlarmBefore(Long.parseLong(this.getPopupReminderTime()));
            popup.setRepeate(this.isPopupRepeat().booleanValue());
            popup.setRepeatInterval(Long.parseLong(this.getPopupRepeatInterVal()));
            popup.setFromDateTime(fromDateTime);
            reminders.add(popup);
        }
        return reminders;
    }

    protected String getEventPriority() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        return (String)eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_PRIORITY).getValue();
    }

    protected void setSelectedEventPriority(String value) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTDETAIL);
        eventDetailTab.getUIFormSelectBox(UIEventDetailTab.FIELD_PRIORITY).setValue(value);
    }

    protected String getEventState() {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        return (String)eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_STATUS).getValue();
    }

    public void setSelectedEventState(String value) {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_STATUS).setValue((Object)value);
    }

    protected String getShareType() {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        return (String)eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_SHARE).getValue();
    }

    protected String getSendOption() {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        return (String)eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_SEND).getValue();
    }

    protected void setSendOption(String value) {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_SEND).setValue((Object)value);
    }

    public String getMessage() {
        return this.invitationMsg_;
    }

    public void setMessage(String invitationMsg) {
        this.invitationMsg_ = invitationMsg;
    }

    protected void setSelectedShareType(String value) {
        UIEventShareTab eventDetailTab = (UIEventShareTab)this.getChildById(TAB_EVENTSHARE);
        eventDetailTab.getUIFormRadioBoxInput(UIEventShareTab.FIELD_SHARE).setValue((Object)value);
    }

    protected String[] getMeetingInvitation() {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        String invitation = (String)eventDetailTab.getUIFormTextAreaInput(FIELD_MEETING).getValue();
        if (CalendarUtils.isEmpty((String)invitation)) {
            return null;
        }
        return invitation.replace(CalendarUtils.SEMICOLON, CalendarUtils.COMMA).split(CalendarUtils.COMMA);
    }

    protected String getInvitationEmail() {
        StringBuilder buider = new StringBuilder("");
        for (Map.Entry par : this.participantStatus_.entrySet()) {
            if (buider.length() > 0 && ((String)par.getKey()).contains("@")) {
                buider.append(CalendarUtils.COMMA);
            }
            if (!((String)par.getKey()).contains("@")) continue;
            buider.append(((String)par.getKey()).substring(((String)par.getKey()).lastIndexOf(CalendarUtils.OPEN_PARENTHESIS) + 1).replace(CalendarUtils.CLOSE_PARENTHESIS, ""));
        }
        return buider.toString();
    }

    protected void setMeetingInvitation(String[] values) {
        UIFormInputWithActions eventDetailTab = (UIFormInputWithActions)this.getChildById(TAB_EVENTSHARE);
        StringBuffer sb = new StringBuffer();
        if (values != null) {
            for (String s : values) {
                if (sb.length() > 0) {
                    sb.append(CalendarUtils.COMMA);
                }
                sb.append(s);
            }
        }
        eventDetailTab.getUIFormTextAreaInput(FIELD_MEETING).setValue((Object)sb.toString());
    }

    protected String getParticipantValues() {
        StringBuilder buider = new StringBuilder("");
        for (String par : this.participants_.keySet()) {
            if (buider.length() > 0) {
                buider.append(CalendarUtils.BREAK_LINE);
            }
            buider.append(par);
        }
        return buider.toString();
    }

    protected String getParticipantStatusValues() {
        StringBuilder buider = new StringBuilder("");
        for (Map.Entry par : this.participantStatus_.entrySet()) {
            if (buider.length() > 0) {
                buider.append(CalendarUtils.BREAK_LINE);
            }
            buider.append((String)par.getKey() + ":" + (String)par.getValue());
        }
        return buider.toString();
    }

    protected void setParticipantStatusValues(String[] values) throws Exception {
        this.participantStatus_.clear();
        this.participantStatusList_.clear();
        for (String par : values) {
            String[] entry = par.split(":");
            if (entry.length <= 0 || !StringUtils.isNotBlank((String)entry[0])) continue;
            if (entry.length > 1) {
                this.participantStatus_.put(entry[0], entry[1]);
                this.participantStatusList_.add(new ParticipantStatus(this, entry[0], entry[1]));
                continue;
            }
            if (entry.length != 1) continue;
            this.participantStatus_.put(entry[0], STATUS_EMPTY);
            this.participantStatusList_.add(new ParticipantStatus(this, entry[0], STATUS_EMPTY));
        }
    }

    public void setParticipant(String values) throws Exception {
        OrganizationService orgService = CalendarUtils.getOrganizationService();
        for (String s : values.split("[\\r\\n]+")) {
            User user = orgService.getUserHandler().findUserByName(s, UserStatus.ANY);
            if (user == null) continue;
            this.participants_.put(s.trim(), user.getEmail());
        }
        ((UIEventAttenderTab)this.getChildById(TAB_EVENTATTENDER)).updateParticipants(this.getParticipantValues());
    }

    public String getParticipantStatus() {
        StringBuilder buider = new StringBuilder("");
        for (String par : this.participantStatus_.keySet()) {
            if (buider.length() > 0) {
                buider.append(CalendarUtils.BREAK_LINE);
            }
            buider.append(par);
        }
        return buider.toString();
    }

    public void setParticipantStatus(String values) throws Exception {
        String[] array;
        for (String s : array = values.split(CalendarUtils.BREAK_LINE)) {
            if (s.trim().length() <= 0 || this.participantStatus_.put(s.trim(), STATUS_EMPTY) != null) continue;
            this.participantStatusList_.add(new ParticipantStatus(this, s.trim(), STATUS_EMPTY));
        }
    }

    protected boolean isSendMail() {
        return false;
    }

    public void importInvitationEvent(CalendarSetting calSetting, CalendarEvent event, String calendarId, String formtime) throws Exception {
        if (event != null) {
            this.setEventSumary(event.getSummary());
            this.setEventDescription(event.getDescription());
            this.setEventAllDate(CalendarUtils.isAllDayEvent((CalendarEvent)event));
            this.setEventFromDate(event.getFromDateTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setEventCheckTime(event.getFromDateTime());
            this.setEventToDate(event.getToDateTime(), calSetting.getDateFormat(), calSetting.getTimeFormat());
            this.setSelectedCalendarId(calendarId);
            this.setEventPlace(event.getLocation());
            this.setEventRepeat(event.getRepeatType());
            this.setEventReminders(event.getReminders());
            this.setAttachments(event.getAttachment());
            this.setMessage(event.getMessage());
            this.setParticipantStatusValues(event.getParticipantStatus());
        }
    }

    private String buildMailSubject(CalendarEvent event, DateFormat df, ResourceBundle res) {
        StringBuffer sbSubject = new StringBuffer("[" + this.getLabel(res, "invitation") + "] ");
        sbSubject.append(event.getSummary());
        sbSubject.append(" ");
        sbSubject.append(df.format(event.getFromDateTime()));
        return sbSubject.toString();
    }

    private String buildMailBody(User invitor, CalendarEvent event, String toDisplayName, DateFormat df, String timezone, ResourceBundle res) throws Exception {
        List atts = this.getAttachments(null, false);
        StringBuffer sbBody = new StringBuffer();
        sbBody.append("<div style=\"margin: 20px auto; padding: 8px; background: rgb(224, 236, 255) none repeat scroll 0%; -moz-background-clip: -moz-initial; -moz-background-origin: -moz-initial; -moz-background-inline-policy: -moz-initial; width: 500px;\">");
        sbBody.append("<table style=\"margin: 0px; padding: 0px; border-collapse: collapse; border-spacing: 0px; width: 100%; line-height: 16px;\">");
        sbBody.append("<tbody>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap; \">" + this.getLabel(res, "fromWho") + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\"> " + invitor.getDisplayName() + " (" + invitor.getEmail() + ") </td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(res, UIEventDetailTab.FIELD_MESSAGE) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + event.getMessage() + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(res, UIEventDetailTab.FIELD_EVENT) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + event.getSummary() + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(res, UIEventDetailTab.FIELD_DESCRIPTION) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + (event.getDescription() != null && event.getDescription().trim().length() > 0 ? event.getDescription() : " ") + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(res, "when") + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\"> <div>" + this.getLabel(res, UIEventDetailTab.FIELD_FROM) + ": " + df.format(event.getFromDateTime()) + " " + timezone + "</div>");
        sbBody.append("<div>" + this.getLabel(res, UIEventDetailTab.FIELD_TO) + ": " + df.format(event.getToDateTime()) + " " + timezone + "</div></td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(res, UIEventDetailTab.FIELD_PLACE) + ":</td>");
        sbBody.append("<td style=\"padding: 4px;\">" + (event.getLocation() != null && event.getLocation().trim().length() > 0 ? event.getLocation() : " ") + "</td>");
        sbBody.append("</tr>");
        sbBody.append("<tr>");
        sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(res, FIELD_MEETING) + "</td>");
        if (CalendarUtils.isEmpty((String)this.getInvitationEmail())) {
            sbBody.append("<td style=\"padding: 4px;\">" + toDisplayName + "</td>");
        } else {
            String newInvi = this.getInvitationEmail().replace(",", ", ");
            sbBody.append("<td style=\"padding: 4px;\">" + toDisplayName + ", " + newInvi + "</td>");
        }
        sbBody.append("</tr>");
        if (!atts.isEmpty()) {
            sbBody.append("<tr>");
            sbBody.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">" + this.getLabel(res, UIEventDetailTab.FIELD_ATTACHMENTS) + ":</td>");
            StringBuffer sbf = new StringBuffer();
            for (org.exoplatform.calendar.service.Attachment att : atts) {
                if (sbf.length() > 0) {
                    sbf.append(",");
                }
                sbf.append(att.getName());
            }
            sbBody.append("<td style=\"padding: 4px;\"> (" + atts.size() + ") " + sbf.toString() + " </td>");
            sbBody.append("</tr>");
        }
        return sbBody.toString();
    }

    protected void sendMail(MailService svr, OrganizationService orSvr, CalendarSetting setting, String fromId, String toId, CalendarEvent event) throws Exception {
        byte[] icsFile;
        MailService mService;
        CalendarService calService;
        User user;
        OrganizationService orgService;
        StringBuffer sbAddress;
        String toDisplayName;
        HashMap<String, String> eXoIdMap;
        List atts;
        User invitor;
        block18: {
            invitor = (User)ConversationState.getCurrent().getAttribute("UserProfile");
            if (invitor == null) {
                return;
            }
            atts = this.getAttachments(null, false);
            eXoIdMap = new HashMap<String, String>();
            HashMap<String, String> eXoMailMap = new HashMap<String, String>();
            toDisplayName = "";
            sbAddress = new StringBuffer();
            if (event.getInvitation() != null) {
                for (String s : event.getInvitation()) {
                    s = s.trim();
                    if (sbAddress.length() > 0) {
                        sbAddress.append(CalendarUtils.COMMA);
                    }
                    sbAddress.append(s);
                    eXoIdMap.put(s, null);
                }
            }
            orgService = CalendarUtils.getOrganizationService();
            for (String s : toId.split(CalendarUtils.COMMA)) {
                User user2 = orgService.getUserHandler().findUserByName(s);
                if (user2 == null) continue;
                eXoIdMap.put(user2.getEmail(), s);
                eXoMailMap.put(s, user2.getEmail());
                if (!toDisplayName.equals("")) {
                    toDisplayName = toDisplayName + ", ";
                }
                toDisplayName = toDisplayName + user2.getDisplayName();
                if (sbAddress.length() > 0) {
                    sbAddress.append(CalendarUtils.COMMA);
                }
                sbAddress.append(user2.getEmail());
            }
            user = orSvr.getUserHandler().findUserByName(fromId);
            calService = CalendarUtils.getCalendarService();
            mService = (MailService)this.getApplicationComponent(MailServiceImpl.class);
            icsFile = null;
            try {
                OutputStream out = calService.getCalendarImportExports("ICalendar(.ics)").exportEventCalendar(fromId, event.getCalendarId(), event.getCalType(), event.getId());
                icsFile = out.toString().getBytes("UTF-8");
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block18;
                LOG.debug((Object)"Fail to create attachment", (Throwable)e);
            }
        }
        String emailList = sbAddress.toString();
        for (String userEmail : emailList.split(CalendarUtils.COMMA)) {
            if (CalendarUtils.isEmpty((String)userEmail)) continue;
            String userId = (String)eXoIdMap.get(userEmail);
            CalendarSetting calendarSetting = null;
            if (userId != null) {
                calendarSetting = calService.getCalendarSetting(userId);
            }
            if (calendarSetting == null) {
                calendarSetting = CalendarUtils.getCurrentUserCalendarSetting();
            }
            WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
            ResourceBundle res = null;
            if (userId != null) {
                String lang;
                UserProfile userProfile = orgService.getUserProfileHandler().findUserProfileByName(userId);
                String string = lang = userProfile == null ? null : (String)userProfile.getUserInfoMap().get("user.language");
                if (lang != null && !lang.isEmpty()) {
                    res = context.getApplication().getResourceBundle(LocaleContextInfo.getLocale((String)lang));
                }
            }
            if (res == null) {
                res = context.getApplicationResourceBundle();
            }
            SimpleDateFormat _df = new SimpleDateFormat(calendarSetting.getDateFormat() + " " + calendarSetting.getTimeFormat());
            _df.setTimeZone(DateUtils.getTimeZone((String)calendarSetting.getTimeZone()));
            Message message = new Message();
            message.setSubject(this.buildMailSubject(event, (DateFormat)_df, res));
            message.setBody(this.getBodyMail(this.buildMailBody(invitor, event, toDisplayName, (DateFormat)_df, CalendarUtils.generateTimeZoneLabel((String)calendarSetting.getTimeZone()), res), eXoIdMap, userEmail, invitor, event, res));
            message.setTo(userEmail);
            message.setMimeType("text/html");
            message.setFrom(user.getDisplayName() + "<" + EXO_EMAIL_SMTP_FROM + ">");
            message.setReplyTo(user.getEmail());
            if (icsFile != null) {
                ByteArrayInputStream is = new ByteArrayInputStream(icsFile);
                Attachment attachmentCal = new Attachment();
                attachmentCal.setInputStream((InputStream)is);
                attachmentCal.setName("icalendar.ics");
                attachmentCal.setMimeType("text/calendar");
                message.addAttachment(attachmentCal);
            }
            if (!atts.isEmpty()) {
                for (org.exoplatform.calendar.service.Attachment att : atts) {
                    Attachment attachment = new Attachment();
                    attachment.setInputStream(att.getInputStream());
                    attachment.setMimeType(att.getMimeType());
                    attachment.setName(att.getName());
                    message.addAttachment(attachment);
                }
            }
            mService.sendMessage(message);
        }
    }

    private String getBodyMail(String sbBody, Map<String, String> eXoIdMap, String s, User invitor, CalendarEvent event, ResourceBundle res) throws Exception {
        StringBuilder body = new StringBuilder(sbBody.toString());
        String eXoId = CalendarUtils.isEmpty((String)eXoIdMap.get(s)) ? "null" : eXoIdMap.get(s);
        body.append("<tr>");
        body.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">");
        body.append(this.getLabel(res, "likeToAttend") + " </td><td> <a href=\"" + this.getReplyInvitationLink(1, invitor, s, eXoId, event) + "\" >" + this.getLabel(res, "yes") + "</a> - <a href=\"" + this.getReplyInvitationLink(2, invitor, s, eXoId, event) + "\" >" + this.getLabel(res, "notSure") + "</a> - <a href=\"" + this.getReplyInvitationLink(0, invitor, s, eXoId, event) + "\" >" + this.getLabel(res, "no") + "</a>");
        body.append("</td></tr>");
        body.append("<tr>");
        body.append("<td style=\"padding: 4px;  text-align: right; vertical-align: top; white-space:nowrap;\">");
        body.append(this.getLabel(res, "seeMoreDetails") + " </td><td><a href=\"" + this.getReplyInvitationLink(3, invitor, s, eXoId, event) + "\" >" + this.getLabel(res, "importToExoCalendar") + "</a> " + this.getLabel(res, "or") + " <a href=\"" + this.getReplyInvitationLink(4, invitor, s, eXoId, event) + "\" >" + this.getLabel(res, "jumpToExoCalendar") + "</a>");
        body.append("</td></tr>");
        body.append("</tbody>");
        body.append("</table>");
        body.append("</div>");
        return body.toString();
    }

    protected String getReplyInvitationLink(int answer, User invitor, String invitee, String eXoId, CalendarEvent event) throws Exception {
        String portalURL = CalendarUtils.getServerBaseUrl() + PortalContainer.getCurrentPortalContainerName();
        String restURL = portalURL + "/" + PortalContainer.getCurrentRestContextName();
        String calendarURL = CalendarUtils.getCalendarURL();
        if (answer == 1 || answer == 0 || answer == 2) {
            return restURL + "/cs/calendar" + CalendarUtils.INVITATION_URL + event.getCalendarId() + "/" + event.getCalType() + "/" + event.getId() + "/" + invitor.getUserName() + "/" + invitee + "/" + eXoId + "/" + answer;
        }
        if (answer == 3) {
            return calendarURL + CalendarUtils.INVITATION_IMPORT_URL + invitor.getUserName() + "/" + event.getId() + "/" + event.getCalType();
        }
        if (answer == 4) {
            return calendarURL + CalendarUtils.INVITATION_DETAIL_URL + invitor.getUserName() + "/" + event.getId() + "/" + event.getCalType();
        }
        return "";
    }

    public org.exoplatform.calendar.service.Attachment getAttachment(String attId) {
        UIEventDetailTab uiDetailTab = (UIEventDetailTab)this.getChildById(TAB_EVENTDETAIL);
        for (org.exoplatform.calendar.service.Attachment att : uiDetailTab.getAttachments()) {
            if (!att.getId().equals(attId)) continue;
            return att;
        }
        return null;
    }

    public List<ParticipantStatus> getParticipantStatusList() {
        return this.participantStatusList_;
    }

    public static void downloadAtt(Event<?> event, UIForm uiForm, boolean isEvent) throws Exception {
        String attId = event.getRequestContext().getRequestParameter("objectId");
        org.exoplatform.calendar.service.Attachment attach = null;
        if (isEvent) {
            UIEventForm uiEventForm = (UIEventForm)uiForm;
            attach = uiEventForm.getAttachment(attId);
        } else {
            UITaskForm uiTaskForm = (UITaskForm)uiForm;
            attach = uiTaskForm.getAttachment(attId);
        }
        if (attach != null) {
            String mimeType = attach.getMimeType().substring(attach.getMimeType().indexOf("/") + 1);
            InputStreamDownloadResource dresource = new InputStreamDownloadResource(attach.getInputStream(), mimeType);
            DownloadService dservice = (DownloadService)PortalContainer.getInstance().getComponentInstanceOfType(DownloadService.class);
            dresource.setDownloadName(attach.getName());
            String downloadLink = dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
            event.getRequestContext().getJavascriptManager().addJavascript((CharSequence)("ajaxRedirect('" + downloadLink + "');"));
            if (isEvent) {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getChildById(TAB_EVENTDETAIL));
            } else {
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getChildById(UITaskForm.TAB_TASKDETAIL));
            }
        }
    }

    private boolean isSignificantChanged(CalendarEvent newCalendarEvent, CalendarEvent oldCalendarEvent) {
        return newCalendarEvent != null && oldCalendarEvent != null && (oldCalendarEvent.getSummary() != null && !oldCalendarEvent.getSummary().equalsIgnoreCase(newCalendarEvent.getSummary()) || newCalendarEvent.getSummary() != null && !newCalendarEvent.getSummary().equalsIgnoreCase(oldCalendarEvent.getSummary()) || oldCalendarEvent.getDescription() != null && !oldCalendarEvent.getDescription().equalsIgnoreCase(newCalendarEvent.getDescription()) || newCalendarEvent.getDescription() != null && !newCalendarEvent.getDescription().equalsIgnoreCase(oldCalendarEvent.getDescription()) || oldCalendarEvent.getLocation() != null && !oldCalendarEvent.getLocation().equalsIgnoreCase(newCalendarEvent.getLocation()) || newCalendarEvent.getLocation() != null && !newCalendarEvent.getLocation().equalsIgnoreCase(oldCalendarEvent.getLocation()) || !oldCalendarEvent.getFromDateTime().equals(newCalendarEvent.getFromDateTime()) || !oldCalendarEvent.getToDateTime().equals(newCalendarEvent.getToDateTime()));
    }

    private CalendarEvent sendInvitation(Event<UIEventForm> event, CalendarSetting calSetting, CalendarEvent calendarEvent) throws Exception {
        String[] entry;
        String username = RequestContext.getCurrentInstance().getRemoteUser();
        String toId = null;
        if (this.isAddNew_ || this.isChangedSignificantly) {
            StringBuilder participantsList = new StringBuilder("");
            for (String par : this.participants_.keySet()) {
                if (participantsList.length() > 0) {
                    participantsList.append(CalendarUtils.COMMA);
                }
                participantsList.append(par);
            }
            toId = participantsList.toString();
        } else {
            LinkedHashMap<Object, Object> invitations = new LinkedHashMap<Object, Object>();
            for (String s : calendarEvent.getInvitation()) {
                invitations.put(s, s);
            }
            for (String parSt : calendarEvent.getParticipantStatus()) {
                entry = parSt.split(":");
                if (entry.length <= 1 || !entry[0].contains("@")) continue;
                invitations.remove(entry[0]);
            }
            calendarEvent.setInvitation(invitations.keySet().toArray(new String[invitations.size()]));
            StringBuilder builder = new StringBuilder("");
            String[] stringArray = calendarEvent.getParticipantStatus();
            int n = stringArray.length;
            for (int parSt = 0; parSt < n; ++parSt) {
                String parSt2 = stringArray[parSt];
                String[] entry2 = parSt2.split(":");
                if (entry2.length != 1 || entry2[0].contains("@")) continue;
                if (builder.length() > 0) {
                    builder.append(CalendarUtils.COMMA);
                }
                builder.append(entry2[0]);
            }
            if (builder.toString().trim().length() > 0 || invitations.size() > 0) {
                toId = builder.toString();
            }
        }
        try {
            if (toId != null && !toId.isEmpty()) {
                this.sendMail(CalendarUtils.getMailService(), CalendarUtils.getOrganizationService(), calSetting, username, toId, calendarEvent);
                LinkedList<String> parsUpdated = new LinkedList<String>();
                for (String parSt : calendarEvent.getParticipantStatus()) {
                    entry = parSt.split(":");
                    if (entry.length > 1) {
                        parsUpdated.add(entry[0] + ":" + entry[1]);
                        continue;
                    }
                    parsUpdated.add(entry[0] + ":" + STATUS_MAYBE);
                }
                calendarEvent.setParticipantStatus(parsUpdated.toArray(new String[parsUpdated.size()]));
            }
            return calendarEvent;
        }
        catch (Exception e) {
            event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIEventForm.msg.error-send-email", null));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Fail to send mail ivitation to the participant", (Throwable)e);
            }
            return null;
        }
    }

    public void processSaveEvent(Event<UIEventForm> event) throws Exception {
        UIEventForm uiForm = (UIEventForm)event.getSource();
        UICalendarPortlet uiPortlet = (UICalendarPortlet)uiForm.getAncestorOfType(UICalendarPortlet.class);
        UIPopupContainer uiPopupContainer = (UIPopupContainer)uiForm.getAncestorOfType(UIPopupContainer.class);
        UIPopupAction uiPopupAction = (UIPopupAction)uiPopupContainer.getChild(UIPopupAction.class);
        if (!uiForm.isReminderValid()) {
            event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.errorMsg_, (Object[])new String[]{uiForm.errorValues}, 1));
            uiForm.setSelectedTab(TAB_EVENTREMINDER);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupAction.class));
            return;
        }
        CalendarService calService = CalendarUtils.getCalendarService();
        if (calService.isRemoteCalendar(CalendarUtils.getCurrentUser(), uiForm.getCalendarId())) {
            event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UICalendars.msg.cant-add-event-on-remote-calendar", null, 1));
            ((PortalRequestContext)event.getRequestContext().getParentAppRequestContext()).ignoreAJAXUpdateOnPortlets(true);
            return;
        }
        CalendarSetting calSetting = uiPortlet.getCalendarSetting();
        CalendarEvent occurrence = uiForm.calendarEvent_;
        Date fromDate = uiForm.getEventFromDate(calSetting.getDateFormat(), calSetting.getTimeFormat());
        if (this.saveSeries == null && occurrence != null && !CalendarEvent.RP_NOREPEAT.equals(occurrence.getRepeatType()) && !CalendarUtils.isEmpty((String)occurrence.getRecurrenceId()) && CalendarUtils.isSameDate((Date)fromDate, (Date)occurrence.getFromDateTime())) {
            UIConfirmForm confirmForm = (UIConfirmForm)uiPopupAction.activate(UIConfirmForm.class, 600);
            confirmForm.setConfirmMessage("update-recurrence-event-confirm-msg");
            confirmForm.setConfig_id(uiForm.getId());
            confirmForm.setDelete(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
            return;
        }
        if (this.saveSeries != null) {
            uiPopupAction.deActivate();
            ((WebuiRequestContext)WebuiRequestContext.getCurrentInstance()).addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
        }
        String sendOption = uiForm.getSendOption();
        List lstPart = ((UIEventShareTab)uiForm.getChildById(TAB_EVENTSHARE)).getData();
        if (this.sendMail == null && CalendarSetting.ACTION_ASK.equalsIgnoreCase(sendOption) && lstPart.size() > 0) {
            boolean hasParticipant = false;
            for (ParticipantStatus participant : lstPart) {
                if (participant.getParticipant().equals(event.getRequestContext().getRemoteUser())) continue;
                hasParticipant = true;
                break;
            }
            if (hasParticipant) {
                uiPortlet.showConfirmWindow((UIComponent)this, this.saveEventSendMailUpdate);
                return;
            }
        }
        boolean isSendMail = "yes".equals(this.sendMail) || CalendarSetting.ACTION_ALWAYS.equals(sendOption);
        Boolean updateSeries = false;
        if ("all_event".equals(this.saveSeries)) {
            updateSeries = true;
        } else if ("only_this_event".equals(this.saveSeries)) {
            updateSeries = false;
        } else if ("following_event".equals(this.saveSeries)) {
            updateSeries = null;
        }
        this.saveAndNoAsk(event, isSendMail, updateSeries);
    }

    public void saveAndNoAsk(Event<UIEventForm> event, boolean isSend, Boolean updateSeries) throws Exception {
        UIEventForm uiForm;
        block48: {
            Calendar currentCalendar;
            Date to;
            uiForm = (UIEventForm)event.getSource();
            UICalendarPortlet calendarPortlet = (UICalendarPortlet)uiForm.getAncestorOfType(UICalendarPortlet.class);
            UIPopupAction uiPopupAction = (UIPopupAction)uiForm.getAncestorOfType(UIPopupAction.class);
            UICalendarViewContainer uiViewContainer = (UICalendarViewContainer)calendarPortlet.findFirstComponentOfType(UICalendarViewContainer.class);
            CalendarSetting calSetting = calendarPortlet.getCalendarSetting();
            CalendarService calService = CalendarUtils.getCalendarService();
            String summary = uiForm.getEventSumary().trim();
            String location = uiForm.getEventPlace();
            location = !CalendarUtils.isEmpty((String)location) ? location.replaceAll(CalendarUtils.GREATER_THAN, "").replaceAll(CalendarUtils.SMALLER_THAN, "") : null;
            String description = uiForm.getEventDescription();
            description = !CalendarUtils.isEmpty((String)description) ? description.replaceAll(CalendarUtils.GREATER_THAN, "").replaceAll(CalendarUtils.SMALLER_THAN, "") : null;
            if (!uiForm.isEventDetailValid(calSetting)) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.errorMsg_, null));
                uiForm.setSelectedTab(TAB_EVENTDETAIL);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupAction.class));
                return;
            }
            if (!uiForm.isReminderValid()) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.errorMsg_, (Object[])new String[]{uiForm.errorValues}));
                uiForm.setSelectedTab(TAB_EVENTREMINDER);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupAction.class));
                return;
            }
            if (!uiForm.isParticipantValid()) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.errorMsg_, (Object[])new String[]{uiForm.errorValues}));
                uiForm.setSelectedTab(TAB_EVENTSHARE);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupAction.class));
                return;
            }
            Date from = uiForm.getEventFromDate(calSetting.getDateFormat(), calSetting.getTimeFormat());
            if (from.after(to = uiForm.getEventToDate(calSetting.getDateFormat(), calSetting.getTimeFormat()))) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage(uiForm.getId() + ".msg.event-date-time-logic", null, 1));
                return;
            }
            String username = CalendarUtils.getCurrentUser();
            String calendarId = uiForm.getCalendarId();
            if (from.equals(to)) {
                to = CalendarUtils.getEndDay((Date)from).getTime();
            }
            if (uiForm.getEventAllDate()) {
                java.util.Calendar tempCal = CalendarUtils.getInstanceOfCurrentCalendar();
                tempCal.setTime(to);
                tempCal.add(14, -1);
                to = tempCal.getTime();
            }
            if ((currentCalendar = CalendarUtils.getCalendar((String)uiForm.calType_, (String)calendarId)) == null) {
                uiPopupAction.deActivate();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UICalendars.msg.have-no-calendar", null, 1));
                return;
            }
            boolean canEdit = false;
            if (uiForm.calType_.equals(CalendarUtils.SHARED_TYPE)) {
                canEdit = Utils.hasPermission((String[])Utils.getEditPerUsers((Calendar)currentCalendar));
            } else if (uiForm.calType_.equals(CalendarUtils.PUBLIC_TYPE)) {
                canEdit = Utils.hasPermission((String[])currentCalendar.getEditPermission());
            }
            if (!canEdit && !uiForm.calType_.equals(CalendarUtils.PRIVATE_TYPE)) {
                uiPopupAction.deActivate();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UICalendars.msg.have-no-permission-to-edit", null, 1));
                return;
            }
            CalendarEvent calendarEvent = null;
            CalendarEvent oldCalendarEvent = null;
            String[] pars = uiForm.getParticipantValues().split(CalendarUtils.BREAK_LINE);
            String eventId = null;
            if (uiForm.isAddNew_) {
                calendarEvent = new CalendarEvent();
            } else {
                calendarEvent = uiForm.calendarEvent_;
                oldCalendarEvent = new CalendarEvent();
                oldCalendarEvent.setSummary(calendarEvent.getSummary());
                oldCalendarEvent.setDescription(calendarEvent.getDescription());
                oldCalendarEvent.setLocation(calendarEvent.getLocation());
                oldCalendarEvent.setFromDateTime(calendarEvent.getFromDateTime());
                oldCalendarEvent.setToDateTime(calendarEvent.getToDateTime());
            }
            calendarEvent.setFromDateTime(from);
            calendarEvent.setToDateTime(to);
            calendarEvent.setSendOption(uiForm.getSendOption());
            calendarEvent.setMessage(uiForm.getMessage());
            String[] parStatus = uiForm.getParticipantStatusValues().split(CalendarUtils.BREAK_LINE);
            calendarEvent.setParticipantStatus(parStatus);
            calendarEvent.setParticipant(pars);
            if (CalendarUtils.isEmpty((String)uiForm.getInvitationEmail())) {
                calendarEvent.setInvitation(ArrayUtils.EMPTY_STRING_ARRAY);
            } else if (CalendarUtils.isValidEmailAddresses((String)uiForm.getInvitationEmail())) {
                String addressList = uiForm.getInvitationEmail().replaceAll(CalendarUtils.SEMICOLON, CalendarUtils.COMMA);
                LinkedHashMap<String, String> emails = new LinkedHashMap<String, String>();
                for (String email : addressList.split(CalendarUtils.COMMA)) {
                    String address = email.trim();
                    if (emails.containsKey(address)) continue;
                    emails.put(address, address);
                }
                if (!emails.isEmpty()) {
                    calendarEvent.setInvitation(emails.keySet().toArray(new String[emails.size()]));
                }
            } else {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIEventForm.msg.event-email-invalid", (Object[])new String[]{CalendarUtils.invalidEmailAddresses((String)uiForm.getInvitationEmail())}));
                uiForm.setSelectedTab(TAB_EVENTSHARE);
                event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIPopupAction.class));
                return;
            }
            calendarEvent.setCalendarId(uiForm.getCalendarId());
            calendarEvent.setEventType(CalendarEvent.TYPE_EVENT);
            calendarEvent.setSummary(summary);
            calendarEvent.setDescription(description);
            calendarEvent.setCalType(uiForm.calType_);
            calendarEvent.setCalendarId(calendarId);
            calendarEvent.setEventCategoryId(uiForm.getEventCategory());
            UIFormSelectBox selectBox = ((UIFormInputWithActions)uiForm.getChildById(TAB_EVENTDETAIL)).getUIFormSelectBox(UIEventDetailTab.FIELD_CATEGORY);
            for (SelectItemOption o : selectBox.getOptions()) {
                if (!((String)o.getValue()).equals(selectBox.getValue())) continue;
                calendarEvent.setEventCategoryName(o.getLabel());
                break;
            }
            calendarEvent.setLocation(location);
            if (uiForm.getEventIsRepeat()) {
                if (this.repeatEvent != null) {
                    calendarEvent.setRepeatType(this.repeatEvent.getRepeatType());
                    calendarEvent.setRepeatInterval(this.repeatEvent.getRepeatInterval());
                    calendarEvent.setRepeatCount(this.repeatEvent.getRepeatCount());
                    calendarEvent.setRepeatUntilDate(this.repeatEvent.getRepeatUntilDate());
                    calendarEvent.setRepeatByDay(this.repeatEvent.getRepeatByDay());
                    calendarEvent.setRepeatByMonthDay(this.repeatEvent.getRepeatByMonthDay());
                    TimeZone tz = DateUtils.getTimeZone((String)calSetting.getTimeZone());
                    Utils.updateOriginDate((CalendarEvent)calendarEvent, (TimeZone)tz);
                    Utils.adaptRepeatRule((CalendarEvent)calendarEvent, (TimeZone)tz, (TimeZone)CalendarService.PERSISTED_TIMEZONE);
                }
            } else {
                calendarEvent.setRepeatType(CalendarEvent.RP_NOREPEAT);
                calendarEvent.setRepeatInterval(0L);
                calendarEvent.setRepeatCount(0L);
                calendarEvent.setRepeatUntilDate(null);
                calendarEvent.setRepeatByDay(null);
                calendarEvent.setRepeatByMonthDay(null);
            }
            calendarEvent.setPriority(uiForm.getEventPriority());
            calendarEvent.setPrivate(ITEM_PRIVATE.equals(uiForm.getShareType()));
            calendarEvent.setEventState(uiForm.getEventState());
            calendarEvent.setAttachment(uiForm.getAttachments(calendarEvent.getId(), uiForm.isAddNew_));
            calendarEvent.setReminders(uiForm.getEventReminders(from, calendarEvent.getReminders()));
            eventId = calendarEvent.getId();
            CalendarView calendarView = (CalendarView)uiViewContainer.getRenderedChild();
            this.isChangedSignificantly = this.isSignificantChanged(calendarEvent, oldCalendarEvent);
            try {
                block47: {
                    if (uiForm.isAddNew_) {
                        if (uiForm.calType_.equals(CalendarUtils.PRIVATE_TYPE)) {
                            calService.saveUserEvent(username, calendarId, calendarEvent, uiForm.isAddNew_);
                        } else if (uiForm.calType_.equals(CalendarUtils.SHARED_TYPE)) {
                            calService.saveEventToSharedCalendar(username, calendarId, calendarEvent, uiForm.isAddNew_);
                        } else if (uiForm.calType_.equals(CalendarUtils.PUBLIC_TYPE)) {
                            calService.savePublicEvent(calendarId, calendarEvent, uiForm.isAddNew_);
                        }
                    } else {
                        String fromCal = uiForm.oldCalendarId_.split(CalendarUtils.COLON)[1].trim();
                        String toCal = uiForm.newCalendarId_.split(CalendarUtils.COLON)[1].trim();
                        String fromType = uiForm.oldCalendarId_.split(CalendarUtils.COLON)[0].trim();
                        String toType = uiForm.newCalendarId_.split(CalendarUtils.COLON)[0].trim();
                        ArrayList<CalendarEvent> listEvent = new ArrayList<CalendarEvent>();
                        listEvent.add(calendarEvent);
                        if (!uiForm.calendarEvent_.getRepeatType().equals(CalendarEvent.RP_NOREPEAT) && !CalendarUtils.isEmpty((String)uiForm.calendarEvent_.getRecurrenceId())) {
                            CalendarEvent originEvent = calService.getRepetitiveEvent(uiForm.calendarEvent_);
                            if (updateSeries == null) {
                                calService.saveFollowingSeriesEvents(originEvent, uiForm.calendarEvent_, username);
                            } else if (!updateSeries.booleanValue()) {
                                calService.saveOneOccurrenceEvent(originEvent, uiForm.calendarEvent_, username);
                            } else if (CalendarUtils.isSameDate((Date)oldCalendarEvent.getFromDateTime(), (Date)calendarEvent.getFromDateTime())) {
                                calService.saveAllSeriesEvents(calendarEvent, username);
                            } else {
                                calService.saveOneOccurrenceEvent(originEvent, uiForm.calendarEvent_, username);
                            }
                        } else if (Utils.isExceptionOccurrence((CalendarEvent)this.calendarEvent_)) {
                            calService.updateOccurrenceEvent(fromCal, toCal, fromType, toType, listEvent, username);
                        } else {
                            calService.moveEvent(fromCal, toCal, fromType, toType, listEvent, username);
                        }
                        UITaskForm.updateListView((CalendarView)calendarView, (CalendarEvent)calendarEvent, (CalendarService)calService, (String)username);
                    }
                    if (calendarEvent != null && isSend) {
                        try {
                            CalendarEvent tempCal = this.sendInvitation(event, calSetting, calendarEvent);
                            calendarEvent = tempCal != null ? tempCal : calendarEvent;
                        }
                        catch (Exception e) {
                            if (!LOG.isWarnEnabled()) break block47;
                            LOG.warn((Object)"Sending invitation failed!", (Throwable)e);
                        }
                    }
                }
                uiViewContainer.refresh();
                UIListContainer uiListView = (UIListContainer)calendarPortlet.findFirstComponentOfType(UIListContainer.class);
                if (uiListView != null && uiListView.isRendered() && uiListView.isDisplaySearchResult()) {
                    ((UIListView)uiListView.findFirstComponentOfType(UIListView.class)).refreshSearch();
                }
                calendarView.setLastUpdatedEventId(eventId);
                UIMiniCalendar uiMiniCalendar = (UIMiniCalendar)calendarPortlet.findFirstComponentOfType(UIMiniCalendar.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMiniCalendar);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
                uiPopupAction.deActivate();
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
            }
            catch (Exception e) {
                event.getRequestContext().getUIApplication().addMessage(new ApplicationMessage("UIEventForm.msg.add-event-error", null));
                if (!LOG.isDebugEnabled()) break block48;
                LOG.debug((Object)"Fail to add the event", (Throwable)e);
            }
        }
        UIEventDetailTab uiDetailTab = (UIEventDetailTab)uiForm.getChildById(TAB_EVENTDETAIL);
        for (org.exoplatform.calendar.service.Attachment att : uiDetailTab.getAttachments()) {
            UIAttachFileForm.removeUploadTemp((UploadService)((UploadService)uiForm.getApplicationComponent(UploadService.class)), (String)att.getResourceId());
        }
    }

    public void setRepeatEvent(CalendarEvent repeatEvent) throws Exception {
        this.repeatEvent = repeatEvent;
        this.setEventIsRepeat(true);
        this.setRepeatSummary(this.buildRepeatSummary(repeatEvent));
    }

    public void setRepeatSummary(String summary) {
        this.repeatSummary = summary;
    }

    public String getRepeatSummary() {
        return this.repeatSummary;
    }

    public CalendarEvent getRepeatEvent() {
        return this.repeatEvent;
    }

    public String buildRepeatSummary(CalendarEvent repeatEvent) throws Exception {
        CalendarSetting calSetting = CalendarUtils.getCurrentUserCalendarSetting();
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat format = new SimpleDateFormat(calSetting.getDateFormat(), locale);
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        String[] dayOfWeeks = symbols.getWeekdays();
        String summary = "";
        if (repeatEvent == null) {
            return "";
        }
        String repeatType = repeatEvent.getRepeatType();
        if (CalendarEvent.RP_NOREPEAT.equals(repeatType) || repeatType == null) {
            return "";
        }
        int interval = (int)repeatEvent.getRepeatInterval();
        int count = (int)repeatEvent.getRepeatCount();
        Date until = repeatEvent.getRepeatUntilDate();
        String endType = "neverEnd";
        if (count > 0) {
            endType = "endAfter";
        }
        if (until != null) {
            endType = "endByDate";
        }
        StringBuilder pattern = null;
        if (repeatType.equals(CalendarEvent.RP_DAILY)) {
            pattern = interval == 1 ? new StringBuilder(this.getLabel("daily")) : new StringBuilder(this.getLabel("every-day"));
            if (endType.equals("endAfter")) {
                pattern.append(", ").append(this.getLabel("count-times"));
            }
            if (endType.equals("endByDate")) {
                pattern.append(", ").append(this.getLabel("until"));
            }
            summary = pattern.toString().replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate()));
            return summary;
        }
        if (repeatType.equals(CalendarEvent.RP_WEEKLY)) {
            pattern = interval == 1 ? new StringBuilder(this.getLabel("weekly")) : new StringBuilder(this.getLabel("every-week"));
            if (endType.equals("endAfter")) {
                pattern.append(", ").append(this.getLabel("count-times"));
            }
            if (endType.equals("endByDate")) {
                pattern.append(", ").append(this.getLabel("until"));
            }
            String[] weeklyByDays = repeatEvent.getRepeatByDay();
            StringBuffer byDays = new StringBuffer();
            for (int i = 0; i < weeklyByDays.length; ++i) {
                if (i == 0) {
                    byDays.append(dayOfWeeks[UIRepeatEventForm.convertToDayOfWeek((String)weeklyByDays[0])]);
                    continue;
                }
                byDays.append(", ");
                byDays.append(dayOfWeeks[UIRepeatEventForm.convertToDayOfWeek((String)weeklyByDays[i])]);
            }
            summary = pattern.toString().replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate())).replace("{byDays}", byDays.toString());
            return summary;
        }
        if (repeatType.equals(CalendarEvent.RP_MONTHLY)) {
            String monthlyType = "monthlyByMonthDay";
            if (repeatEvent.getRepeatByDay() != null && repeatEvent.getRepeatByDay().length > 0) {
                monthlyType = "monthlyByDay";
            }
            pattern = interval == 1 ? new StringBuilder(this.getLabel("monthly")) : new StringBuilder(this.getLabel("every-month"));
            if (monthlyType.equals("monthlyByDay")) {
                pattern.append(" ").append(this.getLabel("monthly-by-day"));
            } else {
                pattern.append(" ").append(this.getLabel("monthly-by-month-day"));
            }
            if (endType.equals("endAfter")) {
                pattern.append(", ").append(this.getLabel("count-times"));
            }
            if (endType.equals("endByDate")) {
                pattern.append(", ").append(this.getLabel("until"));
            }
            String theNumber = "";
            String theDay = "";
            if (monthlyType.equals("monthlyByDay")) {
                java.util.Calendar temp = CalendarUtils.getInstanceOfCurrentCalendar();
                temp.setTime(repeatEvent.getFromDateTime());
                temp.setFirstDayOfWeek(1);
                int weekOfMonth = temp.get(4);
                java.util.Calendar temp2 = CalendarUtils.getInstanceOfCurrentCalendar();
                temp2.setTime(temp.getTime());
                temp2.add(5, 7);
                if (temp2.get(2) != temp.get(2)) {
                    weekOfMonth = 5;
                }
                int dayOfWeek = temp.get(7);
                String[] weekOfMonths = new String[]{this.getLabel("summary-the-first"), this.getLabel("summary-the-second"), this.getLabel("summary-the-third"), this.getLabel("summary-the-fourth"), this.getLabel("summary-the-last")};
                theNumber = weekOfMonths[weekOfMonth - 1];
                theDay = dayOfWeeks[dayOfWeek];
            } else {
                java.util.Calendar temp = CalendarUtils.getInstanceOfCurrentCalendar();
                temp.setTime(repeatEvent.getFromDateTime());
                int dayOfMonth = temp.get(5);
                theDay = String.valueOf(dayOfMonth);
            }
            summary = pattern.toString().replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate())).replace("{theDay}", theDay).replace("{theNumber}", theNumber);
            return summary;
        }
        if (repeatType.equals(CalendarEvent.RP_YEARLY)) {
            pattern = interval == 1 ? new StringBuilder(this.getLabel("yearly")) : new StringBuilder(this.getLabel("every-year"));
            if (endType.equals("endAfter")) {
                pattern.append(", ").append(this.getLabel("count-times"));
            }
            if (endType.equals("endByDate")) {
                pattern.append(", ").append(this.getLabel("until"));
            }
            String theDay = format.format(repeatEvent.getFromDateTime());
            summary = pattern.toString().replace("{interval}", String.valueOf(interval)).replace("{count}", String.valueOf(repeatEvent.getRepeatCount())).replace("{until}", repeatEvent.getRepeatUntilDate() == null ? "" : format.format(repeatEvent.getRepeatUntilDate())).replace("{theDay}", theDay);
            return summary;
        }
        return summary;
    }

    @Deprecated
    private void confirmSaveEvent(Event<UIEventForm> event, boolean isSend) throws Exception {
        UIEventForm uiEventForm = (UIEventForm)event.getSource();
        UICalendarPortlet uiPortlet = (UICalendarPortlet)uiEventForm.getAncestorOfType(UICalendarPortlet.class);
        UIPopupContainer uiPopupContainer = (UIPopupContainer)uiEventForm.getAncestorOfType(UIPopupContainer.class);
        UIPopupAction uiPopupAction = (UIPopupAction)uiPopupContainer.getChild(UIPopupAction.class);
        uiPopupAction.deActivate();
        CalendarSetting calSetting = uiPortlet.getCalendarSetting();
        Date fromDate = uiEventForm.getEventFromDate(calSetting.getDateFormat(), calSetting.getTimeFormat());
        CalendarEvent occurrence = uiEventForm.calendarEvent_;
        if (occurrence != null && !CalendarEvent.RP_NOREPEAT.equals(occurrence.getRepeatType()) && !CalendarUtils.isEmpty((String)occurrence.getRecurrenceId()) && CalendarUtils.isSameDate((Date)fromDate, (Date)occurrence.getFromDateTime())) {
            UIConfirmForm confirmForm = (UIConfirmForm)uiPopupAction.activate(UIConfirmForm.class, 480);
            confirmForm.setConfirmMessage("update-recurrence-event-confirm-msg");
            confirmForm.setConfig_id(uiEventForm.getId());
            confirmForm.setDelete(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
        } else {
            uiEventForm.saveAndNoAsk(event, isSend, Boolean.valueOf(false));
        }
    }

    static /* synthetic */ String access$002(UIEventForm x0, String x1) {
        x0.sendMail = x1;
        return x0.sendMail;
    }

    static /* synthetic */ CalendarEvent access$100(UIEventForm x0) {
        return x0.repeatEvent;
    }

    static /* synthetic */ String access$202(UIEventForm x0, String x1) {
        x0.saveSeries = x1;
        return x0.saveSeries;
    }
}

