/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.model.query.EventQuery;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.ExtendedCalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.storage.jcr.JCREventQuery;
import org.exoplatform.calendar.webui.CalendarView;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarWorkingContainer;
import org.exoplatform.calendar.webui.UICalendars;
import org.exoplatform.calendar.webui.UIListView;
import org.exoplatform.commons.utils.DateUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.cssfile.CssClassUtils;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

public abstract class UICalendarView
extends UIForm
implements CalendarView {
    private static final Log log = ExoLogger.getLogger(UICalendarView.class);
    protected static final String EVENT_CATEGORIES = "eventCategories".intern();
    public static final int TYPE_NONE = -1;
    public static final int TYPE_DAY = 0;
    public static final int TYPE_WEEK = 1;
    public static final int TYPE_MONTH = 2;
    public static final String ACT_NEXT = "MoveNext".intern();
    public static final String ACT_PREVIOUS = "MovePrevious".intern();
    public static final String CALNAME = "calName".intern();
    public static final String CALENDARID = "calendarId".intern();
    public static final String CALTYPE = "calType".intern();
    public static final String EVENTID = "eventId".intern();
    public static final String START_TIME = "startTime";
    public static final String FINISH_TIME = "finishTime";
    public static final String DAY = "day".intern();
    public static final String MONTH = "month".intern();
    public static final String YEAR = "year".intern();
    public static final String ISOCCUR = "isOccur".intern();
    public static final String RECURID = "recurId".intern();
    public static final String TYPE_EVENT = CalendarEvent.TYPE_EVENT;
    public static final String TYPE_TASK = CalendarEvent.TYPE_TASK;
    public static final String TYPE_BOTH = "Both".intern();
    public static final String ACT_ADDNEW_EVENT = "QuickAddNewEvent".intern();
    public static final String ACT_ADDNEW_TASK = "QuickAddNewTask".intern();
    public static final String[] CONTEXT_MENU = new String[]{ACT_ADDNEW_EVENT, ACT_ADDNEW_TASK};
    public static final String ACT_VIEW = "View".intern();
    public static final String ACT_EDIT = "Edit".intern();
    public static final String ACT_DELETE = "Delete".intern();
    public static final String[] QUICKEDIT_MENU = new String[]{ACT_VIEW, ACT_EDIT, ACT_DELETE};
    private String viewType_ = TYPE_BOTH;
    private String[] views = new String[]{TYPE_BOTH, TYPE_EVENT, TYPE_TASK};
    protected java.util.Calendar calendar_ = null;
    protected List<String> displayTimes_ = null;
    protected Map<String, String> timeSteps_ = null;
    public boolean isShowEvent_ = true;
    private boolean allDelete_ = true;
    private String editedEventId_ = null;
    private int timeInterval_ = 30;
    private DateFormat dayFormat = null;
    private DateFormat timeFormat = null;
    protected CalendarSetting calendarSetting_;
    private String dateTimeFormat_;
    protected java.util.Calendar instanceTempCalendar_ = null;
    public static final Map<Integer, String> monthsName_ = new HashMap();
    private Map<Integer, String> daysMap_ = new LinkedHashMap();
    private Map<Integer, String> monthsMap_ = new LinkedHashMap();
    private Map<String, String> priorityMap_ = new HashMap();
    protected DateFormatSymbols dfs_;
    private CalendarEvent currentOccurrence;
    protected Map<String, Map<String, CalendarEvent>> recurrenceEventsMap = new LinkedHashMap();
    protected ExtendedCalendarService xCalService = (ExtendedCalendarService)this.getApplicationComponent(ExtendedCalendarService.class);
    private String singleDeletedEventId = null;
    private String singleDeletedCalendarId = null;
    private String singleDeletedEventType = null;

    abstract LinkedHashMap<String, Event> getDataMap();

    public UICalendarView() throws Exception {
        int i;
        this.calendar_ = CalendarUtils.getInstanceOfCurrentCalendar();
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(EVENT_CATEGORIES, EVENT_CATEGORIES, null));
        this.update();
        this.applySeting();
        Locale locale = this.getLocale();
        this.dfs_ = new DateFormatSymbols(locale);
        for (i = 0; i < this.dfs_.getMonths().length; ++i) {
            this.monthsMap_.put(i, this.dfs_.getMonths()[i]);
        }
        for (i = 1; i < this.dfs_.getWeekdays().length; ++i) {
            this.daysMap_.put(i, this.dfs_.getWeekdays()[i]);
        }
        for (i = 0; i < CalendarEvent.PRIORITY.length; ++i) {
            this.priorityMap_.put(String.valueOf(i), CalendarEvent.PRIORITY[i]);
        }
    }

    public abstract String getDefaultStartTimeOfEvent();

    protected String renderDayViewInTitleBar(String monthOpenTag, String monthCloseTag, String yearOpenTag, String yearCloseTag) {
        String formatPattern = "";
        String dateFormat = this.getDateFormat();
        if (dateFormat.equalsIgnoreCase(CalendarUtils.FORMATPATTERN1)) {
            formatPattern = "%1$td / %2$s%1$tm%3$s / %4$s%1$tY%5$s";
        } else if (dateFormat.equalsIgnoreCase(CalendarUtils.FORMATPATTERN2)) {
            formatPattern = "%1$td - %2$s%1$tm%3$s - %4$s%1$tY%5$s";
        } else if (dateFormat.equalsIgnoreCase(CalendarUtils.FORMATPATTERN3)) {
            formatPattern = "%2$s%1$tm%3$s / %1$td / %4$s%1$tY%5$s";
        } else if (dateFormat.equalsIgnoreCase(CalendarUtils.FORMATPATTERN4)) {
            formatPattern = "%2$s%1$tm%3$s - %1$td - %4$s%1$tY%5$s";
        }
        return String.format(formatPattern, this.getCurrentCalendar(), monthOpenTag, monthCloseTag, yearOpenTag, yearCloseTag);
    }

    protected java.util.Calendar getInstanceTempCalendar() {
        return CalendarUtils.getCalendarInstanceBySetting((CalendarSetting)this.calendarSetting_);
    }

    public void applySeting() throws Exception {
        this.displayTimes_ = null;
        this.timeSteps_ = null;
        this.instanceTempCalendar_ = null;
        try {
            this.calendarSetting_ = ((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).getCalendarSetting();
        }
        catch (Exception e) {
            CalendarService calService = CalendarUtils.getCalendarService();
            String username = CalendarUtils.getCurrentUser();
            this.calendarSetting_ = calService.getCalendarSetting(username);
        }
        this.dateTimeFormat_ = this.getDateFormat() + " " + this.getTimeFormat();
        Date selectedDate = this.calendar_ != null ? this.calendar_.getTime() : null;
        this.calendar_ = CalendarUtils.getCalendarInstanceBySetting((CalendarSetting)this.calendarSetting_);
        if (selectedDate != null) {
            this.calendar_.setTime(selectedDate);
        }
    }

    public void setViewType(String viewType) {
        this.viewType_ = viewType;
    }

    public String getViewType() {
        return this.viewType_;
    }

    protected String[] getViews() {
        return this.views;
    }

    protected String getIconStyleForAttachment(Attachment attachment) {
        return CssClassUtils.getCSSClassByFileNameAndFileType((String)attachment.getName(), (String)attachment.getMimeType(), null);
    }

    public void setLastUpdatedEventId(String eventId) {
        this.editedEventId_ = eventId;
    }

    public String getLastUpdatedEventId() {
        return this.editedEventId_;
    }

    public String[] getPublicCalendars() throws Exception {
        HashSet<String> map = new HashSet<String>();
        for (Calendar calendar : this.getPublicCalendars(CalendarUtils.getCurrentUser())) {
            map.add(calendar.getId());
        }
        return map.toArray(new String[map.size()]);
    }

    public List<String> getPrivateCalendars() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isInSpace()) {
            return list;
        }
        List cals = (List)this.getCalendars().get(Calendar.Type.PERSONAL.name());
        if (cals != null) {
            for (Calendar cal : this.filterHidden(cals)) {
                list.add(cal.getId());
            }
        }
        return list;
    }

    public List<String> getOtherCalendars() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Map cals = this.getCalendars();
        HashSet<String> typeNames = new HashSet<String>();
        for (Calendar.Type t : Calendar.Type.values()) {
            if (Calendar.Type.UNDEFINED.equals((Object)t)) continue;
            typeNames.add(t.name());
        }
        LinkedList other = new LinkedList();
        for (String type : cals.keySet()) {
            if (typeNames.contains(type)) continue;
            other.addAll((Collection)cals.get(type));
        }
        for (Calendar cal : this.filterHidden(other)) {
            list.add(cal.getId());
        }
        return list;
    }

    public List<String> getOtherSpaceCalendar() throws Exception {
        Map allCal = this.getAllCalendars();
        LinkedList<String> otherSpaceCal = new LinkedList<String>();
        String groupId = UICalendarPortlet.getGroupIdOfSpace();
        Set spaceMS = this.getSpaceMembership(groupId);
        for (String calId : this.getOtherCalendars()) {
            if (!this.isSpaceCal((Calendar)allCal.get(calId), spaceMS)) continue;
            otherSpaceCal.add(calId);
        }
        return otherSpaceCal;
    }

    private boolean isSpaceCal(Calendar calendar, Set<MembershipEntry> spaceMS) {
        if (calendar.getViewPermission() != null) {
            for (String per : calendar.getViewPermission()) {
                MembershipEntry entry = MembershipEntry.parse((String)per);
                if (entry == null || !spaceMS.contains(entry)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<MembershipEntry> getSpaceMembership(String groupId) {
        HashSet<MembershipEntry> entries = new HashSet<MembershipEntry>();
        entries.add(new MembershipEntry(groupId, "manager"));
        entries.add(new MembershipEntry(groupId, "member"));
        return entries;
    }

    private Map<String, Calendar> getAllCalendars() {
        UICalendarWorkingContainer container = (UICalendarWorkingContainer)this.getAncestorOfType(UICalendarWorkingContainer.class);
        Map map = container.getCalendarMap();
        HashMap<String, Calendar> allCals = new HashMap<String, Calendar>();
        for (List cals : map.values()) {
            for (Calendar cal : cals) {
                allCals.put(cal.getId(), cal);
            }
        }
        return allCals;
    }

    public List<String> getSharedCalendars() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (this.isInSpace()) {
            return list;
        }
        List cals = (List)this.getCalendars().get(Calendar.Type.SHARED.name());
        if (cals != null) {
            for (Calendar cal : this.filterHidden(cals)) {
                list.add(cal.getId());
            }
        }
        return list;
    }

    public String[] getFilterCalendarIds() throws Exception {
        ArrayList<String> filterList = new ArrayList<String>();
        filterList.addAll(Arrays.asList(this.getCalendarSetting().getFilterPrivateCalendars()));
        filterList.addAll(Arrays.asList(this.getCalendarSetting().getFilterPublicCalendars()));
        filterList.addAll(Arrays.asList(this.getCalendarSetting().getFilterSharedCalendars()));
        ArrayList<String> ids = new ArrayList<String>();
        ids.addAll(this.getPrivateCalendars());
        ids.addAll(this.getSharedCalendars());
        ids.addAll(Arrays.asList(this.getPublicCalendars()));
        ArrayList<String> results = new ArrayList<String>();
        for (String id : ids) {
            if (filterList.contains(id)) continue;
            results.add(id);
        }
        return results.toArray(new String[0]);
    }

    protected List<Calendar> getPublicCalendars(String username) throws Exception {
        String[] groups = CalendarUtils.getUserGroups((String)username);
        UICalendarPortlet uiCalendarPortlet = (UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class);
        if (this.isInSpace()) {
            groups = new String[]{uiCalendarPortlet != null ? uiCalendarPortlet.getSpaceGroupId() : UICalendarPortlet.getGroupIdOfSpace()};
        }
        LinkedList<Calendar> result = new LinkedList<Calendar>();
        List tmp = (List)this.getCalendars().get(Calendar.Type.GROUP.name());
        if (tmp != null) {
            block0: for (Calendar cal : tmp) {
                List<String> calGrp = Arrays.asList(cal.getGroups());
                for (String g : groups) {
                    if (!calGrp.contains(g)) continue;
                    result.add(cal);
                    continue block0;
                }
            }
        }
        return this.filterHidden(result);
    }

    private List<Calendar> filterHidden(List<Calendar> calendars) {
        LinkedList<Calendar> result = new LinkedList<Calendar>();
        if (calendars != null && !calendars.isEmpty()) {
            List filterCals = this.getCalendarSetting().getFilterCalendars();
            for (Calendar cal : calendars) {
                if (filterCals.contains(cal.getId())) continue;
                result.add(cal);
            }
        }
        return result;
    }

    private Map<String, List<Calendar>> getCalendars() {
        UICalendarWorkingContainer container = (UICalendarWorkingContainer)this.getAncestorOfType(UICalendarWorkingContainer.class);
        return container.getCalendarMap();
    }

    protected boolean isEventEditable(Event event) throws Exception {
        org.exoplatform.calendar.model.Calendar calendar = this.xCalService.getCalendarHandler().getCalendarById(event.getCalendarId());
        return Utils.isCalendarEditable((String)CalendarUtils.getCurrentUser(), (Calendar)Calendar.build((org.exoplatform.calendar.model.Calendar)calendar));
    }

    public Map<String, String> getColors() {
        Map<String, String> colors;
        block6: {
            colors = new LinkedHashMap<String, String>();
            try {
                if (this.isInSpace()) {
                    LinkedList<Calendar> tmp = new LinkedList<Calendar>();
                    tmp.addAll(this.getPublicCalendars(CalendarUtils.getCurrentUser()));
                    Map allCals = this.getAllCalendars();
                    for (String calId : this.getOtherSpaceCalendar()) {
                        Calendar calendar = (Calendar)allCals.get(calId);
                        tmp.add(calendar);
                    }
                    for (Calendar cal : tmp) {
                        colors.put(cal.getId(), cal.getCalendarColor());
                    }
                } else {
                    colors = ((UICalendars)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UICalendars.class)).getColorMap();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)"Can not get the color map", (Throwable)e);
            }
        }
        return colors;
    }

    public void refresh() throws Exception {
        this.refresh(false);
    }

    public void refresh(boolean renew) throws Exception {
        List evtInMonth = this.getEventInMonth();
        if (!renew) {
            return;
        }
        evtInMonth.clear();
        JCREventQuery query = new JCREventQuery();
        query.setOwner(CalendarUtils.getCurrentUser());
        java.util.Calendar beginMonth = this.getBeginDateOfMonth();
        beginMonth.add(5, -7);
        query.setFromDate(Long.valueOf(beginMonth.getTimeInMillis()));
        java.util.Calendar cal = this.getEndDateOfMonth();
        cal.add(5, 7);
        cal.add(14, -1);
        query.setToDate(Long.valueOf(cal.getTimeInMillis()));
        LinkedList<String> calendarIds = new LinkedList<String>();
        calendarIds.addAll(this.getPrivateCalendars());
        calendarIds.addAll(Arrays.asList(this.getPublicCalendars()));
        calendarIds.addAll(this.getSharedCalendars());
        calendarIds.addAll(this.getOtherCalendars());
        UICalendarWorkingContainer workingCont = (UICalendarWorkingContainer)this.getAncestorOfType(UICalendarWorkingContainer.class);
        workingCont.init();
        HashMap<String, Calendar> allCals = new HashMap<String, Calendar>();
        for (List cals : this.getCalendars().values()) {
            for (Calendar calendar : cals) {
                allCals.put(calendar.getId(), calendar);
            }
        }
        Iterator iter = calendarIds.iterator();
        while (iter.hasNext()) {
            Calendar calendar = (Calendar)allCals.get(iter.next());
            if (calendar == null || calendar.hasChildren()) continue;
            iter.remove();
        }
        if (calendarIds.size() > 0) {
            query.setCalendarIds(calendarIds.toArray(new String[calendarIds.size()]));
            ListAccess events = this.xCalService.getEventHandler().findEventsByQuery((EventQuery)query);
            for (Event evt : (Event[])events.load(0, -1)) {
                if (evt.getRepeatType() != null && !evt.getRepeatType().equals(Event.RP_NOREPEAT)) {
                    CalendarEvent depEvt = CalendarEvent.build((Event)evt);
                    Map map = CalendarUtils.getCalendarService().getOccurrenceEvents(depEvt, beginMonth, cal, this.getCalendarSetting().getTimeZone());
                    if (map == null) continue;
                    for (CalendarEvent e : map.values()) {
                        evtInMonth.add(e);
                    }
                    continue;
                }
                evtInMonth.add(evt);
            }
        }
    }

    protected void filterNonSpaceEvent(List<Event> allEvents) throws Exception {
        List<String> publicCalendars = Arrays.asList(this.getPublicCalendars());
        List otherSpaceCals = this.getOtherSpaceCalendar();
        Iterator<Event> iter = allEvents.iterator();
        while (iter.hasNext()) {
            Event evt = iter.next();
            if (publicCalendars.contains(evt.getCalendarId()) || otherSpaceCals.contains(evt.getCalendarId())) continue;
            iter.remove();
        }
    }

    public List<Event> getEventInMonth() {
        PortletRequestContext context = (PortletRequestContext)PortletRequestContext.getCurrentInstance();
        LinkedList events = (LinkedList)context.getAttribute("");
        if (events == null) {
            events = new LinkedList();
            context.setAttribute("", events);
            try {
                this.refresh(true);
            }
            catch (Exception e) {
                log.error((Object)"can't refresh calendar view", (Throwable)e);
            }
        }
        return events;
    }

    public List<Event> getEventInMonth(long startTime, long endTime) {
        LinkedList<Event> result = new LinkedList<Event>();
        for (Event evt : this.getEventInMonth()) {
            if (endTime < evt.getFromDateTime().getTime() || startTime > evt.getToDateTime().getTime()) continue;
            evt.setSummary(evt.getSummary().replace("&#39", "'"));
            result.add(evt);
        }
        return result;
    }

    public boolean isInSpace() {
        UICalendarPortlet uiCalendarPortlet = (UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class);
        return uiCalendarPortlet != null ? uiCalendarPortlet.isInSpaceContext() : UICalendarPortlet.isInSpace();
    }

    protected String renderDateTimeString(Date date) {
        SimpleDateFormat dfFormat = new SimpleDateFormat(this.dateTimeFormat_);
        java.util.Calendar cal = (java.util.Calendar)this.calendar_.clone();
        dfFormat.setCalendar(cal);
        return dfFormat.format(date);
    }

    protected String renderDayString(Date date) {
        if (this.dayFormat == null) {
            this.dayFormat = new SimpleDateFormat(this.calendarSetting_.getDateFormat());
            this.dayFormat.setCalendar(this.calendar_);
        }
        return this.dayFormat.format(date);
    }

    protected String renderTimeString(Date date) {
        if (this.timeFormat == null) {
            this.timeFormat = new SimpleDateFormat(this.calendarSetting_.getTimeFormat());
            this.timeFormat.setCalendar(this.calendar_);
        }
        return this.timeFormat.format(date);
    }

    public void update() throws Exception {
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        List eventCategories = calendarService.getEventCategories(username);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        List<String> defaultEvCatId = Arrays.asList(CalendarUtils.getCalendarService().getDefaultEventCategoryIds());
        List<String> defaultEvCatName = Arrays.asList(CalendarUtils.getCalendarService().getDefaultEventCategoryNames());
        for (EventCategory category : eventCategories) {
            if (defaultEvCatId.contains(category.getId()) || defaultEvCatName.contains(category.getName())) {
                String displayName = this.isAnEventCategoryDefaultDisplayName(category.getName()) ? CalendarUtils.getResourceBundle((String)("UICalendarView.label." + category.getId()), (String)category.getName()) : category.getName();
                options.add(new SelectItemOption(displayName, (Object)category.getId()));
                continue;
            }
            options.add(new SelectItemOption(category.getName(), (Object)category.getId()));
        }
        UIFormSelectBox selectBox = this.getUIFormSelectBox(EVENT_CATEGORIES);
        if (selectBox == null) {
            selectBox = new UIFormSelectBox(EVENT_CATEGORIES, EVENT_CATEGORIES, options);
            this.addUIFormInput((UIFormInput)selectBox);
        }
        selectBox.setOptions(options);
        selectBox.setValue("defaultEventCategoryIdAll");
    }

    private boolean isAnEventCategoryDefaultDisplayName(String eventCategoryName) {
        return eventCategoryName.contains("defaultEventCategoryName");
    }

    protected String getSelectedCategory() {
        return (String)this.getUIFormSelectBox(EVENT_CATEGORIES).getValue();
    }

    public void setSelectedCategory(String id) {
        this.getUIFormSelectBox(EVENT_CATEGORIES).setValue(id);
    }

    protected String[] getMonthsName() {
        Locale locale = this.getLocale();
        this.dfs_ = new DateFormatSymbols(locale);
        for (int i = 0; i < this.dfs_.getMonths().length; ++i) {
            this.monthsMap_.put(i, this.dfs_.getMonths()[i]);
        }
        return this.monthsMap_.values().toArray(new String[0]);
    }

    protected String[] getDaysName() {
        Locale locale = this.getLocale();
        this.dfs_ = new DateFormatSymbols(locale);
        for (int i = 1; i < this.dfs_.getWeekdays().length; ++i) {
            this.daysMap_.put(i, this.dfs_.getWeekdays()[i]);
        }
        return this.daysMap_.values().toArray(new String[0]);
    }

    protected java.util.Calendar getDateByValue(int year, int month, int day, int type, int value) {
        GregorianCalendar cl = new GregorianCalendar(year, month, day);
        switch (type) {
            case 0: {
                ((java.util.Calendar)cl).add(5, value);
                break;
            }
            case 1: {
                ((java.util.Calendar)cl).add(3, value);
                break;
            }
            case 2: {
                ((java.util.Calendar)cl).add(2, value);
                break;
            }
        }
        return cl;
    }

    protected int getDaysInMonth() {
        return this.calendar_.getActualMaximum(5);
    }

    protected int getDaysInMonth(int month, int year) {
        GregorianCalendar cal = new GregorianCalendar(year, month, 1);
        return ((java.util.Calendar)cal).getActualMaximum(5);
    }

    protected int getDayOfWeek(int year, int month, int day) {
        GregorianCalendar gc = new GregorianCalendar(year, month, day);
        gc.setFirstDayOfWeek(Integer.parseInt(this.calendarSetting_.getWeekStartOn()));
        return gc.get(7);
    }

    protected String getMonthName(int month) {
        this.getMonthsName();
        return ((String)this.monthsMap_.get(month)).toString();
    }

    protected String getDayName(int day) {
        this.getDaysName();
        return ((String)this.daysMap_.get(day)).toString();
    }

    protected String keyGen(int day, int month, int year) {
        return String.valueOf(day) + CalendarUtils.UNDERSCORE + String.valueOf(month) + CalendarUtils.UNDERSCORE + String.valueOf(year);
    }

    protected void gotoDate(int day, int month, int year) {
        this.setCurrentDay(day);
        this.setCurrentMonth(month);
        this.setCurrentYear(year);
    }

    protected boolean isCurrentDay(int day, int month, int year) {
        java.util.Calendar currentCal = CalendarUtils.getInstanceOfCurrentCalendar();
        boolean isCurrentDay = currentCal.get(5) == day;
        boolean isCurrentMonth = currentCal.get(2) == month;
        boolean isCurrentYear = currentCal.get(1) == year;
        return isCurrentDay && isCurrentMonth && isCurrentYear;
    }

    protected boolean isCurrentWeek(int week, int month, int year) {
        java.util.Calendar currentCal = CalendarUtils.getInstanceOfCurrentCalendar();
        boolean isCurrentWeek = currentCal.get(3) == week;
        boolean isCurrentMonth = currentCal.get(2) == month;
        boolean isCurrentYear = currentCal.get(1) == year;
        return isCurrentWeek && isCurrentMonth && isCurrentYear;
    }

    protected boolean isCurrentMonth(int month, int year) {
        java.util.Calendar currentCal = CalendarUtils.getInstanceOfCurrentCalendar();
        boolean isCurrentMonth = currentCal.get(2) == month;
        boolean isCurrentYear = currentCal.get(1) == year;
        return isCurrentMonth && isCurrentYear;
    }

    protected boolean isSameDate(java.util.Calendar date1, java.util.Calendar date2) {
        return CalendarUtils.isSameDate((java.util.Calendar)date1, (java.util.Calendar)date2);
    }

    protected boolean isSameDate(Date value1, Date value2) {
        return CalendarUtils.isSameDate((Date)value1, (Date)value2);
    }

    public void setCurrentCalendar(java.util.Calendar value) {
        this.calendar_ = value;
    }

    public java.util.Calendar getCurrentCalendar() {
        return this.calendar_;
    }

    protected Date getCurrentDate() {
        return this.calendar_.getTime();
    }

    protected void setCurrentDate(Date value) {
        this.calendar_.setTime(value);
    }

    protected int getCurrentDay() {
        return this.calendar_.get(5);
    }

    protected void setCurrentDay(int day) {
        this.calendar_.set(5, day);
    }

    protected int getCurrentWeek() {
        return this.calendar_.get(3);
    }

    protected void setCurrentWeek(int week) {
        this.calendar_.set(3, week);
    }

    protected int getCurrentMonth() {
        return this.calendar_.get(2);
    }

    protected void setCurrentMonth(int month) {
        this.calendar_.set(2, month);
    }

    protected int getCurrentYear() {
        return this.calendar_.get(1);
    }

    protected void setCurrentYear(int year) {
        this.calendar_.set(1, year);
    }

    protected void moveCalendarTo(int field, int amount) throws Exception {
        this.calendar_.add(field, amount);
    }

    protected void removeEvents(List<CalendarEvent> events) throws Exception {
        CalendarService calService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        OrganizationService orService = CalendarUtils.getOrganizationService();
        for (CalendarEvent ce : events) {
            if (Utils.isOccurrence((CalendarEvent)ce)) {
                CalendarEvent originEvent = calService.getRepetitiveEvent(ce);
                calService.removeOneOccurrenceEvent(originEvent, ce, username);
                continue;
            }
            Calendar cal = null;
            if (CalendarUtils.PUBLIC_TYPE.equals(ce.getCalType())) {
                cal = calService.getGroupCalendar(ce.getCalendarId());
                if (Utils.hasPermission((String[])cal.getEditPermission())) {
                    calService.removePublicEvent(ce.getCalendarId(), ce.getId());
                    continue;
                }
                this.allDelete_ = false;
                continue;
            }
            if (CalendarUtils.PRIVATE_TYPE.equals(ce.getCalType())) {
                calService.removeUserEvent(username, ce.getCalendarId(), ce.getId());
                continue;
            }
            if (!CalendarUtils.SHARED_TYPE.equals(ce.getCalType())) continue;
            cal = calService.getSharedCalendars(username, true).getCalendarById(ce.getCalendarId());
            if (Utils.hasPermission((String[])Utils.getEditPerUsers((Calendar)cal))) {
                calService.removeSharedEvent(username, ce.getCalendarId(), ce.getId());
                continue;
            }
            this.allDelete_ = false;
        }
    }

    protected void moveEvents(List<CalendarEvent> events, String toCalendarId, String toType) throws Exception {
        CalendarService calService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        for (CalendarEvent ce : events) {
            ArrayList<CalendarEvent> list = new ArrayList<CalendarEvent>();
            list.add(ce);
            if (!CalendarEvent.RP_NOREPEAT.equals(ce.getRepeatType()) && !CalendarUtils.isEmpty((String)ce.getRecurrenceId())) {
                calService.updateOccurrenceEvent(ce.getCalendarId(), ce.getCalendarId(), ce.getCalType(), ce.getCalType(), list, username);
                continue;
            }
            calService.moveEvent(ce.getCalendarId(), ce.getCalendarId(), ce.getCalType(), ce.getCalType(), list, username);
        }
    }

    protected java.util.Calendar getBeginDay(java.util.Calendar cal) {
        return CalendarUtils.getBeginDay((java.util.Calendar)cal);
    }

    protected java.util.Calendar getEndDay(java.util.Calendar cal) {
        return CalendarUtils.getEndDay((java.util.Calendar)cal);
    }

    protected String[] getContextMenu() {
        return CONTEXT_MENU;
    }

    protected String[] getQuickEditMenu() {
        return QUICKEDIT_MENU;
    }

    protected List<String> getDisplayTimes(String timeFormat, int timeInterval) {
        ArrayList<String> displayTimes_ = new ArrayList<String>();
        java.util.Calendar cal = CalendarUtils.getInstanceOfCurrentCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        SimpleDateFormat df = new SimpleDateFormat(timeFormat);
        df.setCalendar(cal);
        for (int i = 0; i < 24 * (60 / timeInterval); ++i) {
            displayTimes_.add(df.format(cal.getTime()));
            cal.add(12, timeInterval);
        }
        return displayTimes_;
    }

    protected List<String> getDisplayTimes(String timeFormat, int timeInterval, Locale locale) {
        ArrayList<String> displayTimes = new ArrayList<String>();
        java.util.Calendar cal = java.util.Calendar.getInstance(locale);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        SimpleDateFormat valuedf = new SimpleDateFormat(CalendarUtils.TIMEFORMAT, locale);
        SimpleDateFormat df = new SimpleDateFormat(timeFormat, locale);
        for (int i = 0; i < 24 * (60 / timeInterval); ++i) {
            displayTimes.add(valuedf.format(cal.getTime()) + "_" + df.format(cal.getTime()));
            cal.add(12, timeInterval);
        }
        return displayTimes;
    }

    protected Map<String, String> getTimeSteps(String timeFormat, int timeInterval) {
        if (this.timeSteps_ == null) {
            this.timeSteps_ = new LinkedHashMap();
            java.util.Calendar cal = CalendarUtils.getInstanceOfCurrentCalendar();
            cal.setTime(this.getCurrentDate());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(14, 0);
            SimpleDateFormat df = new SimpleDateFormat(timeFormat);
            df.setCalendar(cal);
            for (int i = 0; i < 24 * (60 / timeInterval); ++i) {
                this.timeSteps_.put(String.valueOf(cal.getTimeInMillis()), df.format(cal.getTime()));
                cal.add(12, timeInterval);
            }
        }
        return this.timeSteps_;
    }

    protected String getDateFormat() {
        return this.calendarSetting_.getDateFormat();
    }

    protected String getDateTimeFormat() {
        return this.dateTimeFormat_;
    }

    protected int getTimeInterval() {
        return this.timeInterval_;
    }

    protected int getDefaultTimeInterval() {
        return 15;
    }

    protected String getTimeFormat() {
        return this.calendarSetting_.getTimeFormat();
    }

    public void setCalendarSetting(CalendarSetting calendarSetting_) {
        this.calendarSetting_ = calendarSetting_;
    }

    public CalendarSetting getCalendarSetting() {
        return this.calendarSetting_;
    }

    public boolean isShowWorkingTime() {
        return this.calendarSetting_.isShowWorkingTime();
    }

    public String getStartTime() {
        if (this.calendarSetting_.isShowWorkingTime()) {
            return this.calendarSetting_.getWorkingTimeBegin();
        }
        return "";
    }

    public String getEndTime() {
        if (this.calendarSetting_.isShowWorkingTime()) {
            return this.calendarSetting_.getWorkingTimeEnd();
        }
        return "";
    }

    public String getPriority(String key) {
        return (String)this.priorityMap_.get(key);
    }

    public String getLabel(String arg) {
        if (CalendarUtils.isEmpty((String)arg)) {
            return "";
        }
        try {
            return super.getLabel(arg);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Can not get the label: " + arg + " from the resource bundle"), (Throwable)e);
            }
            return arg;
        }
    }

    public void processRender(WebuiRequestContext arg0) throws Exception {
        if (!(this instanceof UIListView)) {
            this.refresh();
        }
        super.processRender(arg0);
    }

    public List<CalendarEvent> getSelectedEvents(String eventIds) throws Exception {
        String[] list = eventIds.split(",");
        ArrayList<CalendarEvent> dataList = new ArrayList<CalendarEvent>();
        for (int i = 0; i < list.length; ++i) {
            CalendarEvent evt = CalendarEvent.build((Event)((Event)this.getDataMap().get(list[i])));
            dataList.add(evt);
        }
        return dataList;
    }

    public Map<String, Map<String, CalendarEvent>> getRecurrenceMap() {
        return this.recurrenceEventsMap;
    }

    public void setCurrentOccurrence(CalendarEvent currentOccurrence) {
        this.currentOccurrence = currentOccurrence;
    }

    public CalendarEvent getcurrentOccurrence() {
        return this.currentOccurrence;
    }

    public java.util.Calendar getBeginDateOfMonth() throws Exception {
        java.util.Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.set(5, 1);
        return CalendarUtils.getBeginDay((java.util.Calendar)temCal);
    }

    public java.util.Calendar getEndDateOfMonth() throws Exception {
        java.util.Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        temCal.set(5, this.getDaysInMonth());
        return CalendarUtils.getEndDay((java.util.Calendar)temCal);
    }

    private boolean isHaveNotPermission(Calendar calendar, String calType) throws Exception {
        return CalendarUtils.SHARED_TYPE.equals(calType) && !Utils.hasPermission((String[])Utils.getEditPerUsers((Calendar)calendar)) || CalendarUtils.PUBLIC_TYPE.equals(calType) && !Utils.hasPermission((String[])calendar.getEditPermission());
    }

    public String getDateTimeString(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(this.dateTimeFormat_, this.getLocale());
        df.setTimeZone(DateUtils.getTimeZone((String)this.getTimeZone()));
        return df.format(date);
    }

    private Locale getLocale() {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        return locale;
    }

    private String getTimeZone() {
        return this.calendarSetting_.getTimeZone();
    }

    static /* synthetic */ String access$000(UICalendarView x0) {
        return x0.singleDeletedCalendarId;
    }

    static /* synthetic */ String access$100(UICalendarView x0) {
        return x0.singleDeletedEventId;
    }

    static /* synthetic */ String access$200(UICalendarView x0) {
        return x0.singleDeletedEventType;
    }

    static /* synthetic */ Log access$300() {
        return log;
    }

    static /* synthetic */ String access$102(UICalendarView x0, String x1) {
        x0.singleDeletedEventId = x1;
        return x0.singleDeletedEventId;
    }

    static /* synthetic */ String access$002(UICalendarView x0, String x1) {
        x0.singleDeletedCalendarId = x1;
        return x0.singleDeletedCalendarId;
    }

    static /* synthetic */ String access$202(UICalendarView x0, String x1) {
        x0.singleDeletedEventType = x1;
        return x0.singleDeletedEventType;
    }

    static /* synthetic */ boolean access$402(UICalendarView x0, boolean x1) {
        x0.allDelete_ = x1;
        return x0.allDelete_;
    }

    static /* synthetic */ boolean access$400(UICalendarView x0) {
        return x0.allDelete_;
    }

    static /* synthetic */ boolean access$500(UICalendarView x0, Calendar x1, String x2) throws Exception {
        return x0.isHaveNotPermission(x1, x2);
    }
}

