/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.model.query.EventQuery;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.ExtendedCalendarService;
import org.exoplatform.calendar.webui.UIActionBar;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UICalendarViewContainer;
import org.exoplatform.calendar.webui.UICalendarWorkingContainer;
import org.exoplatform.calendar.webui.UICalendars;
import org.exoplatform.calendar.webui.UIFormColorPicker;
import org.exoplatform.calendar.webui.UIListContainer;
import org.exoplatform.calendar.webui.UIListView;
import org.exoplatform.calendar.webui.UISearchForm;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UICalendars.gtmpl", events={@EventConfig(listeners={AddCalendarActionListener.class}), @EventConfig(listeners={AddEventCategoryActionListener.class}), @EventConfig(listeners={ExportCalendarActionListener.class}), @EventConfig(listeners={ExportCalendarsActionListener.class}), @EventConfig(listeners={ImportCalendarActionListener.class}), @EventConfig(listeners={AddEventActionListener.class}), @EventConfig(listeners={AddTaskActionListener.class}), @EventConfig(listeners={EditCalendarActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RemoveCalendarActionListener.class}), @EventConfig(listeners={ConfirmCloseActionListener.class}), @EventConfig(listeners={AbortCloseActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RemoveSharedCalendarActionListener.class}), @EventConfig(listeners={ChangeColorActionListener.class}), @EventConfig(listeners={TickActionListener.class}), @EventConfig(listeners={CalendarSettingActionListener.class}), @EventConfig(listeners={RemoteCalendarActionListener.class}), @EventConfig(listeners={RefreshRemoteCalendarActionListener.class}), @EventConfig(listeners={ShareCalendarActionListener.class})})
public class UICalendars
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger(UICalendars.class);
    public static String CALENDARID = "calendarid".intern();
    public static String CALTYPE = "calType".intern();
    public static String CALNAME = "calName".intern();
    public static String CALCOLOR = "calColor".intern();
    private boolean isShowTaskList_ = false;
    private String removed_cal_id = null;
    private String calType = CalendarUtils.SHARED_TYPE;
    private ExtendedCalendarService xCalService = (ExtendedCalendarService)this.getApplicationComponent(ExtendedCalendarService.class);

    public void processRender(WebuiRequestContext arg0) throws Exception {
        this.init();
        super.processRender(arg0);
    }

    public void init() throws Exception {
        List<Object> invisibleCalendars = new ArrayList();
        SettingService settingService = (SettingService)this.getApplicationComponent(SettingService.class);
        SettingValue value = settingService.get(Context.USER, Scope.APPLICATION.id("Calendar"), "InvisibleCalendars");
        if (value != null) {
            String invisibleCalendarsValue = (String)value.getValue();
            invisibleCalendars = Arrays.asList(invisibleCalendarsValue.split(","));
        }
        Map tmp = this.getCalendars();
        for (List cals : tmp.values()) {
            for (Calendar calendar : cals) {
                this.initCheckBox(calendar, invisibleCalendars.contains(calendar.getId()));
            }
        }
    }

    private void initCheckBox(Calendar calendar, boolean invisible) {
        UICheckBoxInput checkbox = this.getUICheckBoxInput(calendar.getId());
        if (checkbox == null) {
            checkbox = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(false));
            this.addUIFormInput((UIFormInput)checkbox);
        }
        if (invisible) {
            checkbox.setChecked(false);
        } else {
            checkbox.setChecked(this.isCalendarOfSpace(calendar));
        }
    }

    public Map<String, List<Calendar>> getCalendars() {
        UICalendarWorkingContainer container = (UICalendarWorkingContainer)this.getAncestorOfType(UICalendarWorkingContainer.class);
        return container.getCalendarMap();
    }

    public String getLabel(String key) {
        try {
            return super.getLabel(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    public void checkAll() {
        if (!((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).getSpaceGroupId().equals("")) {
            for (UIComponent component : this.getChildren()) {
                for (Calendar cal : this.getAllPublicCalendars()) {
                    if (!cal.getId().equals(component.getId()) || this.getUICheckBoxInput(component.getId()) == null) continue;
                    this.getUICheckBoxInput(component.getId()).setChecked(this.isCalendarOfSpace(cal));
                }
            }
        } else {
            for (UIComponent cpm : this.getChildren()) {
                this.getUICheckBoxInput(cpm.getId()).setChecked(true);
            }
        }
    }

    public List<String> getCheckedCalendars() {
        ArrayList<String> list = new ArrayList<String>();
        for (UIComponent cpm : this.getChildren()) {
            UICheckBoxInput checkbox;
            if (!(cpm instanceof UICheckBoxInput) || !(checkbox = (UICheckBoxInput)cpm).isChecked()) continue;
            list.add(cpm.getId());
        }
        return list;
    }

    public EventQuery getEventQuery(EventQuery eventQuery) throws Exception {
        List checkedCals = this.getCheckedCalendars();
        ArrayList<String> calendarIds = new ArrayList<String>();
        for (Calendar cal : this.getAllPrivateCalendars()) {
            if (!checkedCals.contains(cal.getId())) continue;
            calendarIds.add(cal.getId());
        }
        for (Calendar calendar : this.getAllPublicCalendars()) {
            if (!checkedCals.contains(calendar.getId())) continue;
            calendarIds.add(calendar.getId());
        }
        for (Calendar cal : this.getAllSharedCalendars()) {
            if (!checkedCals.contains(cal.getId())) continue;
            calendarIds.add(cal.getId());
        }
        for (Calendar cal : this.getAllOtherCalendars()) {
            if (!checkedCals.contains(cal.getId())) continue;
            calendarIds.add(cal.getId());
        }
        if (calendarIds.size() > 0) {
            eventQuery.setCalendarIds(calendarIds.toArray(new String[0]));
        } else {
            eventQuery.setCalendarIds(new String[]{"null"});
        }
        eventQuery.setOrderBy(new String[]{"exo:summary"});
        return eventQuery;
    }

    private boolean hasNoCalendarShown() throws Exception {
        int privateCalendars = this.getAllPrivateCalendars().size();
        int sharedCalendars = this.getAllSharedCalendars().size();
        int publicCalendars = this.getAllPublicCalendars().size();
        int othersCalendars = this.getAllOtherCalendars().size();
        return privateCalendars == 0 && sharedCalendars == 0 && publicCalendars == 0 && othersCalendars == 0;
    }

    private boolean hasNoSpaceCalendarShown() {
        try {
            UICalendarPortlet calendarPortlet = (UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class);
            if (!calendarPortlet.isInSpaceContext()) {
                return false;
            }
            List publicCalendars = this.getAllPublicCalendars();
            if (publicCalendars.size() == 0) {
                return true;
            }
            for (Calendar c : publicCalendars) {
                if (!this.isCalendarOfSpace(c)) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public List<Calendar> getAllPrivateCalendars() {
        return this.filterHidden((List)this.getCalendars().get(Calendar.Type.PERSONAL.name()));
    }

    private List<Calendar> filterHidden(List<Calendar> calendars) {
        LinkedList<Calendar> result = new LinkedList<Calendar>();
        if (calendars != null && !calendars.isEmpty()) {
            CalendarService calService = (CalendarService)this.getApplicationComponent(CalendarService.class);
            HashSet filterCals = new HashSet();
            try {
                CalendarSetting settings = calService.getCalendarSetting(CalendarUtils.getCurrentUser());
                filterCals.addAll(settings.getFilterCalendars());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            for (Calendar cal : calendars) {
                if (filterCals.contains(cal.getId())) continue;
                result.add(cal);
            }
        }
        return result;
    }

    public List<Calendar> getAllSharedCalendars() {
        return this.filterHidden((List)this.getCalendars().get(Calendar.Type.SHARED.name()));
    }

    public List<Calendar> getAllOtherCalendars() {
        LinkedList cals = new LinkedList();
        HashSet<String> typeNames = new HashSet<String>();
        for (Calendar.Type t : Calendar.Type.values()) {
            if (Calendar.Type.UNDEFINED.equals((Object)t)) continue;
            typeNames.add(t.name());
        }
        for (String type : this.getCalendars().keySet()) {
            if (typeNames.contains(type)) continue;
            cals.addAll((Collection)this.getCalendars().get(type));
        }
        return this.filterHidden(cals);
    }

    protected boolean isCalendarOfSpace(Calendar calendar) {
        String spaceGroupId;
        UICalendarPortlet calendarPortlet = (UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class);
        UICalendarView calView = (UICalendarView)calendarPortlet.findFirstComponentOfType(UICalendarView.class);
        HashSet otherCals = new HashSet();
        try {
            otherCals.addAll(calView.getOtherSpaceCalendar());
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        if (otherCals.contains(calendar.getId())) {
            return true;
        }
        String[] groupIds = calendar.getGroups();
        String string = spaceGroupId = calendarPortlet != null ? calendarPortlet.getSpaceGroupId() : UICalendarPortlet.getGroupIdOfSpace();
        if (spaceGroupId.equals("")) {
            return true;
        }
        if (groupIds == null) {
            return false;
        }
        for (String groupId : groupIds) {
            if (!spaceGroupId.equals(groupId)) continue;
            return true;
        }
        return false;
    }

    private UIActionBar getUIActionBar() {
        return (UIActionBar)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).getChild(UIActionBar.class);
    }

    private boolean hasFilteredCalendar() throws Exception {
        UICalendarPortlet portlet = (UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class);
        CalendarSetting calendarSetting = portlet.getCalendarSetting();
        return calendarSetting.getFilterPrivateCalendars().length != 0 || calendarSetting.getFilterSharedCalendars().length != 0 || calendarSetting.getFilterPublicCalendars().length != 0;
    }

    public List<Calendar> getAllPublicCalendars() {
        return this.filterHidden((List)this.getCalendars().get(Calendar.Type.GROUP.name()));
    }

    private String truncateLongName(String longName) {
        if (longName.length() < 17) {
            return longName;
        }
        int secondWhiteSpacePos = this.getPositionOfSecondWhiteSpaceFrom(longName);
        if (-1 < secondWhiteSpacePos && secondWhiteSpacePos < 20) {
            return longName.substring(0, secondWhiteSpacePos);
        }
        if (longName.length() > 20) {
            return longName.substring(0, 17) + "...";
        }
        return longName;
    }

    private int getPositionOfSecondWhiteSpaceFrom(String name) {
        int firstWhiteSpacePos = name.indexOf(" ");
        if (firstWhiteSpacePos == -1) {
            return -1;
        }
        int secondWhiteSpacePos = name.indexOf(" ", firstWhiteSpacePos + 1);
        if (secondWhiteSpacePos == -1) {
            return -1;
        }
        return secondWhiteSpacePos;
    }

    public Map<String, String> getColorMap() {
        UICalendarWorkingContainer container = (UICalendarWorkingContainer)this.getAncestorOfType(UICalendarWorkingContainer.class);
        return container.getColorMap();
    }

    public String[] getColors() {
        return UIFormColorPicker.Colors.COLORNAMES;
    }

    private void updateView(UICalendars uiComponent, Event<UICalendars> event) throws Exception {
        UIListContainer list;
        UIListView uiListView;
        UICalendarPortlet uiPortlet = (UICalendarPortlet)uiComponent.getAncestorOfType(UICalendarPortlet.class);
        UICalendarViewContainer uiViewContainer = (UICalendarViewContainer)uiPortlet.findFirstComponentOfType(UICalendarViewContainer.class);
        if (uiViewContainer.getRenderedChild() instanceof UIListContainer && (uiListView = (UIListView)(list = (UIListContainer)uiViewContainer.getRenderedChild()).getChild(UIListView.class)).isDisplaySearchResult()) {
            uiListView.setDisplaySearchResult(false);
            uiListView.setCategoryId(null);
            uiListView.refresh();
            uiListView.setLastViewId(null);
            UISearchForm uiSearchForm = (UISearchForm)uiPortlet.findFirstComponentOfType(UISearchForm.class);
            uiSearchForm.reset();
            UIActionBar uiActionBar = (UIActionBar)uiPortlet.findFirstComponentOfType(UIActionBar.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSearchForm);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionBar);
        }
    }

    static /* synthetic */ ExtendedCalendarService access$000(UICalendars x0) {
        return x0.xCalService;
    }

    static /* synthetic */ String access$100(UICalendars x0) {
        return x0.removed_cal_id;
    }

    static /* synthetic */ String access$200(UICalendars x0) {
        return x0.calType;
    }

    static /* synthetic */ void access$300(UICalendars x0, UICalendars x1, Event x2) throws Exception {
        x0.updateView(x1, x2);
    }

    static /* synthetic */ String access$102(UICalendars x0, String x1) {
        x0.removed_cal_id = x1;
        return x0.removed_cal_id;
    }

    static /* synthetic */ String access$202(UICalendars x0, String x1) {
        x0.calType = x1;
        return x0.calType;
    }

    static /* synthetic */ Log access$400() {
        return LOG;
    }
}

