/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.search.data;

import java.util.Map;
import org.apache.commons.collections.map.HashedMap;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;

public class SearchContext {
    private static Log log = ExoLogger.getExoLogger(SearchContext.class);
    private Router router;
    private Map<QualifiedName, String> qualifiedName = null;

    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router router) {
        this.router = router;
    }

    public SearchContext(Router router) {
        this.router = router;
        this.qualifiedName = new HashedMap();
    }

    public SearchContext handler(String value) {
        this.qualifiedName.put(RouterParams.HANDLER.create(), value);
        return this;
    }

    public SearchContext lang(String value) {
        this.qualifiedName.put(RouterParams.LANG.create(), value);
        return this;
    }

    public SearchContext path(String value) {
        this.qualifiedName.put(RouterParams.PATH.create(), value);
        return this;
    }

    public SearchContext siteType(String value) {
        this.qualifiedName.put(RouterParams.SITE_TYPE.create(), value);
        return this;
    }

    public SearchContext siteName(String value) {
        this.qualifiedName.put(RouterParams.SITE_NAME.create(), value);
        return this;
    }

    public String renderLink() throws Exception {
        if (!this.qualifiedName.containsKey(RouterParams.LANG.create())) {
            this.lang("");
        }
        if (!this.qualifiedName.containsKey(RouterParams.HANDLER.create())) {
            log.warn((Object)"Handler of QualifiedName not found!");
        }
        if (!this.qualifiedName.containsKey(RouterParams.SITE_NAME.create())) {
            log.warn((Object)"SiteName of QualifiedName not found!");
        }
        if (!this.qualifiedName.containsKey(RouterParams.SITE_TYPE.create())) {
            log.warn((Object)"SiteType of QualifiedName not found!");
        }
        return this.router.render(this.qualifiedName);
    }

    public static enum RouterParams {
        SITE_TYPE("sitetype"),
        SITE_NAME("sitename"),
        HANDLER("handler"),
        PATH("path"),
        LANG("lang");

        private static final String PREFIX = "gtn";
        private String paramName = null;

        private RouterParams(String paramName) {
            this.paramName = paramName;
        }

        public QualifiedName create() {
            return QualifiedName.create((String)PREFIX, (String)this.paramName);
        }
    }
}

