/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.plugin;

import groovy.text.Template;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.organization.OrganizationService;

public abstract class AbstractNotificationPlugin
extends BaseNotificationPlugin {
    List<PluginConfig> pluginConfig = new ArrayList<PluginConfig>();
    private Template engine;

    public AbstractNotificationPlugin(InitParams initParams) {
        super(initParams);
        this.setOldPlugin(true);
    }

    protected abstract MessageInfo makeMessage(NotificationContext var1);

    protected abstract boolean makeDigest(NotificationContext var1, Writer var2);

    public MessageInfo buildMessage(NotificationContext ctx) {
        NotificationInfo message = ctx.getNotificationInfo();
        MessageInfo messageInfo = this.makeMessage(ctx);
        return messageInfo.pluginId(this.getId()).from(NotificationPluginUtils.getFrom(message.getFrom())).to(NotificationPluginUtils.getTo(message.getTo())).end();
    }

    public boolean buildDigest(NotificationContext ctx, Writer writer) {
        return this.makeDigest(ctx, writer);
    }

    @Override
    public PluginKey getKey() {
        return PluginKey.key(this);
    }

    protected String getLanguage(NotificationInfo message) {
        return NotificationPluginUtils.getLanguage(message.getTo());
    }

    @Override
    protected OrganizationService getOrganizationService() {
        return NotificationPluginUtils.getOrganizationService();
    }

    public Template getTemplateEngine() {
        return this.engine;
    }

    public void setTemplateEngine(Template engine) {
        this.engine = engine;
    }
}

