/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.http.PATCH;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.services.security.ConversationState;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="notifications/webNotifications")
@Tag(name="notifications/webNotifications", description="Manage web notifications")
public class WebNotificationRestService
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WebNotificationRestService.class);
    private WebNotificationService webNftService;

    public WebNotificationRestService(WebNotificationService webNftService) {
        this.webNftService = webNftService;
    }

    @GET
    @RolesAllowed(value={"users"})
    @Produces(value={"application/json"})
    @Operation(summary="Get notifications list", description="This gets the list of the notifications", method="GET")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Notifications list returned"), @ApiResponse(responseCode="404", description="Notifications list not found"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response getNotifications() throws Exception {
        int maxItemsInPopover = NotificationMessageUtils.getMaxItemsInPopover();
        JSONArray notificationsJsonArray = new JSONArray();
        JSONObject response = new JSONObject();
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        if (currentUser == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        List<String> notifications = this.webNftService.get(new WebNotificationFilter(currentUser, true), 0, maxItemsInPopover);
        for (String notification : notifications) {
            JSONObject notificationJsonObject = new JSONObject();
            notificationJsonObject.put("notification", (Object)notification);
            notificationsJsonArray.put((Object)notificationJsonObject);
        }
        int badge = this.webNftService == null ? 0 : this.webNftService.getNumberOnBadge(currentUser);
        response.put("notifications", (Object)notificationsJsonArray);
        response.put("badge", badge);
        return Response.ok((Object)response.toString(), (String)"application/json").build();
    }

    @PATCH
    @Path(value="{id}")
    @Consumes(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @Operation(summary="Update notification", description="Perform some patch operations on notifications", method="PATCH")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Notification updated"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response updateNotifications(@Parameter(description="notification operation", required=true) String operation, @Parameter(description="notification id", required=true) @PathParam(value="id") String notificationId) {
        String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
        try {
            NotificationInfo notification;
            if (operation == null) {
                LOG.warn((Object)"Notification operation should be not null");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            if (currentUser == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            if (operation.equals("markAsRead")) {
                if (notificationId == null) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                notification = this.webNftService.getNotificationInfo(notificationId);
                if (currentUser.equals(notification.getTo())) {
                    this.webNftService.markRead(notificationId);
                } else {
                    LOG.warn("User {} is not allowed to mark notification {} as read", new Object[]{currentUser, notificationId});
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
            }
            if (operation.equals("hide")) {
                if (notificationId == null) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                notification = this.webNftService.getNotificationInfo(notificationId);
                if (currentUser.equals(notification.getTo())) {
                    this.webNftService.hidePopover(notificationId);
                } else {
                    LOG.warn("User {} is not allowed to hide notification {}", new Object[]{currentUser, notificationId});
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
                }
            }
            if (operation.equals("resetNew")) {
                this.webNftService.resetNumberOnBadge(currentUser);
            }
            if (operation.equals("markAllAsRead")) {
                this.webNftService.markAllRead(currentUser);
                this.webNftService.resetNumberOnBadge(currentUser);
            }
            return Response.noContent().build();
        }
        catch (Exception e) {
            LOG.error("Error when trying to patch operation {}  on notification {} for user {}", new Object[]{operation, notificationId, currentUser, e});
            return Response.serverError().build();
        }
    }
}

