/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.plugin;

import java.util.Locale;
import java.util.regex.Matcher;
import org.exoplatform.commons.api.notification.NotificationConstants;
import org.exoplatform.commons.utils.MailUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.exoplatform.services.resources.LocalePolicy;

public class NotificationPluginUtils {
    public static String getPortalName() {
        return NotificationPluginUtils.getExoContainerContext().getPortalContainerName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFirstName(String userName) {
        NotificationPluginUtils.startRequest(NotificationPluginUtils.getOrganizationService());
        User user = null;
        try {
            UserHandler userHandler = NotificationPluginUtils.getOrganizationService().getUserHandler();
            user = userHandler.findUserByName(userName);
            String string = user.getFirstName();
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            NotificationPluginUtils.endRequest(NotificationPluginUtils.getOrganizationService());
        }
    }

    private static ExoContainerContext getExoContainerContext() {
        return (ExoContainerContext)PortalContainer.getInstance().getComponentInstanceOfType(ExoContainerContext.class);
    }

    public static String getFullName(String userId) {
        NotificationPluginUtils.startRequest(NotificationPluginUtils.getOrganizationService());
        try {
            User user = NotificationPluginUtils.getOrganizationService().getUserHandler().findUserByName(userId);
            String string = NotificationPluginUtils.getFullName(user);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            NotificationPluginUtils.endRequest(NotificationPluginUtils.getOrganizationService());
        }
    }

    private static String getFullName(User user) {
        StringBuilder userInfor = new StringBuilder();
        String displayName = user.getDisplayName();
        if (displayName == null || displayName.length() == 0) {
            userInfor.append(user.getFirstName()).append(" ").append(user.getLastName());
        } else {
            userInfor.append(displayName);
        }
        return userInfor.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getEmailFormat(String userId) {
        NotificationPluginUtils.startRequest(NotificationPluginUtils.getOrganizationService());
        try {
            User user = NotificationPluginUtils.getOrganizationService().getUserHandler().findUserByName(userId);
            StringBuilder userInfor = new StringBuilder(NotificationPluginUtils.getFullName(user));
            userInfor.append("<").append(user.getEmail()).append(">");
            String string = userInfor.toString();
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            NotificationPluginUtils.endRequest(NotificationPluginUtils.getOrganizationService());
        }
    }

    public static String getFrom(String from) {
        if (from != null && from.length() > 0 && from.indexOf("@") > 0) {
            return from;
        }
        return new StringBuffer(MailUtils.getSenderName()).append("<").append(MailUtils.getSenderEmail()).append(">").toString();
    }

    public static String getBrandingPortalName() {
        return NotificationPluginUtils.getBrandingService().getCompanyName();
    }

    public static String getTo(String to) {
        return NotificationPluginUtils.isValidEmail(to) ? to : NotificationPluginUtils.getEmailFormat(to);
    }

    public static boolean isValidEmail(String to) {
        Matcher matcher = NotificationConstants.EMAIL_PATTERN.matcher(to.trim());
        return matcher.find();
    }

    public static String getLanguage(String userId) {
        LocaleContextInfo localeCtx = LocaleContextInfoUtils.buildLocaleContextInfo((String)userId);
        LocalePolicy localePolicy = (LocalePolicy)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(LocalePolicy.class);
        String lang = null;
        if (localePolicy != null) {
            Locale locale = localePolicy.determineLocale(localeCtx);
            lang = locale.toString();
        }
        return lang;
    }

    public static OrganizationService getOrganizationService() {
        return (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
    }

    public static BrandingService getBrandingService() {
        return (BrandingService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(BrandingService.class);
    }

    private static void startRequest(Object service) {
        if (service instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)((ComponentRequestLifecycle)service));
        }
    }

    private static void endRequest(Object service) {
        if (service instanceof ComponentRequestLifecycle) {
            RequestLifeCycle.end();
        }
    }
}

