/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.exoplatform.common.http.client.CookieModule;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.CMessage;
import org.exoplatform.ws.frameworks.cometd.CMessages;
import org.exoplatform.ws.frameworks.cometd.CargoContainer;
import org.exoplatform.ws.frameworks.cometd.TestTools;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LocalCometdTest
extends TestCase {
    private static final Log LOG = ExoLogger.getLogger(LocalCometdTest.class);
    private String baseCometdURI;
    private String baseURI;
    private String connectionType = "long-polling";
    private URL url;
    private int clients;
    private int repeat;
    private long sleepConnect;
    private long sleepSend;
    private long timeout;
    private int messages;
    private int totalI = 0;
    private Integer totalB = 0;
    private List<String> channels = new ArrayList<String>();
    private HashMap<String, String> individuals = new HashMap();
    private HashMap<String, String> broadcasts = new HashMap();
    private InstalledLocalContainer container;
    private boolean startContainer;

    protected void setUp() throws Exception {
        int i;
        super.setUp();
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(((Object)((Object)this)).getClass().getResourceAsStream("/conf/cometd-test-conf.xml"));
        Node cont = document.getElementsByTagName("container").item(0);
        NamedNodeMap map = cont.getAttributes();
        this.startContainer = Boolean.parseBoolean(map.getNamedItem("containerStart").getTextContent());
        if (!this.startContainer) {
            String port = map.getNamedItem("port").getTextContent();
            String home = map.getNamedItem("home").getTextContent();
            this.container = CargoContainer.cargoContainerStart(port, home);
        }
        map = document.getElementsByTagName("configuration").item(0).getAttributes();
        this.clients = Integer.parseInt(map.getNamedItem("clients").getTextContent());
        this.repeat = Integer.parseInt(map.getNamedItem("repeat").getTextContent());
        this.sleepConnect = Long.parseLong(map.getNamedItem("sleep-connection").getTextContent());
        this.sleepSend = Long.parseLong(map.getNamedItem("sleep-sending").getTextContent());
        NodeList nodeList = document.getElementsByTagName("channel");
        for (i = 0; i < nodeList.getLength(); ++i) {
            this.channels.add(nodeList.item(i).getTextContent());
        }
        nodeList = document.getElementsByTagName("message");
        for (i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            String id_ = namedNodeMap.getNamedItem("id").getTextContent();
            Boolean broadcast = new Boolean(namedNodeMap.getNamedItem("broadcast").getTextContent());
            if (broadcast.booleanValue()) {
                this.broadcasts.put(id_, nodeList.item(i).getTextContent());
                continue;
            }
            this.individuals.put(id_, nodeList.item(i).getTextContent());
        }
        this.baseCometdURI = document.getElementsByTagName("cometd-url").item(0).getTextContent();
        this.baseURI = document.getElementsByTagName("base-url").item(0).getTextContent();
        this.messages = (this.individuals.size() + this.broadcasts.size()) * this.repeat;
    }

    private String cometdConnect(String id) {
        try {
            String eXoId = id;
            String userToken = TestTools.getUserToken(this.baseURI + "continuation/gettoken/" + id + "/");
            String initData = "message={\"channel\":\"/meta/connect\",\"clientId\":\"1\",\"connectionType\":\"long-polling\",\"id\":0}";
            NVPair[] pairs = new NVPair[5];
            pairs[0] = new NVPair("Keep-Alive", "300");
            pairs[1] = new NVPair("Connection", "keep-alive");
            pairs[2] = new NVPair("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            pairs[3] = new NVPair("Content-Length", Integer.toString(initData.length()));
            this.url = new URL(this.baseCometdURI);
            LOG.info((Object)("LocalCometdTest.cometdConnect()" + String.valueOf(this.url)));
            HTTPConnection connection = new HTTPConnection(this.url);
            connection.removeModule(CookieModule.class);
            HTTPResponse response = connection.Post(this.url.getFile(), initData.getBytes(), pairs);
            String bayeuxCookie = response.getHeader("Set-Cookie").split(";")[0];
            LocalCometdTest.assertNotNull((Object)bayeuxCookie);
            String dataHandshake = "message={\"channel\":\"/meta/handshake\",\"id\":1,\"exoId\":\"" + eXoId + "\",\"exoToken\":\"" + userToken + "\"}";
            LOG.info((Object)("LocalCometdTest.cometdConnect()" + dataHandshake));
            pairs[3] = new NVPair("Content-Length", Integer.toString(dataHandshake.length()));
            pairs[4] = new NVPair("Cookie", bayeuxCookie);
            response = connection.Post(this.url.getFile(), dataHandshake.getBytes(), pairs);
            String string = new String(response.getData());
            LOG.info((Object)("LocalCometdTest.cometdConnect()" + string));
            CMessage incomMessage = TestTools.stringToCMessage(string);
            LocalCometdTest.assertNotNull((Object)incomMessage);
            this.timeout = incomMessage.getAdvice().getTimeout();
            String clientId = incomMessage.getClientId();
            LocalCometdTest.assertNotNull((Object)clientId);
            LocalCometdTest.assertTrue((boolean)incomMessage.getSuccessful());
            String dataConnect = "message={\"channel\":\"/meta/connect\",\"clientId\":\"" + clientId + "\",\"connectionType\":\"" + this.connectionType + "\",\"id\":2}";
            pairs[3] = new NVPair("Content-Length", Integer.toString(dataConnect.length()));
            response = connection.Post(this.url.getFile(), dataConnect.getBytes(), pairs);
            incomMessage = TestTools.stringToCMessage(new String(response.getData()));
            LocalCometdTest.assertTrue((boolean)incomMessage.getSuccessful());
            Object dataSub = "message=[";
            for (String channel : this.channels) {
                dataSub = ((String)dataSub).concat("{\"channel\":\"/meta/subscribe\",\"subscription\":\"" + channel + "\",\"exoId\":\"" + eXoId + "\",\"exoToken\":\"" + userToken + "\",\"clientId\":\"" + clientId + "\",\"id\":\"3\"},");
            }
            dataSub = ((String)dataSub).substring(0, ((String)dataSub).lastIndexOf(","));
            dataSub = (String)dataSub + "]";
            pairs[3] = new NVPair("Content-Length", Integer.toString(((String)dataSub).length()));
            response = connection.Post(this.url.getFile(), ((String)dataSub).getBytes(), pairs);
            incomMessage = TestTools.stringToCMessage(new String(response.getData()));
            LocalCometdTest.assertTrue((boolean)incomMessage.getSuccessful());
            return clientId;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public void testConnection() {
        try {
            int con = this.clients;
            CountDownLatch countDownLatch = new CountDownLatch(con);
            for (int i = 0; i < con; ++i) {
                CClient tender = new CClient("exo" + String.valueOf(i), countDownLatch);
                tender.start();
                Thread.sleep(this.sleepConnect);
            }
            LOG.info((Object)"-----------------------LocalCometdTest-----------------------------------");
            LOG.info((Object)("Conected " + con + " clients"));
            for (int j = 0; j < this.repeat; ++j) {
                for (int i = 0; i < con; ++i) {
                    Set<String> keySet = this.individuals.keySet();
                    for (String key : keySet) {
                        for (String channel : this.channels) {
                            TestTools.sendMessage("exo" + String.valueOf(i), channel, this.individuals.get(key), key, this.baseURI + "continuation/sendprivatemessage/");
                            Thread.sleep(this.sleepSend);
                        }
                    }
                }
                Set<String> keySet = this.broadcasts.keySet();
                for (String key : keySet) {
                    TestTools.sendBroadcastMessage(this.channels.get(0), this.broadcasts.get(key), key, this.baseURI + "continuation/sendbroadcastmessage/");
                    Thread.sleep(this.sleepSend);
                }
            }
            LOG.info((Object)("Send " + this.messages + " messages"));
            LOG.info((Object)("Wait " + this.timeout + " ms...."));
            countDownLatch.await();
            int t = this.totalB + this.totalI;
            LOG.info((Object)("Total get : " + t + " mesagess. " + this.totalB + " broadcast from them"));
            LOG.info((Object)"------------------------------------------------------------------------");
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (!this.startContainer) {
            CargoContainer.cargoContainerStop(this.container);
        }
    }

    class CClient
    extends Thread {
        String id;
        CountDownLatch countDownLatch;

        public CClient(String id, CountDownLatch countDownLatch) {
            this.id = id;
            this.countDownLatch = countDownLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String clientId = LocalCometdTest.this.cometdConnect(this.id);
                boolean flag = true;
                int i = 0;
                int b = 0;
                while (LocalCometdTest.this.messages > i + b) {
                    HTTPConnection connection = new HTTPConnection(LocalCometdTest.this.url);
                    String dataConnect = "message={\"channel\":\"/meta/connect\",\"clientId\":\"" + clientId + "\",\"connectionType\":\"" + LocalCometdTest.this.connectionType + "\",\"id\":\"" + this.id + "\"}";
                    NVPair[] pairs = new NVPair[5];
                    pairs[0] = new NVPair("Keep-Alive", "300");
                    pairs[1] = new NVPair("Connection", "keep-alive");
                    pairs[2] = new NVPair("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
                    pairs[3] = new NVPair("Content-Length", Integer.toString(dataConnect.length()));
                    HTTPResponse cometdResponse = connection.Post(LocalCometdTest.this.url.getFile(), dataConnect.getBytes(), pairs);
                    String resString = new String(cometdResponse.getData());
                    CMessages messages = TestTools.stringToCMessages(resString);
                    List<CMessage> list = messages.getCometdMessages();
                    flag = false;
                    for (CMessage message : list) {
                        String msg;
                        if (message.getData() == null) continue;
                        flag = true;
                        String msgid = message.getId();
                        if (LocalCometdTest.this.broadcasts.containsKey(msgid)) {
                            msg = LocalCometdTest.this.broadcasts.get(msgid);
                            Integer n = LocalCometdTest.this.totalB;
                            synchronized (n) {
                                Integer n2 = LocalCometdTest.this.totalB;
                                LocalCometdTest.this.totalB = LocalCometdTest.this.totalB + 1;
                            }
                            TestCase.assertEquals((String)msg, (String)message.getData());
                            LOG.info((Object)("CClient.run()" + message.getData()));
                            ++b;
                        }
                        if (!LocalCometdTest.this.individuals.containsKey(msgid)) continue;
                        msg = LocalCometdTest.this.individuals.get(msgid);
                        TestCase.assertEquals((String)msg, (String)message.getData());
                        LOG.info((Object)("CClient.run()" + message.getData()));
                        ++LocalCometdTest.this.totalI;
                        ++i;
                    }
                }
                this.countDownLatch.countDown();
            }
            catch (Exception e) {
                LOG.error((Object)e);
            }
        }
    }
}

