/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Value;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.template.Element;
import org.exoplatform.commons.notification.template.DigestTemplate;
import org.exoplatform.commons.notification.template.SimpleElement;
import org.exoplatform.commons.notification.template.TemplateUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.organization.OrganizationService;

public class NotificationUtils {
    public static final String DEFAULT_SUBJECT_KEY = "Notification.subject.{0}";
    public static final String DEFAULT_SIMPLE_DIGEST_KEY = "Notification.digest.{0}";
    public static final String DEFAULT_DIGEST_ONE_KEY = "Notification.digest.one.{0}";
    public static final String DEFAULT_DIGEST_THREE_KEY = "Notification.digest.three.{0}";
    public static final String DEFAULT_DIGEST_MORE_KEY = "Notification.digest.more.{0}";
    public static final String FEATURE_NAME = "notification";
    private static final Pattern LINK_PATTERN = Pattern.compile("<a ([^>]+)>([^<]+)</a>");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[_a-zA-Z0-9-+]+(\\.[_a-zA-Z0-9-]+)*@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*(\\.[a-zA-Z]{2,5})$");
    private static final String styleCSS = " style=\"color: #2f5e92; text-decoration: none;\"";
    public static final String CALENDAR_ACTIVITY = "cs-calendar:spaces";

    public static String getDefaultKey(String key, String providerId) {
        return MessageFormat.format(key, providerId);
    }

    public static Locale getLocale(String language) {
        if (language == null || language.isEmpty()) {
            return Locale.ENGLISH;
        }
        String[] infos = language.split("_");
        String lang = infos[0];
        String country = infos.length > 1 ? infos[1] : "";
        String variant = infos.length > 2 ? infos[2] : "";
        return new Locale(lang, country, variant);
    }

    public static DigestTemplate getDigest(PluginConfig templateConfig, String pluginId, String language) {
        String srcResource = templateConfig.getBundlePath();
        String digestOneKey = templateConfig.getKeyValue("digest.one", NotificationUtils.getDefaultKey(DEFAULT_DIGEST_ONE_KEY, pluginId));
        String digestThreeKey = templateConfig.getKeyValue("digest.three", NotificationUtils.getDefaultKey(DEFAULT_DIGEST_THREE_KEY, pluginId));
        String digestMoreKey = templateConfig.getKeyValue("digest.more", NotificationUtils.getDefaultKey(DEFAULT_DIGEST_MORE_KEY, pluginId));
        Locale locale = NotificationUtils.getLocale(language);
        return new DigestTemplate().digestOne(TemplateUtils.getResourceBundle(digestOneKey, locale, srcResource)).digestThree(TemplateUtils.getResourceBundle(digestThreeKey, locale, srcResource)).digestMore(TemplateUtils.getResourceBundle(digestMoreKey, locale, srcResource));
    }

    public static Element getSubject(PluginConfig templateConfig, String pluginId, String language) {
        String bundlePath = templateConfig.getBundlePath();
        String subjectKey = templateConfig.getKeyValue("subject", NotificationUtils.getDefaultKey(DEFAULT_SUBJECT_KEY, pluginId));
        Locale locale = NotificationUtils.getLocale(language);
        return new SimpleElement().language(locale.getLanguage()).template(TemplateUtils.getResourceBundle(subjectKey, locale, bundlePath));
    }

    public static String listToString(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuffer values = new StringBuffer();
        for (String str : list) {
            if (values.length() > 0) {
                values.append(",");
            }
            values.append(str);
        }
        return values.toString();
    }

    public static String listToString(List<String> list, String pattern) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuffer values = new StringBuffer();
        for (String str : list) {
            if (values.length() > 0) {
                values.append(",");
            }
            values.append(pattern.replace("VALUE", str));
        }
        return values.toString();
    }

    public static List<String> stringToList(String value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value == null || value.isEmpty()) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result;
    }

    public static String[] valuesToArray(Value[] values) throws Exception {
        if (values.length < 1) {
            return new String[0];
        }
        List<String> list = NotificationUtils.valuesToList(values);
        return list.toArray(new String[list.size()]);
    }

    public static List<String> valuesToList(Value[] values) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        if (values.length < 1) {
            return list;
        }
        for (int i = 0; i < values.length; ++i) {
            String s = values[i].getString();
            if (s == null || s.trim().length() <= 0) continue;
            list.add(s);
        }
        return list;
    }

    public static String getValueParam(InitParams params, String key, String defaultValue) {
        try {
            return params.getValueParam(key).getValue();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getValueParam(InitParams params, String key, int defaultValue) {
        try {
            return Integer.valueOf(params.getValueParam(key).getValue());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getSystemValue(InitParams params, String systemKey, String paramKey, String defaultValue) {
        try {
            String vl = System.getProperty(systemKey);
            if (vl == null || vl.length() == 0) {
                vl = NotificationUtils.getValueParam(params, paramKey, defaultValue);
            }
            return vl.trim();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static int getSystemValue(InitParams params, String systemKey, String paramKey, int defaultValue) {
        return Integer.valueOf(NotificationUtils.getSystemValue(params, systemKey, paramKey, String.valueOf(defaultValue)));
    }

    public static boolean isValidEmailAddresses(String addressList) {
        if (addressList == null || addressList.length() < 0) {
            return false;
        }
        addressList = StringUtils.replace((String)addressList, (String)";", (String)",");
        try {
            InternetAddress[] iAdds = InternetAddress.parse((String)addressList, (boolean)true);
            for (int i = 0; i < iAdds.length; ++i) {
                Matcher matcher = EMAIL_PATTERN.matcher(iAdds[i].getAddress().trim());
                if (matcher.find()) continue;
                return false;
            }
        }
        catch (AddressException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDeletedMember(String userName) {
        try {
            CommonsUtils.startRequest(CommonsUtils.getService(OrganizationService.class));
            boolean bl = CommonsUtils.getService(OrganizationService.class).getUserHandler().findUserByName(userName) == null;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            CommonsUtils.endRequest(CommonsUtils.getService(OrganizationService.class));
        }
    }

    public static String processLinkTitle(String title) {
        Matcher matcher = LINK_PATTERN.matcher(title);
        while (matcher.find()) {
            String result = matcher.group(1);
            title = title.replace(result, result + styleCSS);
        }
        return title;
    }

    public static String getNotificationActivityTitle(String title, String activityType) {
        String displayTitle = NotificationUtils.removeLinkTitle(title);
        if (CALENDAR_ACTIVITY.equals(activityType)) {
            displayTitle = StringEscapeUtils.unescapeHtml((String)displayTitle);
        }
        return displayTitle;
    }

    public static String removeLinkTitle(String title) {
        Matcher mat = LINK_PATTERN.matcher(title);
        return mat.replaceAll("<span class=\"user-name text-bold\">$2</span>");
    }

    public static String getProfileUrl(String userId) {
        StringBuffer footerLink = new StringBuffer(CommonsUtils.getCurrentDomain());
        return footerLink.append("/").append(CommonsUtils.getRestContextName()).append("/").append("social/notifications/redirectUrl/notification_settings").append("/").append(userId).toString();
    }

    public static String getPortalHome(String portalName) {
        StringBuffer portalLink = new StringBuffer(CommonsUtils.getCurrentDomain());
        portalLink.append("/").append(CommonsUtils.getRestContextName()).append("/").append("social/notifications/redirectUrl/portal_home").append("/").append(portalName);
        return "<a target=\"_blank\" style=\"text-decoration: none; font-weight: bold; color: #2F5E92; \" href=\"" + portalLink.toString() + "\">" + portalName + "</a>";
    }
}

