/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.persistence.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class ExoEntityScanner
implements Integrator {
    private static final Log LOGGER = ExoLogger.getLogger(ExoEntityScanner.class);
    private static final String PU_FIELD_NAME = "persistenceUnitName";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        block13: {
            try {
                if (!this.isExoPersistenceUnit(configuration)) break block13;
                Enumeration<URL> urls = Thread.currentThread().getContextClassLoader().getResources("exo-jpa-entities/entities.idx");
                while (urls.hasMoreElements()) {
                    InputStream stream = urls.nextElement().openStream();
                    try {
                        String entityClassName;
                        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                        while ((entityClassName = reader.readLine()) != null) {
                            try {
                                if (configuration.getClassMapping(entityClassName) != null) continue;
                                configuration.addAnnotatedClass(Class.forName(entityClassName));
                            }
                            catch (ClassNotFoundException e) {
                                LOGGER.error((Object)("Error while trying to register entity [" + entityClassName + "] in Persistence Unit"), (Throwable)e);
                            }
                        }
                    }
                    finally {
                        try {
                            stream.close();
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)"Error while closing stream", (Throwable)e);
                        }
                    }
                }
            }
            catch (IOException | IllegalAccessException e) {
                LOGGER.error((Object)"Error while loading entities in PLF Persistence Unit", (Throwable)e);
            }
        }
        configuration.buildMappings();
    }

    private boolean isExoPersistenceUnit(Configuration configuration) throws IllegalAccessException {
        return "exo-pu".equals(configuration.getProperty(PU_FIELD_NAME));
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }
}

