/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.channel.AbstractChannel;
import org.exoplatform.commons.api.notification.channel.ChannelManager;
import org.exoplatform.commons.api.notification.lifecycle.AbstractNotificationLifecycle;
import org.exoplatform.commons.api.notification.model.ChannelKey;
import org.exoplatform.commons.api.notification.model.MessageInfo;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.QueueMessage;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.NotificationDataStorage;
import org.exoplatform.commons.api.notification.service.storage.NotificationService;
import org.exoplatform.commons.api.notification.service.template.DigestorService;
import org.exoplatform.commons.notification.NotificationContextFactory;
import org.exoplatform.commons.notification.NotificationUtils;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NotificationServiceImpl
extends AbstractService
implements NotificationService {
    private static final Log LOG = ExoLogger.getLogger(NotificationServiceImpl.class);
    private final NotificationDataStorage storage;
    private final DigestorService digestorService;
    private final UserSettingService userService;
    private final NotificationContextFactory notificationContextFactory;
    private final ChannelManager channelManager;

    public NotificationServiceImpl(ChannelManager channelManager, UserSettingService userService, DigestorService digestorService, NotificationDataStorage storage, NotificationContextFactory notificationContextFactory) {
        this.userService = userService;
        this.digestorService = digestorService;
        this.storage = storage;
        this.notificationContextFactory = notificationContextFactory;
        this.channelManager = channelManager;
    }

    public void process(NotificationInfo notification) throws Exception {
        String pluginId = notification.getKey().getId();
        if (this.notificationContextFactory.getStatisticsService().isStatisticsEnabled()) {
            this.notificationContextFactory.getStatisticsCollector().createNotificationInfoCount(pluginId);
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.setNotificationInfo(notification);
        List userIds = null;
        List channels = this.channelManager.getChannels();
        for (AbstractChannel channel : channels) {
            if (!CommonsUtils.getService(PluginSettingService.class).isActive(channel.getId(), pluginId)) continue;
            userIds = notification.isSendAll() ? this.userService.getUserHasSettingPlugin(channel.getId(), pluginId) : this.removeDisabledUsers(notification.getSendToUserIds());
            AbstractNotificationLifecycle lifecycle = this.channelManager.getLifecycle(ChannelKey.key((String)channel.getId()));
            lifecycle.process(ctx, userIds.toArray(new String[userIds.size()]));
        }
    }

    private List<String> removeDisabledUsers(List<String> users) {
        ArrayList<String> result = new ArrayList<String>();
        for (String user : users) {
            UserSetting userSetting = this.userService.get(user);
            if (!userSetting.isEnabled()) continue;
            result.add(user);
        }
        return result;
    }

    public void process(Collection<NotificationInfo> messages) throws Exception {
        for (NotificationInfo message : messages) {
            this.process(message);
        }
    }

    public void digest(NotificationContext notifContext) throws Exception {
        List userDigestSettings;
        UserSetting defaultConfigPlugins = this.getDefaultUserSetting(notifContext.getPluginSettingService().getActivePluginIds(UserSetting.EMAIL_CHANNEL));
        long startTime = System.currentTimeMillis();
        int limit = 100;
        int offset = 0;
        while ((userDigestSettings = this.userService.getDigestSettingForAllUser(notifContext, offset, limit)).size() != 0) {
            this.send(notifContext, userDigestSettings);
            offset += limit;
        }
        LOG.debug((Object)("Time to run process users have settings: " + (System.currentTimeMillis() - startTime) + "ms."));
        long startTimeDefault = System.currentTimeMillis();
        if (defaultConfigPlugins.getDailyPlugins().size() > 0 || defaultConfigPlugins.getWeeklyPlugins().size() > 0) {
            List defaultMixinUsers;
            offset = 0;
            while ((defaultMixinUsers = this.userService.getDigestDefaultSettingForAllUser(offset, limit)).size() != 0) {
                this.sendDefault(notifContext, defaultMixinUsers, defaultConfigPlugins);
                offset += limit;
            }
        }
        this.storage.removeMessageAfterSent();
        LOG.debug((Object)("Time to run process users used default settings: " + (System.currentTimeMillis() - startTimeDefault) + "ms."));
    }

    private void send(NotificationContext context, List<UserSetting> userSettings) {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        for (UserSetting userSetting : userSettings) {
            MessageInfo messageInfo;
            Map notificationMessageMap;
            if (!userSetting.isChannelActive("MAIL_CHANNEL") || NotificationUtils.isDeletedMember(userSetting.getUserId()) || !NotificationUtils.isActiveSetting(userSetting.getUserId()) || (notificationMessageMap = this.storage.getByUser(context, userSetting)).size() <= 0 || (messageInfo = this.digestorService.buildMessage(context, notificationMessageMap, userSetting)) == null) continue;
            CommonsUtils.getService(QueueMessage.class).put(messageInfo);
            if (!stats) continue;
            NotificationContextFactory.getInstance().getStatisticsCollector().createMessageInfoCount(messageInfo.getPluginId());
            NotificationContextFactory.getInstance().getStatisticsCollector().putQueue(messageInfo.getPluginId());
        }
    }

    private void sendDefault(NotificationContext context, List<UserSetting> userSettings, UserSetting defaultConfigPlugins) {
        boolean stats = NotificationContextFactory.getInstance().getStatistics().isStatisticsEnabled();
        for (UserSetting userSetting : userSettings) {
            MessageInfo messageInfo;
            Map notificationMessageMap;
            if (NotificationUtils.isDeletedMember(userSetting.getUserId()) || (notificationMessageMap = this.storage.getByUser(context, userSetting = defaultConfigPlugins.clone().setUserId(userSetting.getUserId()).setLastUpdateTime(userSetting.getLastUpdateTime()))).size() <= 0 || (messageInfo = this.digestorService.buildMessage(context, notificationMessageMap, userSetting)) == null) continue;
            CommonsUtils.getService(QueueMessage.class).put(messageInfo);
            if (!stats) continue;
            NotificationContextFactory.getInstance().getStatisticsCollector().createMessageInfoCount(messageInfo.getPluginId());
            NotificationContextFactory.getInstance().getStatisticsCollector().putQueue(messageInfo.getPluginId());
        }
    }

    private UserSetting getDefaultUserSetting(List<String> activatedPluginsByAdminSetting) {
        UserSetting setting = UserSetting.getInstance();
        UserSetting defaultSetting = UserSetting.getDefaultInstance();
        for (String string : activatedPluginsByAdminSetting) {
            if (defaultSetting.isInWeekly(string)) {
                setting.addPlugin(string, UserSetting.FREQUENCY.WEEKLY);
                continue;
            }
            if (!defaultSetting.isInDaily(string)) continue;
            setting.addPlugin(string, UserSetting.FREQUENCY.DAILY);
        }
        return setting;
    }
}

