/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.service.storage;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.api.notification.NotificationMessageUtils;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.notification.impl.AbstractService;
import org.exoplatform.commons.notification.impl.NotificationSessionManager;
import org.exoplatform.commons.notification.impl.service.storage.NotificationIterator;
import org.exoplatform.commons.notification.impl.service.storage.cache.CachedWebNotificationStorage;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.XPathUtils;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WebNotificationStorageImpl
extends AbstractService
implements WebNotificationStorage {
    private static final Log LOG = ExoLogger.getLogger(WebNotificationStorageImpl.class);
    private static final String NOTIFICATIONS = "notifications";
    private static final String NT_UNSTRUCTURED = "nt:unstructured";
    private final ReentrantLock lock = new ReentrantLock();
    private final NodeHierarchyCreator nodeHierarchyCreator;
    private final UserSettingService userSettingService;
    private final DataDistributionManager distributionManager;
    private WebNotificationStorage webNotificationStorage;

    public WebNotificationStorageImpl(NodeHierarchyCreator nodeHierarchyCreator, DataDistributionManager distributionManager, UserSettingService userSettingService) {
        this.nodeHierarchyCreator = nodeHierarchyCreator;
        this.distributionManager = distributionManager;
        this.userSettingService = userSettingService;
    }

    private Session getSession(SessionProvider sProvider) throws Exception {
        ManageableRepository repository = CommonsUtils.getRepository();
        return sProvider.getSession(repository.getConfiguration().getDefaultWorkspaceName(), repository);
    }

    private String converDateToNodeName(Calendar cal) {
        return new SimpleDateFormat("yyyyMMdd").format(cal.getTime());
    }

    private Node getOrCreateDataNode(Node rootNode, String nodeName, String nodeType) throws RepositoryException {
        return this.distributionManager.getDataDistributionType(DataDistributionMode.NONE).getOrCreateDataNode(rootNode, nodeName, nodeType);
    }

    private Node getOrCreateWebDateNode(SessionProvider sProvider, NotificationInfo notification) throws Exception {
        String dateNodeName = this.converDateToNodeName(notification.getDateCreated());
        Node channelNode = this.getOrCreateChannelNode(sProvider, notification.getTo());
        try {
            return channelNode.getNode(dateNodeName);
        }
        catch (PathNotFoundException e) {
            Node dateNode = this.getOrCreateDataNode(channelNode, dateNodeName, "ntf:notifDate");
            dateNode.setProperty("ntf:lastModifiedDate", notification.getDateCreated().getTimeInMillis());
            channelNode.save();
            return dateNode;
        }
    }

    private Node getOrCreateChannelNode(SessionProvider sProvider, String userId) throws Exception {
        Node userNodeApp = this.nodeHierarchyCreator.getUserApplicationNode(sProvider, userId);
        Node parentNode = this.getOrCreateDataNode(userNodeApp, NOTIFICATIONS, NT_UNSTRUCTURED);
        Node channelNode = this.getOrCreateDataNode(parentNode, "web", "ntf:channel");
        return channelNode;
    }

    private void addMixinCountItemOnPopover(Node notifyNode, String userId) throws Exception {
        if (!notifyNode.isNodeType("mix:newNode")) {
            notifyNode.addMixin("mix:newNode");
        }
    }

    public void save(NotificationInfo notification) {
        this.save(notification, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(NotificationInfo notification, boolean isCountOnPopover) {
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        try {
            this.lock.lock();
            Node userNode = this.getOrCreateWebDateNode(sProvider, notification);
            Node notifyNode = this.getOrCreateDataNode(userNode, notification.getId(), "ntf:notifInfo");
            notifyNode.setProperty("ntf:pluginId", notification.getKey().getId());
            notifyNode.setProperty("ntf:text", notification.getTitle());
            notifyNode.setProperty("ntf:sender", notification.getFrom());
            notifyNode.setProperty("ntf:owner", notification.getTo());
            notifyNode.setProperty("ntf:lastModifiedDate", notification.getLastModifiedDate());
            Map ownerParameter = notification.getOwnerParameter();
            if (ownerParameter != null && !ownerParameter.isEmpty()) {
                for (String key : ownerParameter.keySet()) {
                    String propertyName = key.indexOf("ntf:") != 0 ? "ntf:" + key : key;
                    notifyNode.setProperty(propertyName, (String)ownerParameter.get(key));
                }
            }
            if (isCountOnPopover) {
                this.addMixinCountItemOnPopover(notifyNode, notification.getTo());
            }
            userNode.getSession().save();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to save the notificaton.", (Throwable)e);
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
            this.lock.unlock();
        }
    }

    public List<NotificationInfo> get(WebNotificationFilter filter, int offset, int limit) {
        ArrayList<NotificationInfo> result = new ArrayList<NotificationInfo>();
        SessionProvider sProvider = CommonsUtils.getSystemSessionProvider();
        try {
            Node userWebNotificationNode = this.getOrCreateChannelNode(sProvider, filter.getUserId());
            NotificationIterator notificationIterator = new NotificationIterator(filter, userWebNotificationNode, offset, limit);
            List<Node> nodes = notificationIterator.nodes();
            for (Node node : nodes) {
                result.add(this.getWebNotificationStorage().get(node.getName()));
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Notifications not found by filter: " + filter.toString()), (Throwable)e);
        }
        return result;
    }

    public NotificationInfo get(String id) {
        try {
            return this.fillModel(this.getNodeNotification(CommonsUtils.getSystemSessionProvider(), id));
        }
        catch (Exception e) {
            LOG.error((Object)("Notification not found by id: " + id), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String notificationId) {
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        try {
            Node node = this.getNodeNotification(sProvider, notificationId);
            if (node != null) {
                this.distributionManager.getDataDistributionType(DataDistributionMode.NONE).removeDataNode(node.getParent(), notificationId);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to remove the notification id: " + notificationId), (Throwable)e);
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(long seconds) {
        boolean removed = false;
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        Calendar cal = Calendar.getInstance();
        long delayTime = System.currentTimeMillis() - seconds * 1000L;
        cal.setTimeInMillis(delayTime);
        try {
            Session session = this.getSession(sProvider);
            StringBuilder strQuery = new StringBuilder("SELECT * FROM ").append("ntf:notifDate").append(" WHERE ");
            strQuery.append("ntf:lastModifiedDate").append(" < ").append(delayTime);
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(strQuery.toString(), "sql");
            NodeIterator it = query.execute().getNodes();
            while (it.hasNext()) {
                Node node = it.nextNode();
                node.remove();
                removed = true;
                session.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to remove all notifications and delay date: " + this.converDateToNodeName(cal)), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(String userId, long seconds) {
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        try {
            Node userNode = this.getOrCreateChannelNode(sProvider, userId);
            String userPath = XPathUtils.escapeIllegalSQLName(userNode.getPath());
            Session session = userNode.getSession();
            long delayTime = System.currentTimeMillis() - seconds * 1000L;
            StringBuilder strQuery = new StringBuilder("SELECT * FROM ");
            strQuery.append("ntf:notifDate").append(" WHERE (").append("jcr:path LIKE '").append(userPath).append("/%' AND NOT jcr:path LIKE '").append(userPath).append("/%/%'").append(") AND (").append("ntf:lastModifiedDate").append(" < ").append(delayTime).append(")");
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(strQuery.toString(), "sql");
            NodeIterator it = query.execute().getNodes();
            while (it.hasNext()) {
                Node node = it.nextNode();
                node.remove();
                session.save();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to remove all notifications for the user id: " + userId), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
        }
        return true;
    }

    public void markRead(String notificationId) {
        Node node = this.getNodeNotification(CommonsUtils.getSystemSessionProvider(), notificationId);
        if (node != null) {
            try {
                Session session = node.getSession();
                node.setProperty("ntf:read", "true");
                session.save();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to update the read notification Id: " + notificationId), (Throwable)e);
            }
        }
    }

    public void hidePopover(String notificationId) {
        Node node = this.getNodeNotification(CommonsUtils.getSystemSessionProvider(), notificationId);
        if (node != null) {
            try {
                Session session = node.getSession();
                node.setProperty("ntf:showPopover", "false");
                session.save();
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to hide the notification Id: " + notificationId + " on the popover list."), (Throwable)e);
            }
        }
    }

    public void markAllRead(String userId) {
        try {
            this.userSettingService.saveLastReadDate(userId, Long.valueOf(System.currentTimeMillis()));
            if (this.getWebNotificationStorage() instanceof CachedWebNotificationStorage) {
                CachedWebNotificationStorage cacheStorage = (CachedWebNotificationStorage)this.getWebNotificationStorage();
                cacheStorage.updateAllRead(userId);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to update the all read for userId:" + userId), (Throwable)e);
        }
    }

    private NotificationInfo fillModel(Node node) throws Exception {
        if (node == null) {
            return null;
        }
        NotificationInfo notifiInfo = NotificationInfo.instance().setTo(node.getProperty("ntf:owner").getString()).setFrom(node.getProperty("ntf:sender").getString()).key(node.getProperty("ntf:pluginId").getString()).setTitle(node.getProperty("ntf:text").getString()).setOnPopOver(node.getProperty("ntf:showPopover").getBoolean()).setLastModifiedDate(node.getProperty("ntf:lastModifiedDate").getLong()).setId(node.getName()).end();
        if (node.hasProperty("exo:dateCreated")) {
            notifiInfo.setDateCreated(node.getProperty("exo:dateCreated").getDate());
        }
        List<String> ignoreProperties = Arrays.asList("ntf:pluginId", "ntf:text", "ntf:owner", "ntf:lastModifiedDate");
        PropertyIterator iterator = node.getProperties();
        while (iterator.hasNext()) {
            Property p = iterator.nextProperty();
            if (p.getName().indexOf("ntf:") != 0 || ignoreProperties.contains(p.getName())) continue;
            try {
                notifiInfo.with(p.getName().replace("ntf:", ""), p.getString());
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to get the property value.", (Throwable)e);
            }
        }
        long lastReadDate = this.getLastReadDateOfUser(notifiInfo.getTo());
        if (notifiInfo.getLastModifiedDate() <= lastReadDate) {
            notifiInfo.with(NotificationMessageUtils.READ_PORPERTY.getKey(), "true");
        }
        return notifiInfo;
    }

    private Node getNodeNotification(SessionProvider sProvider, String notificationId) {
        try {
            Session session = this.getSession(sProvider);
            StringBuilder strQuery = new StringBuilder("SELECT * FROM ");
            strQuery.append("ntf:notifInfo").append(" WHERE fn:name() = '").append(notificationId).append("'");
            QueryManager qm = session.getWorkspace().getQueryManager();
            QueryImpl query = (QueryImpl)qm.createQuery(strQuery.toString(), "sql");
            query.setOffset(0L);
            query.setLimit(1L);
            NodeIterator it = query.execute().getNodes();
            if (it.hasNext()) {
                return it.nextNode();
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to get web notification node: " + notificationId), (Throwable)e);
        }
        return null;
    }

    private WebNotificationStorage getWebNotificationStorage() {
        if (this.webNotificationStorage == null) {
            this.webNotificationStorage = CommonsUtils.getService(WebNotificationStorage.class);
        }
        return this.webNotificationStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationInfo getUnreadNotification(String pluginId, String activityId, String owner) {
        boolean created = NotificationSessionManager.createSystemProvider();
        SessionProvider sProvider = NotificationSessionManager.getSessionProvider();
        try {
            String userPath = this.getOrCreateChannelNode(sProvider, owner).getPath();
            long lastReadDate = this.getLastReadDateOfUser(owner);
            StringBuilder strQuery = new StringBuilder("SELECT * FROM ").append("ntf:notifInfo");
            strQuery.append(" WHERE jcr:path LIKE '").append(XPathUtils.escapeIllegalSQLName(userPath)).append("/%'").append(" AND ntf:pluginId = '").append(pluginId).append("'").append(" AND ntf:activityId = '").append(activityId).append("'").append(" AND ntf:lastModifiedDate > ").append(lastReadDate).append(" AND ntf:read = 'false'");
            Session session = this.getSession(sProvider);
            QueryManager qm = session.getWorkspace().getQueryManager();
            QueryImpl query = (QueryImpl)qm.createQuery(strQuery.toString(), "sql");
            query.setOffset(0L);
            query.setLimit(1L);
            NodeIterator iter = query.execute().getNodes();
            if (iter.hasNext()) {
                NotificationInfo notificationInfo = this.getWebNotificationStorage().get(iter.nextNode().getName());
                return notificationInfo;
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Failed to getUnreadNotification ", (Throwable)e);
        }
        finally {
            NotificationSessionManager.closeSessionProvider(created);
        }
        return null;
    }

    public void update(NotificationInfo notification, boolean moveTop) {
        try {
            this.lock.lock();
            if (moveTop) {
                this.remove(notification.getId());
            }
            this.save(notification, moveTop);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getNumberOnBadge(String userId) {
        if (StringUtils.isNotBlank((String)userId)) {
            try {
                SessionProvider sProvider = CommonsUtils.getSystemSessionProvider();
                NodeIterator iter = this.getNewMessage(sProvider, userId, 0);
                return (int)iter.getSize();
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.error((Object)"Failed to getNumberOnBadge() ", (Throwable)e);
                } else {
                    LOG.warn((Object)("Exception raising when getNumberOnBadge() associated to the userId " + userId));
                }
                return 0;
            }
        }
        LOG.warn((Object)"Can't getNumberOnBadge(). The userId is null");
        return 0;
    }

    public void resetNumberOnBadge(String userId) {
        try {
            SessionProvider sProvider = CommonsUtils.getSystemSessionProvider();
            NodeIterator iter = this.getNewMessage(sProvider, userId, 0);
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                node.removeMixin("mix:newNode");
            }
            this.getSession(sProvider).save();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to resetNumberOnBadge() ", (Throwable)e);
        }
    }

    private NodeIterator getNewMessage(SessionProvider sProvider, String userId, int limit) throws Exception {
        Session session = this.getSession(sProvider);
        String userPath = this.getOrCreateChannelNode(sProvider, userId).getPath();
        StringBuilder strQuery = new StringBuilder("SELECT * FROM ").append("mix:newNode").append(" WHERE jcr:path LIKE '").append(XPathUtils.escapeIllegalSQLName(userPath)).append("/%' ");
        QueryManager qm = session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)qm.createQuery(strQuery.toString(), "sql");
        if (limit > 0) {
            query.setOffset(0L);
            query.setLimit((long)limit);
        }
        return query.execute().getNodes();
    }

    private long getLastReadDateOfUser(String userId) {
        return this.userSettingService.get(userId).getLastReadDate();
    }
}

