/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.persistence.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.hibernate.cfg.AvailableSettings;

public class EntityManagerService
implements ComponentRequestLifecycle {
    public static final String PERSISTENCE_UNIT_NAME = "exo-pu";
    private static final Log LOGGER = ExoLogger.getLogger(EntityManagerService.class);
    private static final String EXO_JPA_DATASOURCE_NAME = "exo.jpa.datasource.name";
    private static final String EXO_PREFIX_FOR_HIB_SETTINGS = "exo.jpa.";
    private static EntityManagerFactory entityManagerFactory;
    private ThreadLocal<EntityManager> instance = new ThreadLocal();
    private final Properties properties = new Properties();

    public EntityManagerService() {
        String datasourceName = PropertyManager.getProperty((String)EXO_JPA_DATASOURCE_NAME);
        if (StringUtils.isNotBlank((String)datasourceName)) {
            this.properties.put("javax.persistence.nonJtaDataSource", datasourceName);
            LOGGER.info("EntityManagerFactory [{}] - Creating with datasource {}.", new Object[]{PERSISTENCE_UNIT_NAME, datasourceName});
        } else {
            LOGGER.info("EntityManagerFactory [{}] - Creating with default datasource.", new Object[]{PERSISTENCE_UNIT_NAME});
        }
        for (String propertyName : this.getHibernateAvailableSettings()) {
            String propertyValue = PropertyManager.getProperty((String)(EXO_PREFIX_FOR_HIB_SETTINGS + propertyName));
            if (!StringUtils.isNotBlank((String)propertyValue)) continue;
            this.properties.put(propertyName, propertyValue);
            LOGGER.info("EntityManagerFactory [{}] - Setting [{}] to [{}]", new Object[]{PERSISTENCE_UNIT_NAME, propertyName, propertyValue});
        }
        entityManagerFactory = Persistence.createEntityManagerFactory((String)PERSISTENCE_UNIT_NAME, (Map)this.properties);
        LOGGER.info("EntityManagerFactory [{}] - Created.", new Object[]{PERSISTENCE_UNIT_NAME});
    }

    public String getDatasourceName() {
        return (String)this.properties.get("javax.persistence.nonJtaDataSource");
    }

    public void setDatasourceName(String datasourceName) {
        this.properties.put("javax.persistence.nonJtaDataSource", datasourceName);
    }

    private List<String> getHibernateAvailableSettings() {
        ArrayList<String> result = new ArrayList<String>();
        for (Field field : AvailableSettings.class.getDeclaredFields()) {
            try {
                result.add((String)field.get(null));
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Object)"Error while getting Hibernate available settings.", (Throwable)e);
            }
        }
        return result;
    }

    public EntityManager getEntityManager() {
        if (this.instance.get() == null) {
            return null;
        }
        return this.instance.get();
    }

    EntityManager createEntityManager() {
        EntityManager em = entityManagerFactory.createEntityManager();
        this.instance.set(em);
        return em;
    }

    public void startRequest(ExoContainer container) {
        if (this.instance.get() != null) {
            this.endRequest(container);
        }
        this.createEntityManager();
    }

    public void endRequest(ExoContainer container) {
        this.closeEntityManager();
    }

    public boolean isStarted(ExoContainer container) {
        return this.instance.get() != null && this.instance.get().getTransaction() != null;
    }

    void closeEntityManager() {
        EntityManager em;
        block9: {
            em = this.getEntityManager();
            EntityTransaction tx = null;
            try {
                tx = em.getTransaction();
                if (!tx.isActive()) break block9;
                tx.commit();
            }
            catch (RuntimeException ex) {
                try {
                    try {
                        if (tx != null && tx.isActive()) {
                            tx.rollback();
                        }
                    }
                    catch (RuntimeException rbEx) {
                        LOGGER.error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                catch (Throwable throwable) {
                    em.close();
                    this.instance.set(null);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Ended a request lifecycle of {} component service", new Object[]{EntityManagerService.class.getName()});
                    }
                    throw throwable;
                }
            }
        }
        em.close();
        this.instance.set(null);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Ended a request lifecycle of {} component service", new Object[]{EntityManagerService.class.getName()});
        }
    }
}

