/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.notification.impl.jpa.web;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.notification.impl.jpa.EntityConverter;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebNotifDAO;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebParamsDAO;
import org.exoplatform.commons.notification.impl.jpa.web.dao.WebUsersDAO;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebNotifEntity;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebParamsEntity;
import org.exoplatform.commons.notification.impl.jpa.web.entity.WebUsersEntity;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.hibernate.TransactionException;

public class JPAWebNotificationStorage
implements WebNotificationStorage {
    private static final Log LOG;
    private final UserSettingService userSettingService;
    private WebNotifDAO webNotifDAO;
    private WebParamsDAO webParamsDAO;
    private WebUsersDAO webUsersDAO;
    private static final String NTF_NAME_SPACE = "ntf:";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    public JPAWebNotificationStorage(WebNotifDAO webNotifDAO, WebParamsDAO webParamsDAO, WebUsersDAO webUsersDAO, UserSettingService userSettingService) {
        this.userSettingService = userSettingService;
        this.webNotifDAO = webNotifDAO;
        this.webParamsDAO = webParamsDAO;
        this.webUsersDAO = webUsersDAO;
    }

    @ExoTransactional
    public void save(NotificationInfo notification) {
        NotificationInfo notificationInfo = notification;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)notificationInfo);
        JPAWebNotificationStorage.save_aroundBody1$advice(this, notificationInfo, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public List<NotificationInfo> get(WebNotificationFilter filter, int offset, int limit) {
        WebNotificationFilter webNotificationFilter = filter;
        int n = offset;
        int n2 = limit;
        Object[] objectArray = new Object[]{webNotificationFilter, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        return (List)JPAWebNotificationStorage.get_aroundBody3$advice(this, webNotificationFilter, n, n2, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public NotificationInfo get(String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        return (NotificationInfo)JPAWebNotificationStorage.get_aroundBody5$advice(this, string, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public boolean remove(String notificationId) {
        String string = notificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        return Conversions.booleanValue((Object)JPAWebNotificationStorage.remove_aroundBody7$advice(this, string, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @ExoTransactional
    public boolean remove(long seconds) {
        long l = seconds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)Conversions.longObject((long)l));
        return Conversions.booleanValue((Object)JPAWebNotificationStorage.remove_aroundBody9$advice(this, l, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @ExoTransactional
    public boolean remove(String userId, long seconds) {
        String string = userId;
        long l = seconds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)Conversions.longObject((long)l));
        return Conversions.booleanValue((Object)JPAWebNotificationStorage.remove_aroundBody11$advice(this, string, l, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @ExoTransactional
    public void markRead(String notificationId) {
        String string = notificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        JPAWebNotificationStorage.markRead_aroundBody13$advice(this, string, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public void hidePopover(String notificationId) {
        String string = notificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        JPAWebNotificationStorage.hidePopover_aroundBody15$advice(this, string, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public void markAllRead(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        JPAWebNotificationStorage.markAllRead_aroundBody17$advice(this, string, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public NotificationInfo getUnreadNotification(String pluginId, String activityId, String userId) {
        String string = pluginId;
        String string2 = activityId;
        String string3 = userId;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        return (NotificationInfo)JPAWebNotificationStorage.getUnreadNotification_aroundBody19$advice(this, string, string2, string3, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public void update(NotificationInfo notification, boolean moveTop) {
        NotificationInfo notificationInfo = notification;
        boolean bl = moveTop;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)notificationInfo, (Object)Conversions.booleanObject((boolean)bl));
        JPAWebNotificationStorage.update_aroundBody21$advice(this, notificationInfo, bl, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    @ExoTransactional
    public int getNumberOnBadge(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string);
        return Conversions.intValue((Object)JPAWebNotificationStorage.getNumberOnBadge_aroundBody23$advice(this, string, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint));
    }

    @ExoTransactional
    public void resetNumberOnBadge(String userId) {
        String string = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string);
        JPAWebNotificationStorage.resetNumberOnBadge_aroundBody25$advice(this, string, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    private void save(NotificationInfo notification, boolean moveTop) {
        WebUsersEntity webUsersEntity = null;
        if (notification.getId() != null && !notification.getId().startsWith("NotificationMessage")) {
            webUsersEntity = (WebUsersEntity)this.webUsersDAO.find(Long.parseLong(notification.getId()));
        }
        boolean isNew = webUsersEntity == null;
        WebNotifEntity webNotifEntity = null;
        if (isNew) {
            webNotifEntity = new WebNotifEntity();
            webUsersEntity = new WebUsersEntity();
        } else {
            webNotifEntity = webUsersEntity.getNotification();
        }
        webNotifEntity.setType(notification.getKey().getId());
        webNotifEntity.setText(notification.getTitle());
        webNotifEntity.setSender(notification.getFrom());
        if (notification.getDateCreated() == null) {
            webNotifEntity.setCreationDate(Calendar.getInstance());
        } else {
            webNotifEntity.setCreationDate(notification.getDateCreated());
        }
        webNotifEntity = isNew ? this.webNotifDAO.create(webNotifEntity) : this.webNotifDAO.update(webNotifEntity);
        Map ownerParameter = notification.getOwnerParameter();
        Set<WebParamsEntity> parameters = webNotifEntity.getParameters();
        if (ownerParameter != null && !ownerParameter.isEmpty()) {
            for (String key : ownerParameter.keySet()) {
                String propertyName = key.replace(NTF_NAME_SPACE, "");
                WebParamsEntity webParamsEntity = null;
                boolean isParamNew = true;
                if (isNew) {
                    webParamsEntity = new WebParamsEntity();
                } else {
                    for (WebParamsEntity webParamsEntityTmp : parameters) {
                        if (!webParamsEntityTmp.getName().equals(propertyName)) continue;
                        webParamsEntity = webParamsEntityTmp;
                        isParamNew = false;
                        break;
                    }
                }
                if (webParamsEntity == null) {
                    webParamsEntity = new WebParamsEntity();
                }
                webParamsEntity.setName(propertyName);
                webParamsEntity.setValue((String)ownerParameter.get(key));
                webParamsEntity.setNotification(webNotifEntity);
                if (isParamNew) {
                    this.webParamsDAO.create(webParamsEntity);
                    continue;
                }
                this.webParamsDAO.update(webParamsEntity);
            }
        }
        webUsersEntity.setReceiver(notification.getTo());
        Calendar calendar = Calendar.getInstance();
        if (moveTop) {
            webUsersEntity.setUpdateDate(calendar);
        } else if (notification.getLastModifiedDate() > 0L) {
            calendar.setTimeInMillis(notification.getLastModifiedDate());
            webUsersEntity.setUpdateDate(calendar);
        } else {
            webUsersEntity.setUpdateDate(webNotifEntity.getCreationDate());
        }
        webUsersEntity.setShowPopover(notification.isOnPopOver());
        webUsersEntity.setResetNumberOnBadge(notification.isResetOnBadge());
        webUsersEntity.setRead(notification.isRead());
        webUsersEntity.setNotification(webNotifEntity);
        if (isNew) {
            webUsersEntity = this.webUsersDAO.create(webUsersEntity);
            notification.setId(String.valueOf(webUsersEntity.getId()));
        } else {
            this.webUsersDAO.update(webUsersEntity);
        }
    }

    private long parseNotificationId(String notificationId) {
        return Long.parseLong(notificationId);
    }

    @ExoTransactional
    private WebUsersEntity getWebNotification(Long notificationId) {
        Long l = notificationId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this, (Object)l);
        return (WebUsersEntity)JPAWebNotificationStorage.getWebNotification_aroundBody27$advice(this, l, joinPoint, ExoTransactionalAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    static {
        JPAWebNotificationStorage.ajc$preClinit();
        LOG = ExoLogger.getLogger(JPAWebNotificationStorage.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object save_aroundBody1$advice(JPAWebNotificationStorage ajc$this, NotificationInfo notification, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            ajc$this.save(notification, false);
            Object var11_14 = result = null;
            return var11_14;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ List get_aroundBody2(JPAWebNotificationStorage ajc$this, WebNotificationFilter filter, int offset, int limit, JoinPoint joinPoint) {
        ArrayList<NotificationInfo> result = new ArrayList<NotificationInfo>();
        String pluginId = filter.getPluginKey() != null ? filter.getPluginKey().getId() : null;
        String userId = filter.getUserId();
        Pair parameter = filter.getParameter();
        String paramName = null;
        String paramValue = null;
        if (parameter != null) {
            paramName = (String)parameter.getKey();
            paramValue = (String)parameter.getValue();
        }
        List<WebUsersEntity> webUsersEntities = paramName != null && paramValue != null && pluginId != null ? ajc$this.webUsersDAO.findNotificationsByTypeAndParams(pluginId, paramName, paramValue, userId, offset, limit) : (pluginId != null ? ajc$this.webUsersDAO.findWebNotifsByFilter(pluginId, userId, filter.isOnPopover(), offset, limit) : (filter.isOnPopover() ? ajc$this.webUsersDAO.findWebNotifsByFilter(userId, filter.isOnPopover(), offset, limit) : ajc$this.webUsersDAO.findWebNotifsByFilter(userId, offset, limit)));
        for (WebUsersEntity webUserNotifEntity : webUsersEntities) {
            result.add(EntityConverter.convertWebNotifEntityToNotificationInfo(webUserNotifEntity));
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object get_aroundBody3$advice(JPAWebNotificationStorage ajc$this, WebNotificationFilter filter, int offset, int limit, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            List result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            List list = result = JPAWebNotificationStorage.get_aroundBody2(ajc$this, filter, offset, limit, (JoinPoint)proceedingJoinPoint);
            return list;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ NotificationInfo get_aroundBody4(JPAWebNotificationStorage ajc$this, String id, JoinPoint joinPoint) {
        if (StringUtils.isBlank((String)id) || id.startsWith("NotificationMessage")) {
            return null;
        }
        WebUsersEntity webUsersEntity = ajc$this.getWebNotification(ajc$this.parseNotificationId(id));
        if (webUsersEntity != null) {
            return EntityConverter.convertWebNotifEntityToNotificationInfo(webUsersEntity);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object get_aroundBody5$advice(JPAWebNotificationStorage ajc$this, String id, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            NotificationInfo result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            NotificationInfo notificationInfo = result = JPAWebNotificationStorage.get_aroundBody4(ajc$this, id, (JoinPoint)proceedingJoinPoint);
            return notificationInfo;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ boolean remove_aroundBody6(JPAWebNotificationStorage ajc$this, String notificationId, JoinPoint joinPoint) {
        WebUsersEntity webUsersEntity = ajc$this.getWebNotification(ajc$this.parseNotificationId(notificationId));
        if (webUsersEntity != null) {
            ajc$this.webUsersDAO.delete(webUsersEntity);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object remove_aroundBody7$advice(JPAWebNotificationStorage ajc$this, String notificationId, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            Object object = result = Conversions.booleanObject((boolean)JPAWebNotificationStorage.remove_aroundBody6(ajc$this, notificationId, (JoinPoint)proceedingJoinPoint));
            return object;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ boolean remove_aroundBody8(JPAWebNotificationStorage ajc$this, long seconds, JoinPoint joinPoint) {
        boolean removed = false;
        Calendar cal = Calendar.getInstance();
        long delayTime = System.currentTimeMillis() - seconds * 1000L;
        cal.setTimeInMillis(delayTime);
        ArrayList<WebNotifEntity> notifEntities = new ArrayList<WebNotifEntity>();
        List<WebUsersEntity> webUserNotifs = ajc$this.webUsersDAO.findWebNotifsByLastUpdatedDate(cal);
        for (WebUsersEntity webUsersEntity : webUserNotifs) {
            WebNotifEntity notification = webUsersEntity.getNotification();
            if (!notifEntities.contains(notification)) {
                notifEntities.add(notification);
            }
            ajc$this.webUsersDAO.delete(webUsersEntity);
        }
        boolean bl = removed = notifEntities.size() > 0;
        if (removed) {
            for (WebNotifEntity webNotifEntity : notifEntities) {
                ajc$this.webParamsDAO.deleteAll(new ArrayList<WebParamsEntity>(webNotifEntity.getParameters()));
            }
            ajc$this.webNotifDAO.deleteAll(notifEntities);
        }
        return removed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object remove_aroundBody9$advice(JPAWebNotificationStorage ajc$this, long seconds, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            Object object = result = Conversions.booleanObject((boolean)JPAWebNotificationStorage.remove_aroundBody8(ajc$this, seconds, (JoinPoint)proceedingJoinPoint));
            return object;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ boolean remove_aroundBody10(JPAWebNotificationStorage ajc$this, String userId, long seconds, JoinPoint joinPoint) {
        Calendar calendar = Calendar.getInstance();
        long timeInMilliseconds = calendar.getTimeInMillis() - seconds * 1000L;
        calendar.setTimeInMillis(timeInMilliseconds);
        boolean removed = false;
        for (WebUsersEntity webUsersEntity : ajc$this.webUsersDAO.findWebNotifsOfUserByLastUpdatedDate(userId, calendar)) {
            try {
                ajc$this.webUsersDAO.delete(webUsersEntity);
                removed = true;
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to remove notification with id '" + webUsersEntity.getId() + "' for the user id: " + userId), (Throwable)e);
                return false;
            }
        }
        return removed;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object remove_aroundBody11$advice(JPAWebNotificationStorage ajc$this, String userId, long seconds, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            Object object = result = Conversions.booleanObject((boolean)JPAWebNotificationStorage.remove_aroundBody10(ajc$this, userId, seconds, (JoinPoint)proceedingJoinPoint));
            return object;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void markRead_aroundBody12(JPAWebNotificationStorage ajc$this, String notificationId, JoinPoint joinPoint) {
        long notifIdLong = ajc$this.parseNotificationId(notificationId);
        WebUsersEntity webUsersEntity = (WebUsersEntity)ajc$this.webUsersDAO.find(notifIdLong);
        if (webUsersEntity != null) {
            webUsersEntity.setRead(true);
            ajc$this.webUsersDAO.update(webUsersEntity);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object markRead_aroundBody13$advice(JPAWebNotificationStorage ajc$this, String notificationId, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            JPAWebNotificationStorage.markRead_aroundBody12(ajc$this, notificationId, (JoinPoint)proceedingJoinPoint);
            Object var11_14 = result = null;
            return var11_14;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void hidePopover_aroundBody14(JPAWebNotificationStorage ajc$this, String notificationId, JoinPoint joinPoint) {
        WebUsersEntity webUsersEntity = (WebUsersEntity)ajc$this.webUsersDAO.find(ajc$this.parseNotificationId(notificationId));
        if (webUsersEntity != null) {
            webUsersEntity.setShowPopover(false);
            ajc$this.webUsersDAO.update(webUsersEntity);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object hidePopover_aroundBody15$advice(JPAWebNotificationStorage ajc$this, String notificationId, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            JPAWebNotificationStorage.hidePopover_aroundBody14(ajc$this, notificationId, (JoinPoint)proceedingJoinPoint);
            Object var11_14 = result = null;
            return var11_14;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void markAllRead_aroundBody16(JPAWebNotificationStorage ajc$this, String userId, JoinPoint joinPoint) {
        ajc$this.webUsersDAO.markAllRead(userId);
        ajc$this.userSettingService.saveLastReadDate(userId, Long.valueOf(System.currentTimeMillis()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object markAllRead_aroundBody17$advice(JPAWebNotificationStorage ajc$this, String userId, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            JPAWebNotificationStorage.markAllRead_aroundBody16(ajc$this, userId, (JoinPoint)proceedingJoinPoint);
            Object var11_14 = result = null;
            return var11_14;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ NotificationInfo getUnreadNotification_aroundBody18(JPAWebNotificationStorage ajc$this, String pluginId, String activityId, String userId, JoinPoint joinPoint) {
        List<WebUsersEntity> list = ajc$this.webUsersDAO.findUnreadNotification(pluginId, userId, "activityId", activityId);
        if (list.size() > 0) {
            WebUsersEntity webUsersNotification = list.get(0);
            return EntityConverter.convertWebNotifEntityToNotificationInfo(webUsersNotification);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object getUnreadNotification_aroundBody19$advice(JPAWebNotificationStorage ajc$this, String pluginId, String activityId, String userId, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            NotificationInfo result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            NotificationInfo notificationInfo = result = JPAWebNotificationStorage.getUnreadNotification_aroundBody18(ajc$this, pluginId, activityId, userId, (JoinPoint)proceedingJoinPoint);
            return notificationInfo;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object update_aroundBody21$advice(JPAWebNotificationStorage ajc$this, NotificationInfo notification, boolean moveTop, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            ajc$this.save(notification, moveTop);
            Object var12_15 = result = null;
            return var12_15;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object getNumberOnBadge_aroundBody23$advice(JPAWebNotificationStorage ajc$this, String userId, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            Object object = result = Conversions.intObject((int)ajc$this.webUsersDAO.getNumberOnBadge(userId));
            return object;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void resetNumberOnBadge_aroundBody24(JPAWebNotificationStorage ajc$this, String userId, JoinPoint joinPoint) {
        List<WebUsersEntity> notifsWithBadge = ajc$this.webUsersDAO.findNotifsWithBadge(userId);
        if (notifsWithBadge != null && notifsWithBadge.size() > 0) {
            for (WebUsersEntity webUsersEntity : notifsWithBadge) {
                webUsersEntity.setResetNumberOnBadge(true);
            }
            ajc$this.webUsersDAO.updateAll(notifsWithBadge);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object resetNumberOnBadge_aroundBody25$advice(JPAWebNotificationStorage ajc$this, String userId, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            Object result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            JPAWebNotificationStorage.resetNumberOnBadge_aroundBody24(ajc$this, userId, (JoinPoint)proceedingJoinPoint);
            Object var11_14 = result = null;
            return var11_14;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ WebUsersEntity getWebNotification_aroundBody26(JPAWebNotificationStorage ajc$this, Long notificationId, JoinPoint joinPoint) {
        return (WebUsersEntity)ajc$this.webUsersDAO.find(notificationId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static /* synthetic */ Object getWebNotification_aroundBody27$advice(JPAWebNotificationStorage ajc$this, Long notificationId, JoinPoint thisJoinPoint, ExoTransactionalAspect ajc$aspectInstance, ProceedingJoinPoint point) {
        boolean begunTx = false;
        boolean emStarted = false;
        EntityManagerService service = (EntityManagerService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(EntityManagerService.class);
        EntityManager entityManager = service.getEntityManager();
        if (entityManager == null) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Injecting new PersistenceContext");
            entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
            emStarted = true;
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using existing PersistenceContext");
        }
        EntityTransaction tx = entityManager.getTransaction();
        if (tx.isActive()) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Using current transaction");
        } else {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Starting new transaction");
            try {
                tx.begin();
            }
            catch (PersistenceException | TransactionException e) {
                ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while starting JPA transaction. The transaction will be restarted.", e);
                try {
                    ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                }
                catch (Exception e1) {
                    ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().warn((Object)"An error occured while closing current JPA entity manager. The transaction will be recreated.", e);
                }
                entityManager = ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$createEntityManager(service);
                tx = entityManager.getTransaction();
                tx.begin();
            }
            begunTx = true;
        }
        try {
            WebUsersEntity result;
            ProceedingJoinPoint proceedingJoinPoint = point;
            WebUsersEntity webUsersEntity = result = JPAWebNotificationStorage.getWebNotification_aroundBody26(ajc$this, notificationId, (JoinPoint)proceedingJoinPoint);
            return webUsersEntity;
        }
        catch (RuntimeException e) {
            ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Error while processing transactional method.", (Throwable)e);
            throw e;
        }
        finally {
            block29: {
                try {
                    if (!begunTx || !tx.isActive()) break block29;
                    if (!tx.getRollbackOnly()) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Committing current transaction");
                        tx.commit();
                    } else {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().debug((Object)"Rollback current transaction set as RollbackOnly");
                        tx.rollback();
                    }
                }
                catch (RuntimeException ex) {
                    try {
                        if (tx == null) throw ex;
                        if (!tx.isActive()) throw ex;
                        tx.rollback();
                        throw ex;
                    }
                    catch (RuntimeException rbEx) {
                        ExoTransactionalAspect.ajc$inlineAccessFieldGet$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$LOG().error((Object)"Could not roll back transaction", (Throwable)rbEx);
                    }
                    throw ex;
                }
                finally {
                    if (emStarted && entityManager != null) {
                        ExoTransactionalAspect.ajc$inlineAccessMethod$org_exoplatform_commons_persistence_impl_ExoTransactionalAspect$org_exoplatform_commons_persistence_impl_EntityManagerService$closeEntityManager(service);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JPAWebNotificationStorage.java", JPAWebNotificationStorage.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "save", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "org.exoplatform.commons.api.notification.model.NotificationInfo", "notification", "", "void"), 56);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "get", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "org.exoplatform.commons.api.notification.model.WebNotificationFilter:int:int", "filter:offset:limit", "", "java.util.List"), 62);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "org.exoplatform.commons.api.notification.model.NotificationInfo:boolean", "notification:moveTop", "", "void"), 206);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getNumberOnBadge", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "userId", "", "int"), 212);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resetNumberOnBadge", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "userId", "", "void"), 218);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "getWebNotification", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.Long", "notificationId", "", "org.exoplatform.commons.notification.impl.jpa.web.entity.WebUsersEntity"), 325);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "get", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "id", "", "org.exoplatform.commons.api.notification.model.NotificationInfo"), 93);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "notificationId", "", "boolean"), 106);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "long", "seconds", "", "boolean"), 117);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "remove", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String:long", "userId:seconds", "", "boolean"), 143);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "markRead", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "notificationId", "", "void"), 163);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hidePopover", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "notificationId", "", "void"), 174);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "markAllRead", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String", "userId", "", "void"), 185);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUnreadNotification", "org.exoplatform.commons.notification.impl.jpa.web.JPAWebNotificationStorage", "java.lang.String:java.lang.String:java.lang.String", "pluginId:activityId:userId", "", "org.exoplatform.commons.api.notification.model.NotificationInfo"), 192);
    }
}

